/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.test;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InternalURI;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.AclService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.util.test.BaseServiceSetupTestNG;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.acl.AclEntry;
import org.springframework.security.acl.AclProvider;
import org.springframework.security.acl.basic.BasicAclEntry;
import org.springframework.security.acl.basic.SimpleAclEntry;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ObjectPermissionServiceTestTestNG
extends BaseServiceSetupTestNG {
    protected static Log m_logger = LogFactory.getLog(ObjectPermissionServiceTestTestNG.class);
    public static String reportsFolderPath = "/reports";
    public static String reportUnitFolder = reportsFolderPath + "/" + "samples";
    public static String reportUnitName = "AllAccounts";
    public static String reportUnitPath = reportUnitFolder + "/" + reportUnitName;
    public static final String USER_ADMIN = "admin";
    public static String USER_TEST = "TestUser";
    public static String ROLE_TEST = "ROLE_TEST";
    ReportUnit m_unit;
    Role m_userRole;
    Role m_adminRole;
    Role m_testRole;
    User m_adminUser;
    User m_testUser;
    Folder m_reportsFolder;

    public ObjectPermissionServiceTestTestNG() {
        m_logger.info((Object)"ObjectPermissionServiceTestTestNG => constructor() called");
    }

    @BeforeClass
    protected void onSetUp() throws Exception {
        m_logger.info((Object)"ObjectPermissionServiceTestTestNG => onSetUp() called");
        this.setUpRoles();
        this.setUpUsers();
        this.setAuthenticatedUser(USER_ADMIN);
        this.createObjectPermission("/", this.m_adminRole, SimpleAclEntry.ADMINISTRATION);
        this.m_reportsFolder = this.getRepositoryService().getFolder(null, reportsFolderPath);
        AssertJUnit.assertTrue((String)"null m_reportsFolder", (this.m_reportsFolder != null ? 1 : 0) != 0);
        this.m_unit = (ReportUnit)this.getRepositoryService().getResource(null, reportUnitPath);
        AssertJUnit.assertNotNull((String)"Null ReportUnit", (Object)this.m_unit);
        AssertJUnit.assertEquals((String)"Unmatched ReportUnit name", (String)reportUnitName, (String)this.m_unit.getName());
    }

    private void setUpRoles() {
        this.m_userRole = this.getRole("ROLE_USER");
        this.m_adminRole = this.getRole("ROLE_ADMINISTRATOR");
        this.m_testRole = this.createRole(ROLE_TEST);
    }

    private void setUpUsers() {
        this.m_testUser = this.createUser(USER_TEST, USER_TEST, USER_TEST);
        this.getUserAuthorityService().addRole(null, this.m_testUser, this.m_testRole);
        this.m_adminUser = this.createUser(USER_ADMIN, USER_ADMIN, USER_ADMIN);
        this.getUserAuthorityService().addRole(null, this.m_adminUser, this.m_adminRole);
    }

    @AfterClass
    public void onTearDown() {
        m_logger.info((Object)"ObjectPermissionServiceTestTestNG => onTearDown() called");
        User testUser = this.getUserAuthorityService().getUser(null, USER_TEST);
        this.deleteObjectPermission(reportUnitPath, testUser);
        m_logger.info((Object)("ObjectPermissionServiceTestTestNG => onTearDown() - Deleting permission for ROLE_USER and ROLE_ADMINISTRATOR for " + reportUnitFolder));
        this.deleteObjectPermission(reportUnitFolder, this.m_userRole);
        this.deleteObjectPermission(reportUnitFolder, this.m_adminRole);
        m_logger.info((Object)"ObjectPermissionServiceTestTestNG => onTearDown() - Deleting permission for ROLE_USER and /");
        this.deleteObjectPermission("/", this.m_userRole);
        m_logger.info((Object)("ObjectPermissionServiceTestTestNG => onTearDown() - Removing role: " + this.m_adminRole.getRoleName() + " from user: " + this.m_testUser.getUsername()));
        this.getUserAuthorityService().removeRole(null, this.m_testUser, this.m_adminRole);
        User u = this.getUserAuthorityService().getUser(null, this.m_testUser.getUsername());
        m_logger.info((Object)"ObjectPermissionServiceTestTestNG => onTearDown() - test user assigned roles are: ");
        for (Role role : u.getRoles()) {
            m_logger.info((Object)("\t" + role.getRoleName()));
        }
        m_logger.info((Object)("ObjectPermissionServiceTestTestNG => onTearDown() - delete the " + USER_TEST));
        this.getUserAuthorityService().deleteUser(null, USER_TEST);
        m_logger.info((Object)("ObjectPermissionServiceTestTestNG => onTearDown() - delete the " + ROLE_TEST));
        this.getUserAuthorityService().deleteRole(null, ROLE_TEST);
    }

    @Test
    public void doObjectPermissionSetupTest() {
        m_logger.info((Object)"ObjectPermissionServiceTestTestNG => doObjectPermissionSetupTest() called");
        this.setAuthenticatedUser(USER_ADMIN);
        List l = this.getObjectPermissionService().getObjectPermissionsForObjectAndRecipient(null, (Object)this.m_unit, (Object)this.m_adminRole);
        AssertJUnit.assertTrue((String)("getObjectPermissionsForObjectAndRecipient size not 0: " + (l == null ? "null" : new Integer(l.size()).toString())), (l == null || l.size() == 0 ? 1 : 0) != 0);
        ReportUnit ru = (ReportUnit)this.getRepositoryService().getResource(null, this.m_unit.getURI());
        AssertJUnit.assertTrue((String)("Null report unit for " + this.m_unit.getURI()), (ru != null ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)ru.getName().equals(reportUnitName));
        String p = ru.getParentFolder();
        Folder f = this.getRepositoryService().getFolder(null, p);
        AssertJUnit.assertTrue((String)("Invalid folder: " + p), (f != null ? 1 : 0) != 0);
        l = this.getObjectPermissionService().getObjectPermissionsForObject(null, (Object)f);
        m_logger.info((Object)("ObjectPermission for unit folder: " + l));
        AssertJUnit.assertTrue((String)("getObjectPermissionsForObject size not 0: " + (l == null ? "null" : new Integer(l.size()).toString())), (l == null || l.size() == 0 ? 1 : 0) != 0);
    }

    @Test(dependsOnMethods={"doObjectPermissionSetupTest"})
    public void doAclAccessTest() {
        m_logger.info((Object)"ObjectPermissionServiceTestTestNG => doAclAccessTest() called");
        Authentication aUser = this.setAuthenticatedUser(USER_ADMIN);
        BasicAclEntry[] aclEntries = ((AclService)this.getObjectPermissionService()).getAcls((InternalURI)this.m_unit);
        AssertJUnit.assertTrue((String)"aclEntries = null", (aclEntries != null ? 1 : 0) != 0);
        this.printAclEntries("getAcls(m_unit)", aclEntries);
        AssertJUnit.assertTrue((String)("aclEntries.length = " + aclEntries.length + " not 2"), (aclEntries.length == 3 ? 1 : 0) != 0);
        AclEntry[] userEntries = ((AclProvider)this.getObjectPermissionService()).getAcls((Object)this.m_unit, aUser);
        AssertJUnit.assertTrue((String)"userEntries = null", (userEntries != null ? 1 : 0) != 0);
        this.printAclEntries("getAcls(m_unit, aUser)", (BasicAclEntry[])userEntries);
        AclEntry found = null;
        for (int i = 0; i < userEntries.length && found == null; ++i) {
            Object entry = ((BasicAclEntry)userEntries[i]).getRecipient();
            found = entry instanceof Role && ((Role)entry).getRoleName().equals("ROLE_ADMINISTRATOR") ? userEntries[i] : null;
        }
        AssertJUnit.assertTrue((String)"Role recipient not found", (found != null ? 1 : 0) != 0);
    }

    @Test(dependsOnMethods={"doAclAccessTest"})
    public void doMethodAndObjectAccessTest() {
        m_logger.info((Object)"ObjectPermissionServiceTestTestNG => doMethodAndObjectAccessTest() called");
        this.setAuthenticatedUser(USER_ADMIN);
        AssertJUnit.assertNotNull((String)"null testUserName", (Object)USER_TEST);
        this.exerciseResourcesListAccess(USER_ADMIN, true, "ERROR: Administrator should have access to report unit via role at root", "Administrator has access to report unit");
        m_logger.info((Object)"ObjectPermissionServiceTestTestNG => doMethodAndObjectAccessTest() - Administrator has access to report unit");
        this.exerciseResourcesListAccess(USER_TEST, false, "ERROR: ROLE_TEST should not have access to report unit because there is no permissions for ROLE_TEST or this user", "ROLE_TEST does not have access to report unit");
        m_logger.info((Object)"ObjectPermissionServiceTestTestNG => doMethodAndObjectAccessTest() - ROLE_TEST does not have access to report unit");
        this.setAuthenticatedUser(USER_ADMIN);
        ObjectPermission op = this.createObjectPermission(reportUnitPath, this.m_testUser, SimpleAclEntry.READ);
        this.exerciseResourcesListAccess(USER_TEST, true, "ERROR: Test user should have specific access to report unit", "Test user has access to report unit");
        m_logger.info((Object)"ObjectPermissionServiceTestTestNG => doMethodAndObjectAccessTest() - Test user has access to report unit");
        this.setAuthenticatedUser(USER_ADMIN);
        this.getObjectPermissionService().deleteObjectPermission(null, op);
        this.getUserAuthorityService().addRole(null, this.m_testUser, this.m_adminRole);
        this.exerciseResourcesListAccess(USER_TEST, true, "ERROR: ROLE_ADMINISTRATOR should have access to root level", "ROLE_ADMINISTRATOR given access to root level");
        m_logger.info((Object)"ObjectPermissionServiceTestTestNG => doMethodAndObjectAccessTest() - ROLE_ADMINISTRATOR given access to root level");
        try {
            this.getRepositoryService().getResource(null, reportUnitFolder);
            m_logger.info((Object)("OK: had access to " + reportUnitFolder));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)("ERROR: had no access to " + reportUnitFolder + ": " + e.getMessage()));
            e.printStackTrace();
        }
    }

    private void printAclEntries(String name, BasicAclEntry[] aclEntries) {
        m_logger.info((Object)("AclEntry set: " + name));
        for (int i = 0; aclEntries != null && aclEntries.length > 0 && i < aclEntries.length; ++i) {
            m_logger.info((Object)("aclEntries[" + i + "]: " + aclEntries[i].getAclObjectIdentity() + "\n\tparent: " + aclEntries[i].getAclObjectParentIdentity() + "\n\trecipient: " + aclEntries[i].getRecipient() + "\n\tmask: " + aclEntries[i].getMask()));
        }
    }

    private void exerciseResourcesListAccess(String userName, boolean expectToFind, String testDescription, String successMessage) {
        FilterCriteria criteria = FilterCriteria.createFilter(ReportUnit.class);
        this.setAuthenticatedUser(userName);
        boolean found = false;
        try {
            List l = this.getRepositoryService().loadResourcesList(criteria);
            m_logger.info((Object)(testDescription + "\nloadResourcesList size: " + l.size()));
            Iterator it = l.iterator();
            found = false;
            while (it.hasNext() && !found) {
                ResourceLookup rlu = (ResourceLookup)it.next();
                found = rlu.getURIString().equals(reportUnitPath);
            }
            if (found != expectToFind) {
                AssertJUnit.fail((String)(userName + ": loadResourcesList " + (expectToFind ? "did not contain " : "contained un") + "expected report unit for " + reportUnitName));
            }
        }
        catch (AccessDeniedException ex) {
            AssertJUnit.fail((String)(userName + ": loadResourcesList AccessDeniedException unexpected"));
        }
        m_logger.info((Object)successMessage);
    }
}

