/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.test;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRepositoryDestination;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSimpleTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSource;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSummary;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.test.BaseRepositoryTestTestNG;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.acl.basic.SimpleAclEntry;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class RepositoryMoveAndCopyTestsTestNG
extends BaseRepositoryTestTestNG {
    protected final Log m_logger = LogFactory.getLog(RepositoryMoveAndCopyTestsTestNG.class);

    @Test
    public void doResourceMoveTest() throws Exception {
        this.m_logger.info((Object)"doResourceMoveTest() called");
        this.executeInTempFolder(new BaseRepositoryTestTestNG.Callback(){

            @Override
            public void execute() {
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.newResource(JndiJdbcReportDataSource.class, "ds");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTestsTestNG.this.saveResource((Resource)ds);
                Query query = (Query)RepositoryMoveAndCopyTestsTestNG.this.newResource(Query.class, "query");
                query.setLanguage("SQL");
                query.setSql("select");
                query.setDataSourceReference(ds.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.saveResource((Resource)query);
                Folder folder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder("m");
                RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().moveResource(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), ds.getURIString(), folder.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.assertResourceInexistent(ds.getURIString());
                JndiJdbcReportDataSource movedDS = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(JndiJdbcReportDataSource.class, folder.getURIString(), ds.getName());
                AssertJUnit.assertEquals((String)"ds-jndi", (String)movedDS.getJndiName());
                Query updatedQuery = (Query)RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(Query.class, query.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.assertExternalReference(updatedQuery.getDataSource(), movedDS.getURIString());
            }
        });
    }

    @Test
    public void doFolderMoveTest() throws Exception {
        this.m_logger.info((Object)"doFolderMoveTest() called");
        this.executeInTempFolder(new BaseRepositoryTestTestNG.Callback(){

            @Override
            public void execute() {
                Folder folder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder("m");
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.newResource(JndiJdbcReportDataSource.class, folder, "ds");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTestsTestNG.this.saveResource((Resource)ds);
                Folder subFolder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder(folder, "s");
                Query query = (Query)RepositoryMoveAndCopyTestsTestNG.this.newResource(Query.class, subFolder, "query");
                query.setLanguage("SQL");
                query.setSql("select");
                query.setDataSourceReference(ds.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.saveResource((Resource)query);
                Folder destinationFolder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder("f");
                RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().moveFolder(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), folder.getURIString(), destinationFolder.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.assertFolderInexistent(folder.getURIString());
                Folder movedFolder = RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(destinationFolder, folder.getName());
                Resource movedDS = RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(JndiJdbcReportDataSource.class, movedFolder, ds.getName());
                Folder movedSubFolder = RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(movedFolder, subFolder.getName());
                Query movedQuery = (Query)RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(Query.class, movedSubFolder, query.getName());
                RepositoryMoveAndCopyTestsTestNG.this.assertExternalReference(movedQuery.getDataSource(), movedDS.getURIString());
            }
        });
    }

    @Test
    public void doResourceCopyTest() throws Exception {
        this.m_logger.info((Object)"doResourceCopyTest() called");
        this.executeInTempFolder(new BaseRepositoryTestTestNG.Callback(){

            @Override
            public void execute() {
                Query query = (Query)RepositoryMoveAndCopyTestsTestNG.this.newResource(Query.class, "query");
                query.setLanguage("SQL");
                query.setSql("select");
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.newResource(JndiJdbcReportDataSource.class, "ds");
                ds.setJndiName("ds-jndi");
                query.setDataSource((ReportDataSource)ds);
                RepositoryMoveAndCopyTestsTestNG.this.saveResource((Resource)query);
                String copyUri = RepositoryMoveAndCopyTestsTestNG.this.makeUri("q2");
                RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().copyResource(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), query.getURIString(), copyUri);
                RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(Query.class, query.getURIString());
                Query queryCopy = (Query)RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(Query.class, copyUri);
                AssertJUnit.assertEquals((String)"SQL", (String)queryCopy.getLanguage());
                AssertJUnit.assertEquals((String)"select", (String)queryCopy.getSql());
                JndiJdbcReportDataSource copyDS = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.assertLocalReference(query.getDataSource(), JndiJdbcReportDataSource.class);
                AssertJUnit.assertEquals((String)"ds-jndi", (String)copyDS.getJndiName());
            }
        });
    }

    @Test
    public void doFolderCopyTest() throws Exception {
        this.m_logger.info((Object)"doFolderCopyTest() called");
        this.executeInTempFolder(new BaseRepositoryTestTestNG.Callback(){

            @Override
            public void execute() {
                Folder folder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder("m");
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.newResource(JndiJdbcReportDataSource.class, folder, "ds");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTestsTestNG.this.saveResource((Resource)ds);
                Folder subFolder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder(folder, "s");
                Query query = (Query)RepositoryMoveAndCopyTestsTestNG.this.newResource(Query.class, subFolder, "query");
                query.setLanguage("SQL");
                query.setSql("select");
                query.setDataSourceReference(ds.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.saveResource((Resource)query);
                String copyUri = RepositoryMoveAndCopyTestsTestNG.this.makeUri("m_copy");
                RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().copyFolder(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), folder.getURIString(), copyUri);
                RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(folder.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(JndiJdbcReportDataSource.class, folder, ds.getName());
                RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(folder, subFolder.getName());
                Query reQuery = (Query)RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(Query.class, subFolder, query.getName());
                RepositoryMoveAndCopyTestsTestNG.this.assertExternalReference(reQuery.getDataSource(), ds.getURIString());
                Folder folderCopy = RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(copyUri);
                JndiJdbcReportDataSource dsCopy = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(JndiJdbcReportDataSource.class, folderCopy, ds.getName());
                AssertJUnit.assertEquals((String)"ds-jndi", (String)dsCopy.getJndiName());
                Folder subFolderCopy = RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(folderCopy, subFolder.getName());
                Query queryCopy = (Query)RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(Query.class, subFolderCopy, query.getName());
                AssertJUnit.assertEquals((String)"select", (String)queryCopy.getSql());
                RepositoryMoveAndCopyTestsTestNG.this.assertExternalReference(queryCopy.getDataSource(), dsCopy.getURIString());
            }
        });
    }

    @Test
    public void doResourceOverwriteSameTypeTest() throws Exception {
        this.m_logger.info((Object)"doResourceOverwriteSameTypeTest() called");
        this.executeInTempFolder(new BaseRepositoryTestTestNG.Callback(){

            @Override
            public void execute() {
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.newResource(JndiJdbcReportDataSource.class, "ds");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTestsTestNG.this.saveResource((Resource)ds);
                Folder folder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder("m");
                JndiJdbcReportDataSource ds2 = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.newResource(JndiJdbcReportDataSource.class, folder, "ds");
                ds2.setJndiName("ds2-jndi");
                RepositoryMoveAndCopyTestsTestNG.this.saveResource((Resource)ds2);
                Resource copy = RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().copyResource(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), ds.getURIString(), ds2.getURIString());
                AssertJUnit.assertNotNull((Object)copy);
                AssertJUnit.assertEquals((String)folder.getURIString(), (String)copy.getParentFolder());
                AssertJUnit.assertEquals((String)"ds_1", (String)copy.getName());
                AssertJUnit.assertTrue((boolean)(copy instanceof JndiJdbcReportDataSource));
                AssertJUnit.assertEquals((String)"ds-jndi", (String)((JndiJdbcReportDataSource)copy).getJndiName());
                RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(JndiJdbcReportDataSource.class, ds.getURIString());
                JndiJdbcReportDataSource ds2Reloaded = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(JndiJdbcReportDataSource.class, ds2.getURIString());
                AssertJUnit.assertEquals((String)"ds2-jndi", (String)ds2Reloaded.getJndiName());
                boolean exception = false;
                try {
                    RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().moveResource(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), ds.getURIString(), folder.getURIString());
                }
                catch (JSException e) {
                    exception = true;
                    AssertJUnit.assertEquals((String)"jsexception.move.resource.path.already.exists", (String)e.getMessage());
                }
                AssertJUnit.assertTrue((boolean)exception);
                JndiJdbcReportDataSource dsReloaded = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(JndiJdbcReportDataSource.class, ds.getURIString());
                AssertJUnit.assertEquals((String)"ds-jndi", (String)dsReloaded.getJndiName());
                ds2Reloaded = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(JndiJdbcReportDataSource.class, ds2.getURIString());
                AssertJUnit.assertEquals((String)"ds2-jndi", (String)ds2Reloaded.getJndiName());
            }
        });
    }

    @Test
    public void doResourceOverwriteOtherTypeTest() throws Exception {
        this.m_logger.info((Object)"doResourceOverwriteOtherTypeTest() called");
        this.executeInTempFolder(new BaseRepositoryTestTestNG.Callback(){

            @Override
            public void execute() {
                Folder folder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder("m");
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.newResource(JndiJdbcReportDataSource.class, folder, "ds");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTestsTestNG.this.saveResource((Resource)ds);
                DataType dt = (DataType)RepositoryMoveAndCopyTestsTestNG.this.newResource(DataType.class, "ds");
                dt.setType((byte)1);
                RepositoryMoveAndCopyTestsTestNG.this.saveResource((Resource)dt);
                Resource copy = RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().copyResource(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), ds.getURIString(), dt.getURIString());
                AssertJUnit.assertNotNull((Object)copy);
                AssertJUnit.assertEquals((String)"/unit_tests_tmp", (String)copy.getParentFolder());
                AssertJUnit.assertEquals((String)"ds_1", (String)copy.getName());
                AssertJUnit.assertTrue((boolean)(copy instanceof JndiJdbcReportDataSource));
                AssertJUnit.assertEquals((String)"ds-jndi", (String)((JndiJdbcReportDataSource)copy).getJndiName());
                Resource copy2 = RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().copyResource(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), ds.getURIString(), dt.getURIString());
                AssertJUnit.assertNotNull((Object)copy2);
                AssertJUnit.assertEquals((String)"/unit_tests_tmp", (String)copy2.getParentFolder());
                AssertJUnit.assertEquals((String)"ds_2", (String)copy2.getName());
                AssertJUnit.assertTrue((boolean)(copy2 instanceof JndiJdbcReportDataSource));
                AssertJUnit.assertEquals((String)"ds-jndi", (String)((JndiJdbcReportDataSource)copy2).getJndiName());
                RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(JndiJdbcReportDataSource.class, ds.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(DataType.class, dt.getURIString());
                boolean exception = false;
                try {
                    RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().moveResource(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), ds.getURIString(), "/unit_tests_tmp");
                }
                catch (JSException e) {
                    exception = true;
                    AssertJUnit.assertEquals((String)"jsexception.move.resource.path.already.exists", (String)e.getMessage());
                }
                AssertJUnit.assertTrue((boolean)exception);
                JndiJdbcReportDataSource dsReloaded = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(JndiJdbcReportDataSource.class, ds.getURIString());
                AssertJUnit.assertEquals((String)"ds-jndi", (String)dsReloaded.getJndiName());
                RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(DataType.class, dt.getURIString());
            }
        });
    }

    @Test
    public void doResourceOverwriteFolderTest() throws Exception {
        this.m_logger.info((Object)"doResourceOverwriteFolderTest() called");
        this.executeInTempFolder(new BaseRepositoryTestTestNG.Callback(){

            @Override
            public void execute() {
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.newResource(JndiJdbcReportDataSource.class, "ds");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTestsTestNG.this.saveResource((Resource)ds);
                Folder folder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder("m");
                Folder subFolder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder(folder, "ds");
                Resource copy = RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().copyResource(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), ds.getURIString(), subFolder.getURIString());
                AssertJUnit.assertNotNull((Object)copy);
                AssertJUnit.assertEquals((String)folder.getURIString(), (String)copy.getParentFolder());
                AssertJUnit.assertEquals((String)"ds_1", (String)copy.getName());
                AssertJUnit.assertTrue((boolean)(copy instanceof JndiJdbcReportDataSource));
                AssertJUnit.assertEquals((String)"ds-jndi", (String)((JndiJdbcReportDataSource)copy).getJndiName());
                Resource copy2 = RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().copyResource(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), ds.getURIString(), subFolder.getURIString());
                AssertJUnit.assertNotNull((Object)copy2);
                AssertJUnit.assertEquals((String)folder.getURIString(), (String)copy2.getParentFolder());
                AssertJUnit.assertEquals((String)"ds_2", (String)copy2.getName());
                AssertJUnit.assertTrue((boolean)(copy2 instanceof JndiJdbcReportDataSource));
                AssertJUnit.assertEquals((String)"ds-jndi", (String)((JndiJdbcReportDataSource)copy2).getJndiName());
                RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(JndiJdbcReportDataSource.class, ds.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.assertResourceInexistent(folder.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(folder.getURIString());
                boolean exception = false;
                try {
                    RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().moveResource(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), ds.getURIString(), folder.getURIString());
                }
                catch (JSException e) {
                    exception = true;
                    AssertJUnit.assertEquals((String)"jsexception.move.resource.path.already.exists", (String)e.getMessage());
                }
                AssertJUnit.assertTrue((boolean)exception);
                JndiJdbcReportDataSource dsReloaded = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(JndiJdbcReportDataSource.class, ds.getURIString());
                AssertJUnit.assertEquals((String)"ds-jndi", (String)dsReloaded.getJndiName());
                RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(subFolder.getURIString());
            }
        });
    }

    @Test
    public void doResourcePermissionsTest() throws Exception {
        this.m_logger.info((Object)"doResourcePermissionsTest() called");
        this.executeInTempFolder(new BaseRepositoryTestTestNG.Callback(){

            @Override
            public void execute() {
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.newResource(JndiJdbcReportDataSource.class, "ds");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTestsTestNG.this.saveResource((Resource)ds);
                RepositoryMoveAndCopyTestsTestNG.this.setUserPermission(SimpleAclEntry.READ, ds.getURIString(), "joeuser");
                Folder folder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder("m");
                String copyURI = RepositoryMoveAndCopyTestsTestNG.this.makeUri("ds2");
                RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().copyResource(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), ds.getURIString(), copyURI);
                RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(JndiJdbcReportDataSource.class, ds.getURIString());
                JndiJdbcReportDataSource dsCopy = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(JndiJdbcReportDataSource.class, copyURI);
                List copyPermissions = RepositoryMoveAndCopyTestsTestNG.this.getPermissions((Resource)dsCopy);
                AssertJUnit.assertTrue((copyPermissions == null || copyPermissions.isEmpty() ? 1 : 0) != 0);
                RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().moveResource(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), ds.getURIString(), folder.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.assertResourceInexistent(ds.getURIString());
                JndiJdbcReportDataSource movedDS = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(JndiJdbcReportDataSource.class, folder, ds.getName());
                RepositoryMoveAndCopyTestsTestNG.this.assertUserPermission(SimpleAclEntry.READ, (Resource)movedDS, "joeuser");
            }
        });
    }

    public void SKIP_testReportUnit() throws Exception {
        this.m_logger.info((Object)"SKIP_testReportUnit() called");
        this.executeInTempFolder(new BaseRepositoryTestTestNG.Callback(){

            @Override
            public void execute() throws IOException {
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.newResource(JndiJdbcReportDataSource.class, "ds");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTestsTestNG.this.saveResource((Resource)ds);
                ReportUnit report = (ReportUnit)RepositoryMoveAndCopyTestsTestNG.this.newResource(ReportUnit.class, "report");
                report.setDataSourceReference(ds.getURIString());
                report.setMainReport(RepositoryMoveAndCopyTestsTestNG.this.newFileResource("main", "jrxml", "/reports/jasper/AllAccounts.jrxml"));
                report.addResource(RepositoryMoveAndCopyTestsTestNG.this.newFileResource("img", "img", "/images/jasperreports.png"));
                InputControl ic = (InputControl)RepositoryMoveAndCopyTestsTestNG.this.newResource(InputControl.class, "ic");
                ic.setType((byte)2);
                ic.setMandatory(true);
                DataType dt = (DataType)RepositoryMoveAndCopyTestsTestNG.this.newResource(DataType.class, "dt");
                dt.setType((byte)1);
                dt.setMaxLength(new Integer(20));
                ic.setDataType(dt);
                report.addInputControl(ic);
                RepositoryMoveAndCopyTestsTestNG.this.saveResource((Resource)report);
                ReportJobSource jobSource = new ReportJobSource();
                jobSource.setReportUnitURI(report.getURIString());
                Calendar future = Calendar.getInstance();
                future.add(1, 10);
                ReportJobSimpleTrigger trigger = new ReportJobSimpleTrigger();
                trigger.setStartDate(future.getTime());
                trigger.setOccurrenceCount(1);
                ReportJobRepositoryDestination repositoryDestination = new ReportJobRepositoryDestination();
                repositoryDestination.setFolderURI("/unit_tests_tmp");
                ReportJob job = new ReportJob();
                job.setLabel("foo");
                job.setSource(jobSource);
                job.setTrigger((ReportJobTrigger)trigger);
                job.setBaseOutputFilename("foo");
                job.addOutputFormat((byte)1);
                job.setContentRepositoryDestination(repositoryDestination);
                RepositoryMoveAndCopyTestsTestNG.this.getReportSchedulingService().scheduleJob(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), job);
                Folder folder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder("m");
                String copyURI = folder.getURIString() + "/" + "report2";
                RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().copyResource(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), report.getURIString(), copyURI);
                RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(ReportUnit.class, report.getURIString());
                ReportUnit reportCopy = (ReportUnit)RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(ReportUnit.class, copyURI);
                this.assertReportUnit(reportCopy);
                List copyJobs = RepositoryMoveAndCopyTestsTestNG.this.getReportSchedulingService().getScheduledJobSummaries(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), reportCopy.getURIString());
                AssertJUnit.assertTrue((copyJobs == null || copyJobs.isEmpty() ? 1 : 0) != 0);
                RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().moveResource(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), report.getURIString(), folder.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.assertResourceInexistent(report.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(JndiJdbcReportDataSource.class, ds.getURIString());
                ReportUnit movedReport = (ReportUnit)RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(ReportUnit.class, folder, report.getName());
                this.assertReportUnit(movedReport);
                List movedJobs = RepositoryMoveAndCopyTestsTestNG.this.getReportSchedulingService().getScheduledJobSummaries(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), movedReport.getURIString());
                AssertJUnit.assertNotNull((Object)movedJobs);
                AssertJUnit.assertEquals((int)1, (int)movedJobs.size());
                ReportJobSummary movedJob = (ReportJobSummary)movedJobs.get(0);
                AssertJUnit.assertEquals((String)"foo", (String)movedJob.getLabel());
                AssertJUnit.assertEquals((String)movedReport.getURIString(), (String)movedJob.getReportUnitURI());
            }

            protected void assertReportUnit(ReportUnit report) throws IOException {
                RepositoryMoveAndCopyTestsTestNG.this.assertExternalReference(report.getDataSource(), RepositoryMoveAndCopyTestsTestNG.this.makeUri("ds"));
                FileResource main = (FileResource)RepositoryMoveAndCopyTestsTestNG.this.assertLocalReference(report.getMainReport(), FileResource.class);
                AssertJUnit.assertEquals((String)"jrxml", (String)main.getFileType());
                RepositoryMoveAndCopyTestsTestNG.this.assertFileData(main, "/reports/jasper/AllAccounts.jrxml");
                List resources = report.getResources();
                AssertJUnit.assertNotNull((Object)resources);
                AssertJUnit.assertEquals((int)1, (int)resources.size());
                FileResource img = (FileResource)RepositoryMoveAndCopyTestsTestNG.this.assertLocalReference((ResourceReference)resources.get(0), FileResource.class);
                AssertJUnit.assertEquals((String)"img", (String)img.getFileType());
                RepositoryMoveAndCopyTestsTestNG.this.assertFileData(img, "/images/jasperreports.png");
                List inputControls = report.getInputControls();
                AssertJUnit.assertNotNull((Object)inputControls);
                AssertJUnit.assertEquals((int)1, (int)inputControls.size());
                InputControl movedIC = (InputControl)RepositoryMoveAndCopyTestsTestNG.this.assertLocalReference((ResourceReference)inputControls.get(0), InputControl.class);
                AssertJUnit.assertEquals((byte)2, (byte)movedIC.getType());
                AssertJUnit.assertTrue((boolean)movedIC.isMandatory());
                DataType movedDT = (DataType)RepositoryMoveAndCopyTestsTestNG.this.assertLocalReference(movedIC.getDataType(), DataType.class);
                AssertJUnit.assertEquals((byte)1, (byte)movedDT.getType());
                AssertJUnit.assertEquals((Object)new Integer(20), (Object)movedDT.getMaxLength());
            }
        });
    }

    @Test
    public void doFolderOverwriteResourceTest() throws Exception {
        this.m_logger.info((Object)"doFolderOverwriteResourceTest() called");
        this.executeInTempFolder(new BaseRepositoryTestTestNG.Callback(){

            @Override
            public void execute() {
                Folder folder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder("m");
                Folder destFolder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder("s");
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.newResource(JndiJdbcReportDataSource.class, destFolder, "m");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTestsTestNG.this.saveResource((Resource)ds);
                Folder copy = RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().copyFolder(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), folder.getURIString(), ds.getURIString());
                AssertJUnit.assertNotNull((Object)copy);
                AssertJUnit.assertEquals((String)destFolder.getURIString(), (String)copy.getParentFolder());
                AssertJUnit.assertEquals((String)"m_1", (String)copy.getName());
                RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(folder.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(JndiJdbcReportDataSource.class, destFolder, "m");
                boolean exception = false;
                try {
                    RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().moveFolder(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), folder.getURIString(), destFolder.getURIString());
                }
                catch (JSException e) {
                    exception = true;
                    AssertJUnit.assertEquals((String)"jsexception.move.folder.path.already.exists", (String)e.getMessage());
                }
                AssertJUnit.assertTrue((boolean)exception);
                RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(folder.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(JndiJdbcReportDataSource.class, destFolder, "m");
            }
        });
    }

    @Test
    public void doFolderOverwriteTest() throws Exception {
        this.m_logger.info((Object)"doFolderOverwriteTest() called");
        this.executeInTempFolder(new BaseRepositoryTestTestNG.Callback(){

            @Override
            public void execute() {
                Folder folder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder("m");
                Folder destFolder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder("s");
                RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder(destFolder, "m");
                Folder copy = RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().copyFolder(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), folder.getURIString(), destFolder.getURIString());
                AssertJUnit.assertNotNull((Object)copy);
                AssertJUnit.assertEquals((String)"/unit_tests_tmp", (String)copy.getParentFolder());
                AssertJUnit.assertEquals((String)"s_1", (String)copy.getName());
                Folder copy2 = RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().copyFolder(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), folder.getURIString(), destFolder.getURIString());
                AssertJUnit.assertNotNull((Object)copy2);
                AssertJUnit.assertEquals((String)"/unit_tests_tmp", (String)copy2.getParentFolder());
                AssertJUnit.assertEquals((String)"s_2", (String)copy2.getName());
                RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(folder.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(destFolder, "m");
                boolean exception = false;
                try {
                    RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().moveFolder(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), folder.getURIString(), destFolder.getURIString());
                }
                catch (JSException e) {
                    exception = true;
                    AssertJUnit.assertEquals((String)"jsexception.move.folder.path.already.exists", (String)e.getMessage());
                }
                AssertJUnit.assertTrue((boolean)exception);
                RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(folder.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(destFolder, "m");
            }
        });
    }

    @Test
    public void doFolderMoveAncestorTest() throws Exception {
        this.m_logger.info((Object)"doFolderMoveAncestorTest() called");
        this.executeInTempFolder(new BaseRepositoryTestTestNG.Callback(){

            @Override
            public void execute() {
                Folder folder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder("m");
                Folder destFolder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder(folder, "s");
                boolean exception = false;
                try {
                    RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().moveFolder(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), folder.getURIString(), destFolder.getURIString());
                }
                catch (JSException e) {
                    exception = true;
                    AssertJUnit.assertEquals((String)"jsexception.move.folder.source.uri.ancestor.destination", (String)e.getMessage());
                }
                AssertJUnit.assertTrue((boolean)exception);
                RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(folder.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(destFolder.getURIString());
            }
        });
    }

    @Test
    public void doFolderMoveSameTest() throws Exception {
        this.m_logger.info((Object)"doFolderMoveSameTest() called");
        this.executeInTempFolder(new BaseRepositoryTestTestNG.Callback(){

            @Override
            public void execute() {
                Folder folder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder("m");
                boolean exception = false;
                try {
                    RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().moveFolder(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), folder.getURIString(), "/unit_tests_tmp");
                }
                catch (JSException e) {
                    exception = true;
                    AssertJUnit.assertEquals((String)"jsexception.move.folder.to.same.folder", (String)e.getMessage());
                }
                AssertJUnit.assertTrue((boolean)exception);
                RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(folder.getURIString());
            }
        });
    }

    @Test
    public void doFolderPermissionsTest() throws Exception {
        this.m_logger.info((Object)"doFolderPermissionsTest() called");
        this.executeInTempFolder(new BaseRepositoryTestTestNG.Callback(){

            @Override
            public void execute() {
                Folder folder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder("f");
                RepositoryMoveAndCopyTestsTestNG.this.setUserPermission(SimpleAclEntry.ADMINISTRATION, folder.getURIString(), "joeuser");
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.newResource(JndiJdbcReportDataSource.class, folder, "ds");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTestsTestNG.this.saveResource((Resource)ds);
                RepositoryMoveAndCopyTestsTestNG.this.setUserPermission(SimpleAclEntry.READ_WRITE, ds.getURIString(), "joeuser");
                String copyURI = RepositoryMoveAndCopyTestsTestNG.this.makeUri("f2");
                RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().copyFolder(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), folder.getURIString(), copyURI);
                RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(folder.getURIString());
                Folder folderCopy = RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(copyURI);
                List folderCopyPermissions = RepositoryMoveAndCopyTestsTestNG.this.getPermissions((Resource)folderCopy);
                AssertJUnit.assertTrue((folderCopyPermissions == null || folderCopyPermissions.isEmpty() ? 1 : 0) != 0);
                JndiJdbcReportDataSource dsCopy = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(JndiJdbcReportDataSource.class, folderCopy, ds.getName());
                List dsCopyPermissions = RepositoryMoveAndCopyTestsTestNG.this.getPermissions((Resource)dsCopy);
                AssertJUnit.assertTrue((dsCopyPermissions == null || dsCopyPermissions.isEmpty() ? 1 : 0) != 0);
                Folder destFolder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder("m");
                RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().moveFolder(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), folder.getURIString(), destFolder.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.assertFolderInexistent(folder.getURIString());
                Folder movedFolder = RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(destFolder, folder.getName());
                RepositoryMoveAndCopyTestsTestNG.this.assertUserPermission(SimpleAclEntry.ADMINISTRATION, (Resource)movedFolder, "joeuser");
                JndiJdbcReportDataSource movedDs = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(JndiJdbcReportDataSource.class, movedFolder, ds.getName());
                RepositoryMoveAndCopyTestsTestNG.this.assertUserPermission(SimpleAclEntry.READ_WRITE, (Resource)movedDs, "joeuser");
            }
        });
    }

    @Test
    public void doFolderCopyAncestorTest() throws Exception {
        this.m_logger.info((Object)"doFolderCopyAncestorTest() called");
        this.executeInTempFolder(new BaseRepositoryTestTestNG.Callback(){

            @Override
            public void execute() {
                Folder folder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder("m");
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTestsTestNG.this.newResource(JndiJdbcReportDataSource.class, "ds");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTestsTestNG.this.saveResource((Resource)ds);
                Folder subFolder = RepositoryMoveAndCopyTestsTestNG.this.saveNewFolder(folder, "s");
                Query query = (Query)RepositoryMoveAndCopyTestsTestNG.this.newResource(Query.class, subFolder, "query");
                query.setLanguage("SQL");
                query.setSql("select");
                query.setDataSourceReference(ds.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.saveResource((Resource)query);
                String copyUri = subFolder.getURIString() + "/" + "m2";
                RepositoryMoveAndCopyTestsTestNG.this.getUnsecureRepositoryService().copyFolder(RepositoryMoveAndCopyTestsTestNG.this.getExecutionContext(), folder.getURIString(), copyUri);
                RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(folder.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(JndiJdbcReportDataSource.class, ds.getURIString());
                RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(folder, subFolder.getName());
                Query reQuery = (Query)RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(Query.class, subFolder, query.getName());
                RepositoryMoveAndCopyTestsTestNG.this.assertExternalReference(reQuery.getDataSource(), ds.getURIString());
                Folder folderCopy = RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(copyUri);
                RepositoryMoveAndCopyTestsTestNG.this.assertFolderChildren(folderCopy, 1, 0);
                Folder subFolderCopy = RepositoryMoveAndCopyTestsTestNG.this.assertFolderExists(folderCopy, subFolder.getName());
                RepositoryMoveAndCopyTestsTestNG.this.assertFolderChildren(subFolderCopy, 0, 1);
                Query queryCopy = (Query)RepositoryMoveAndCopyTestsTestNG.this.assertResourceExists(Query.class, subFolderCopy, query.getName());
                AssertJUnit.assertEquals((String)"select", (String)queryCopy.getSql());
                RepositoryMoveAndCopyTestsTestNG.this.assertExternalReference(queryCopy.getDataSource(), ds.getURIString());
            }
        });
    }
}

