/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.test;

import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.test.BaseExportTestCaseTestNG;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.annotations.Test;

public class SampleDataImportTestTestNG
extends BaseExportTestCaseTestNG {
    private static final Log m_logger = LogFactory.getLog(SampleDataImportTestTestNG.class);

    public SampleDataImportTestTestNG() {
        m_logger.info((Object)"SampleDataImportTestTestNG => constructor() called");
    }

    @Test
    public void doDemoSampleImportTest() throws Exception {
        m_logger.info((Object)"SampleDataImportTestTestNG => doDemoSampleImportTest() called");
        File importDirFile = new File("target" + FILE_SEPARATOR + "test-classes" + FILE_SEPARATOR + "exportedResources");
        File[] files = importDirFile.listFiles();
        if (files != null) {
            for (File f : files) {
                Parameters importParams = this.createParameters();
                try {
                    if (f.isDirectory()) {
                        importParams.addParameterValue("input-dir", f.toString());
                        m_logger.info((Object)("processing directory: " + f));
                    } else if (f.getName().endsWith(".zip")) {
                        importParams.addParameterValue("input-zip", f.toString());
                        m_logger.info((Object)("processing zip: " + f));
                    } else {
                        m_logger.info((Object)("skipping file: " + f));
                    }
                    if (!importParams.getParameterNames().hasNext()) continue;
                    this.performImport(importParams);
                }
                catch (Exception e) {
                    m_logger.error((Object)("Error importing file " + f), (Throwable)e);
                    throw e;
                }
            }
        } else {
            m_logger.warn((Object)("no files in: " + importDirFile));
        }
    }
}

