/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.test;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.search.SearchCriteriaFactory;
import com.jaspersoft.jasperserver.api.search.SearchFilter;
import com.jaspersoft.jasperserver.api.search.SearchSorter;
import com.jaspersoft.jasperserver.search.common.CustomFilter;
import com.jaspersoft.jasperserver.search.common.CustomSorter;
import com.jaspersoft.jasperserver.search.common.RepositorySearchConfiguration;
import com.jaspersoft.jasperserver.search.common.ResourceDetails;
import com.jaspersoft.jasperserver.search.common.SearchAttributes;
import com.jaspersoft.jasperserver.search.mode.SearchMode;
import com.jaspersoft.jasperserver.search.mode.SearchModeSettingsResolver;
import com.jaspersoft.jasperserver.search.service.RepositorySearchService;
import com.jaspersoft.jasperserver.search.state.InitialStateResolver;
import com.jaspersoft.jasperserver.search.state.State;
import com.jaspersoft.jasperserver.util.test.BaseServiceSetupTestNG;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SearchServiceTestNG
extends BaseServiceSetupTestNG {
    protected static Log log = LogFactory.getLog(SearchServiceTestNG.class);
    private static final String ROOT_TEST_FOLDER_NAME = "root_search_test_folder";
    private static final String ROOT_TEST_FOLDER_URI = "/root_search_test_folder";
    private InitialStateResolver initialStateResolver;
    private SearchCriteriaFactory searchCriteriaFactory;
    private SearchModeSettingsResolver searchModeSettingsResolver;
    private RepositorySearchService repositorySearchService;
    private SearchSorter defaultSorter;

    public SearchServiceTestNG() {
        log.info((Object)"SearchServiceTestNG => constructor() called");
    }

    @Resource(name="searchInitialStateResolver")
    public void setSearchInitialStateResolver(InitialStateResolver initialStateResolver) {
        this.initialStateResolver = initialStateResolver;
    }

    @Resource(name="searchModeSettingsResolver")
    public void setSearchModeSettingsResolver(SearchModeSettingsResolver searchModeSettingsResolver) {
        this.searchModeSettingsResolver = searchModeSettingsResolver;
    }

    @Resource(name="searchCriteriaFactory")
    public void setSearchCriteriaFactory(SearchCriteriaFactory searchCriteriaFactory) {
        this.searchCriteriaFactory = searchCriteriaFactory;
    }

    @Resource(name="repositorySearchService")
    public void setRepositorySearchService(RepositorySearchService repositorySearchService) {
        this.repositorySearchService = repositorySearchService;
    }

    @BeforeClass
    public void onSetUp() throws Exception {
        log.info((Object)"Setting up test data ...");
        log.info((Object)"onSetUp() => creating /root_search_test_folder");
        FolderImpl rootTestFolder = new FolderImpl();
        rootTestFolder.setName(ROOT_TEST_FOLDER_NAME);
        rootTestFolder.setLabel("Root Search Test Folder");
        rootTestFolder.setDescription("Root search test folder which stores all testing resources");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)rootTestFolder);
        this.addHibernateRepositoryDataSourceResources();
        this.addHibernateRepositoryReportResources();
        this.defaultSorter = ((CustomSorter)this.searchModeSettingsResolver.getSettings(SearchMode.SEARCH).getRepositorySearchConfiguration().getCustomSorters().get(0)).getSearchSorter();
    }

    @AfterClass
    public void onTearDown() throws Exception {
        log.info((Object)"SearchServiceTestNG => onTearDown() called");
        this.deleteHibernateRepositoryReportResources();
        this.deleteHibernateRepositoryDataSourceResources();
        log.info((Object)"onTearDown() => deleting /root_search_test_folder");
        this.getUnsecureRepositoryService().deleteFolder(null, ROOT_TEST_FOLDER_URI);
    }

    @Test
    public void basicSearch() throws Exception {
        log.info((Object)"SearchServiceTestNG => basicSearch() called");
        AssertJUnit.assertNotNull((Object)this.getRepositoryService());
        SearchMode mode = SearchMode.SEARCH;
        State currentState = this.createDefaultSearchState(mode);
        currentState.updateFolder(ROOT_TEST_FOLDER_URI);
        List<SearchFilter> filters = this.createAllFiltersList(mode, currentState);
        int resultCount = this.repositorySearchService.getResultsCount(this.exContext(currentState), this.searchCriteriaFactory, filters, this.defaultSorter);
        AssertJUnit.assertEquals((int)4, (int)resultCount);
        List results = this.repositorySearchService.getResults(this.exContext(currentState), this.searchCriteriaFactory, filters, this.defaultSorter, 0, 100);
        AssertJUnit.assertEquals((int)4, (int)results.size());
    }

    @Test
    public void textBasedSearch() throws Exception {
        SearchMode mode = SearchMode.SEARCH;
        State currentState = this.createDefaultSearchState(mode);
        currentState.updateText("JNDI");
        currentState.updateFolder(ROOT_TEST_FOLDER_URI);
        List<SearchFilter> filters = this.createAllFiltersList(mode, currentState);
        int resultCount = this.repositorySearchService.getResultsCount(this.exContext(currentState), this.searchCriteriaFactory, filters, this.defaultSorter);
        AssertJUnit.assertEquals((int)1, (int)resultCount);
        List results = this.repositorySearchService.getResults(this.exContext(currentState), this.searchCriteriaFactory, filters, this.defaultSorter, 0, 100);
        AssertJUnit.assertEquals((int)1, (int)results.size());
        AssertJUnit.assertEquals((String)"JServerJNDIDS", (String)((ResourceDetails)results.get(0)).getName());
        currentState = this.createDefaultSearchState(mode);
        currentState.updateText("Employee");
        currentState.updateFolder(ROOT_TEST_FOLDER_URI);
        filters = this.createAllFiltersList(mode, currentState);
        resultCount = this.repositorySearchService.getResultsCount(this.exContext(currentState), this.searchCriteriaFactory, filters, this.defaultSorter);
        AssertJUnit.assertEquals((int)1, (int)resultCount);
        results = this.repositorySearchService.getResults(this.exContext(currentState), this.searchCriteriaFactory, filters, this.defaultSorter, 0, 100);
        AssertJUnit.assertEquals((int)1, (int)results.size());
        AssertJUnit.assertEquals((String)"Employees", (String)((ResourceDetails)results.get(0)).getName());
    }

    @Test
    public void resourceTypeBasedSearch() throws Exception {
        SearchMode mode = SearchMode.SEARCH;
        State currentState = this.createDefaultSearchState(mode);
        currentState.updateFilter("resourceTypeFilter", "resourceTypeFilter-dataSources", false);
        currentState.updateFolder(ROOT_TEST_FOLDER_URI);
        List<SearchFilter> filters = this.createAllFiltersList(mode, currentState);
        int resultCount = this.repositorySearchService.getResultsCount(this.exContext(currentState), this.searchCriteriaFactory, filters, this.defaultSorter);
        AssertJUnit.assertEquals((int)3, (int)resultCount);
        List results = this.repositorySearchService.getResults(this.exContext(currentState), this.searchCriteriaFactory, filters, this.defaultSorter, 0, 100);
        AssertJUnit.assertEquals((int)3, (int)results.size());
    }

    private State createDefaultSearchState(SearchMode mode) {
        RepositorySearchConfiguration configuration = this.searchModeSettingsResolver.getSettings(mode).getRepositorySearchConfiguration();
        return this.initialStateResolver.getInitialState(configuration);
    }

    private void addHibernateRepositoryDataSourceResources() {
        log.info((Object)"addHibernateRepositoryDataSourceResources() called");
        log.info((Object)"addHibernateRepositoryDataSourceResources() => creating /root_search_test_folder/search_ds");
        FolderImpl dsFolder = new FolderImpl();
        dsFolder.setName("search_ds");
        dsFolder.setLabel("Search Data Sources");
        dsFolder.setDescription("Search Data Sources used by reports");
        dsFolder.setParentFolder(ROOT_TEST_FOLDER_URI);
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)dsFolder);
        this.createJndiDS();
        this.createRepoDS();
        this.createJdbcDS();
    }

    private void createJndiDS() {
        JndiJdbcReportDataSource datasource = (JndiJdbcReportDataSource)this.getUnsecureRepositoryService().newResource(null, JndiJdbcReportDataSource.class);
        datasource.setName("JServerJNDIDS");
        datasource.setLabel("JServer JNDI Data Source");
        datasource.setDescription("JServer JNDI Data Source");
        datasource.setJndiName(this.getJdbcProps().getProperty("test.jndi"));
        datasource.setParentFolder("/root_search_test_folder/search_ds");
        this.getUnsecureRepositoryService().saveResource(null, (com.jaspersoft.jasperserver.api.metadata.common.domain.Resource)datasource);
    }

    private void createRepoDS() {
        JndiJdbcReportDataSource datasource = (JndiJdbcReportDataSource)this.getUnsecureRepositoryService().newResource(null, JndiJdbcReportDataSource.class);
        datasource.setName("repositoryDS");
        datasource.setLabel("Jasperserver Repository SQL data source");
        datasource.setDescription("Jasperserver Repository SQL data source for reporting");
        datasource.setJndiName(this.getJdbcProps().getProperty("metadata.jndi"));
        datasource.setParentFolder("/root_search_test_folder/search_ds");
        this.getUnsecureRepositoryService().saveResource(null, (com.jaspersoft.jasperserver.api.metadata.common.domain.Resource)datasource);
    }

    private void createJdbcDS() {
        JdbcReportDataSource datasource = (JdbcReportDataSource)this.getUnsecureRepositoryService().newResource(null, JdbcReportDataSource.class);
        datasource.setName("JServerJdbcDS");
        datasource.setLabel("JServer Jdbc Data Source");
        datasource.setDescription("JServer Jdbc Data Source");
        datasource.setParentFolder("/root_search_test_folder/search_ds");
        datasource.setDriverClass(this.getJdbcProps().getProperty("test.jdbc.driverClassName"));
        datasource.setConnectionUrl(this.getJdbcProps().getProperty("test.jdbc.url"));
        datasource.setUsername(this.getJdbcProps().getProperty("test.jdbc.username"));
        datasource.setPassword(this.getJdbcProps().getProperty("test.jdbc.password"));
        this.getUnsecureRepositoryService().saveResource(null, (com.jaspersoft.jasperserver.api.metadata.common.domain.Resource)datasource);
    }

    private void deleteHibernateRepositoryDataSourceResources() {
        log.info((Object)"deleteHibernateRepositoryDataSourceResources() called");
        this.deleteJdbcDS();
        this.deleteRepoDS();
        this.deleteJndiDS();
        log.info((Object)"deleteHibernateRepositoryDataSourceResources() => deleting /root_search_test_folder/search_ds");
        this.getUnsecureRepositoryService().deleteFolder(null, "/root_search_test_folder/search_ds");
    }

    private void deleteJndiDS() {
        this.getUnsecureRepositoryService().deleteResource(null, "/root_search_test_folder/search_ds/JServerJNDIDS");
    }

    private void deleteRepoDS() {
        this.getUnsecureRepositoryService().deleteResource(null, "/root_search_test_folder/search_ds/repositoryDS");
    }

    private void deleteJdbcDS() {
        this.getUnsecureRepositoryService().deleteResource(null, "/root_search_test_folder/search_ds/JServerJdbcDS");
    }

    private void addHibernateRepositoryReportResources() {
        log.info((Object)"addHibernateRepositoryReportResources() called");
        log.info((Object)"addHibernateRepositoryReportResources() => creating /root_search_test_folder/search_reports");
        FolderImpl reportsFolder = new FolderImpl();
        reportsFolder.setName("search_reports");
        reportsFolder.setLabel("Search Reports");
        reportsFolder.setDescription("Search Reports");
        reportsFolder.setParentFolder(ROOT_TEST_FOLDER_URI);
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)reportsFolder);
        this.createEmployees((Folder)reportsFolder);
    }

    private void setCommon(com.jaspersoft.jasperserver.api.metadata.common.domain.Resource res, String id) {
        res.setName(id);
        res.setLabel(id + " Label");
        res.setDescription(id + " description");
    }

    private void createEmployees(Folder folder) {
        log.info((Object)"createEmployees() => creating /root_search_test_folder/search_reports/Employees");
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        this.setCommon((com.jaspersoft.jasperserver.api.metadata.common.domain.Resource)reportRes, "EmployeesJRXML");
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/Employees.jrxml");
        reportRes.readData(jrxml);
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("Employees");
        unit.setLabel("Employee List");
        unit.setDescription("Employee List");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/root_search_test_folder/search_ds/JServerJNDIDS");
        unit.setMainReport(reportRes);
        this.getUnsecureRepositoryService().saveResource(null, (com.jaspersoft.jasperserver.api.metadata.common.domain.Resource)unit);
    }

    private void deleteHibernateRepositoryReportResources() {
        log.info((Object)"deleteHibernateRepositoryReportResources() called");
        this.deleteEmployees();
        log.info((Object)"deleteHibernateRepositoryReportResources() => deleting /root_search_test_folder/search_reports");
        this.getUnsecureRepositoryService().deleteFolder(null, "/root_search_test_folder/search_reports");
    }

    private void deleteEmployees() {
        log.info((Object)"deleteEmployees() => deleting /root_search_test_folder/search_reports/Employees");
        this.getUnsecureRepositoryService().deleteResource(null, "/root_search_test_folder/search_reports/Employees");
    }

    private ExecutionContext exContext(State state) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        ExecutionContextImpl exContext = new ExecutionContextImpl();
        if (exContext.getAttributes() == null) {
            exContext.setAttributes(new ArrayList());
        }
        AssertJUnit.assertNotNull((Object)authentication.getPrincipal());
        AssertJUnit.assertNotNull((Object)state);
        List attributes = exContext.getAttributes();
        attributes.add(authentication.getPrincipal());
        SearchAttributes searchAttributes = new SearchAttributes();
        searchAttributes.setMode(SearchMode.SEARCH);
        searchAttributes.setState(state);
        attributes.add(searchAttributes);
        return exContext;
    }

    private RepositorySearchConfiguration getConfiguration(SearchMode mode) {
        return this.searchModeSettingsResolver.getSettings(mode).getRepositorySearchConfiguration();
    }

    private List<SearchFilter> createAllFiltersList(SearchMode mode, State state) {
        ArrayList<SearchFilter> filterList = new ArrayList<SearchFilter>();
        RepositorySearchConfiguration configuration = this.getConfiguration(mode);
        filterList.addAll(configuration.getSystemFilters());
        filterList.addAll(this.getRestrictionsFilters(mode, state));
        return filterList;
    }

    private List<SearchFilter> getRestrictionsFilters(SearchMode mode, State state) {
        ArrayList<SearchFilter> filters = new ArrayList<SearchFilter>();
        for (Map.Entry entry : state.getCustomFiltersMap().entrySet()) {
            for (CustomFilter filter : this.getConfiguration(mode).getCustomFilters()) {
                if (!filter.getId().equals(entry.getKey())) continue;
                filters.add(filter.getFilter());
            }
        }
        return filters;
    }
}

