/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.util.test;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JdbcReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JndiJdbcReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulingService;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.client.JdbcReportDataSourceImpl;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapConnectionService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ProfileAttribute;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.ObjectPermissionService;
import com.jaspersoft.jasperserver.api.metadata.user.service.ProfileAttributeService;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.export.CommandBean;
import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.export.ParametersImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.TestingAuthenticationToken;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.AssertJUnit;

@ContextConfiguration(locations={"classpath:applicationContext*.xml"})
public class BaseServiceSetupTestNG
extends AbstractTestNGSpringContextTests {
    protected static final String FORWARD_SLASH = "/";
    protected static final String TEST_BASE_DIR = "target";
    protected static final String EXPORT_COMMAND_BEAN_NAME = "exportCommandBean";
    protected static final String IMPORT_COMMAND_BEAN_NAME = "importCommandBean";
    protected static final String PARAM_EXPORT_DIR = "output-dir";
    protected static final String PARAM_EXPORT_URIS = "uris";
    protected static final String PARAM_EXPORT_REPORT_JOB_URIS = "report-jobs";
    protected static final String PARAM_EXPORT_USERS = "users";
    protected static final String PARAM_EXPORT_ROLES = "roles";
    protected static final String PARAM_IMPORT_DIR = "input-dir";
    protected static final String PARAM_IMPORT_ZIP = "input-zip";
    protected static final String PARAM_EXPORT_ZIP = "output-zip";
    protected static final String PARAM_EVERYTHING = "everything";
    protected static final String OUTPUT_ZIP_FILE_START = "js-catalog";
    protected static final String OUTPUT_ZIP_MINIMAL = "minimal";
    protected static final String OUTPUT_DASH = "-";
    protected static final String OUTPUT_DOT = ".";
    protected static final String OUTPUT_EDITION_CE = "ce";
    protected static final String OUTPUT_EDITION_PRO = "pro";
    protected static final String OUTPUT_ZIP_EXT = "zip";
    protected static final String PARAM_IMPORT_PREPEND_PATH = "prepend-path";
    protected static final String FILE_SEPARATOR = System.getProperty("file.separator");
    protected static final Random random = new Random(System.currentTimeMillis());
    private List exportFolders = new ArrayList();
    public static final String USER_JASPERADMIN = "jasperadmin";
    public static final String USER_CALIFORNIA_USER = "CaliforniaUser";
    public static final String USER_CALIFORNIA_USER_FULLNAME = "California User";
    public static final String USER_JOEUSER = "joeuser";
    public static final String USER_JOEUSER_FULLNAME = "Joe User";
    public static final String ROLE_ADMINISTRATOR = "ROLE_ADMINISTRATOR";
    public static final String USER_ANONYMOUS = "anonymousUser";
    public static final String ROLE_ANONYMOUS = "ROLE_ANONYMOUS";
    public static final String ROLE_USER = "ROLE_USER";
    public static final String ROLE_SUPERMART_MANAGER = "ROLE_SUPERMART_MANAGER";
    protected static final String ROLE_PORTLET = "ROLE_PORTLET";
    protected ExecutionContext m_exContext = new ExecutionContextImpl();
    private Properties m_jdbcProps;
    private JdbcReportDataSourceServiceFactory m_jdbcDataSourceServiceFactory;
    private JndiJdbcReportDataSourceServiceFactory m_jndiJdbcDataSourceServiceFactory;
    private RepositoryService m_repositoryService;
    private RepositoryService m_unsecureRepositoryService;
    private UserAuthorityService m_userAuthorityService;
    private ProfileAttributeService m_profileAttributeService;
    private ObjectPermissionService m_objectPermissionService;
    private ReportSchedulingService m_reportSchedulingService;
    private OlapConnectionService m_olapConnectionService;
    private EngineService m_engineService;
    private TenantService m_tenantService;
    protected final Log m_logger = LogFactory.getLog(BaseServiceSetupTestNG.class);
    private String m_multiTenancyPrefix = null;

    protected String getMultiTenancyPrefix() {
        if (this.m_multiTenancyPrefix == null) {
            this.m_multiTenancyPrefix = "/organizations/organization_1";
            Folder f = this.getRepositoryService().getFolder(null, this.m_multiTenancyPrefix);
            if (f == null) {
                this.m_multiTenancyPrefix = "";
            }
            this.m_logger.info((Object)("getMultiTenancyPrefix(): MT Prefix=<" + this.m_multiTenancyPrefix + ">"));
        }
        return this.m_multiTenancyPrefix;
    }

    protected String getMultiTenancyPrefixOrRoot() {
        if (this.m_multiTenancyPrefix == null) {
            this.m_multiTenancyPrefix = "/organizations/organization_1";
            Folder f = this.getRepositoryService().getFolder(null, this.m_multiTenancyPrefix);
            if (f == null) {
                this.m_multiTenancyPrefix = FORWARD_SLASH;
            }
            this.m_logger.info((Object)("getMultiTenancyPrefixOrRoot(): MT Prefix=<" + this.m_multiTenancyPrefix + ">"));
        }
        return this.m_multiTenancyPrefix;
    }

    protected Object getBean(String beanName) {
        return this.applicationContext.getBean(beanName);
    }

    protected void performExport(Parameters params) {
        CommandBean exporter = (CommandBean)this.getBean(EXPORT_COMMAND_BEAN_NAME);
        exporter.process(params);
    }

    protected void performImport(Parameters params) {
        CommandBean importer = (CommandBean)this.getBean(IMPORT_COMMAND_BEAN_NAME);
        importer.process(params);
    }

    protected Parameters createParameters() {
        return new ParametersImpl();
    }

    public String getNameFromURI(String uri) {
        String[] pathParts = uri.split(FORWARD_SLASH);
        return pathParts[pathParts.length - 1];
    }

    protected FileResource loadAndPrepareFileResource(String resourcePath, String uri, String fileType) throws Exception {
        String resultString = this.loadFile(resourcePath);
        String name = this.getNameFromURI(uri);
        return this.prepareFile(name, name, name, resultString, fileType);
    }

    protected String loadFile(String fileName) throws IOException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer sb = new StringBuffer();
        char[] cbuf = new char[1024];
        int k = 0;
        while ((k = br.read(cbuf)) != -1) {
            sb.append(cbuf, 0, k);
        }
        br.close();
        return sb.toString();
    }

    protected FileResource prepareFile(String name, String label, String description, String content, String fileType) {
        FileResource schemaRes = (FileResource)this.getRepositoryService().newResource(this.m_exContext, FileResource.class);
        schemaRes.setFileType(fileType);
        schemaRes.setName(name);
        schemaRes.setLabel(label);
        schemaRes.setDescription(description);
        schemaRes.setData(content.getBytes());
        return schemaRes;
    }

    protected Folder ensureParentFolderExists(String uri) {
        StringBuffer folderPath = this.getParentURI(uri);
        Folder got = this.getRepositoryService().getFolder(this.m_exContext, folderPath.toString());
        if (got != null) {
            this.m_logger.debug((Object)("Folder: " + folderPath.toString() + " exists"));
            return got;
        }
        this.m_logger.debug((Object)("Creating Folder: " + folderPath.toString()));
        String[] pathParts = folderPath.toString().split(FORWARD_SLASH);
        folderPath = new StringBuffer();
        Folder parentFolder = null;
        for (int i = 0; i < pathParts.length; ++i) {
            if (pathParts[i].length() == 0) continue;
            folderPath.append(FORWARD_SLASH).append(pathParts[i]);
            got = this.getRepositoryService().getFolder(this.m_exContext, folderPath.toString());
            if (got == null) {
                got = new FolderImpl();
                got.setName(pathParts[i]);
                got.setLabel(pathParts[i]);
                got.setDescription(pathParts[i] + " description");
                got.setParentFolder(parentFolder);
                this.getRepositoryService().saveFolder(null, got);
            }
            parentFolder = got;
        }
        return got;
    }

    public StringBuffer getParentURI(String uri) {
        String[] pathParts = uri.split(FORWARD_SLASH);
        StringBuffer folderPath = new StringBuffer();
        for (int i = 0; i < pathParts.length - 1; ++i) {
            if (pathParts[i].length() == 0) continue;
            folderPath.append(FORWARD_SLASH).append(pathParts[i]);
        }
        return folderPath;
    }

    public Properties getJdbcProps() {
        return this.m_jdbcProps;
    }

    @javax.annotation.Resource(name="jdbcProps")
    public void setJdbcProps(Properties jdbcProps) {
        this.m_logger.info((Object)"setJdbcProps() called");
        this.m_jdbcProps = jdbcProps;
    }

    public String getDatabaseProductName(String dsUri) {
        ReportDataSource ds = (ReportDataSource)this.getRepositoryService().getResource(this.m_exContext, dsUri);
        ReportDataSourceService jdss = ds instanceof JndiJdbcReportDataSource ? this.m_jndiJdbcDataSourceServiceFactory.createService(ds) : this.m_jdbcDataSourceServiceFactory.createService(ds);
        HashMap params = new HashMap();
        jdss.setReportParameterValues(params);
        try {
            Connection conn = (Connection)params.get("REPORT_CONNECTION");
            DatabaseMetaData metadata = conn.getMetaData();
            jdss.closeConnection();
            return metadata.getDatabaseProductName();
        }
        catch (SQLException ex) {
            throw new IllegalArgumentException("Cannot get database vendor name", ex);
        }
    }

    public String getDatabaseProductNameFromProp() {
        if (this.getJdbcProps().getProperty("test.databaseFlavor") != null && (this.getJdbcProps().getProperty("test.databaseFlavor").startsWith("postgresql") || this.getJdbcProps().getProperty("test.databaseFlavor").startsWith("oracle") || this.getJdbcProps().getProperty("test.databaseFlavor").startsWith("sqlserver") || this.getJdbcProps().getProperty("test.databaseFlavor").startsWith("mysql") || this.getJdbcProps().getProperty("test.databaseFlavor").startsWith("db2"))) {
            this.m_logger.info((Object)("Info: Database Flavor is: " + this.getJdbcProps().getProperty("test.databaseFlavor")));
            return this.getJdbcProps().getProperty("test.databaseFlavor");
        }
        this.m_logger.warn((Object)("WARNING: Unknown database type (flavor): " + this.getJdbcProps().getProperty("test.databaseFlavor")));
        this.m_logger.warn((Object)"WARNING: setting databaseFlavor to: mysql");
        this.m_logger.warn((Object)"WARNING: output js-catalog file will be named -mysql");
        return "mysql";
    }

    public boolean useUpperCaseNames() throws Exception {
        return Boolean.parseBoolean(this.getJdbcProps().getProperty("foodmart.upperCaseNames"));
    }

    public JdbcReportDataSourceServiceFactory getJdbcDataSourceServiceFactory() {
        return this.m_jdbcDataSourceServiceFactory;
    }

    @javax.annotation.Resource(name="jdbcDataSourceServiceFactory")
    public void setJdbcDataSourceServiceFactory(JdbcReportDataSourceServiceFactory jdbcDataSourceServiceFactory) {
        this.m_logger.info((Object)"setJdbcDataSourceServiceFactory() called");
        this.m_jdbcDataSourceServiceFactory = jdbcDataSourceServiceFactory;
    }

    public JndiJdbcReportDataSourceServiceFactory getJndiJdbcDataSourceServiceFactory() {
        return this.m_jndiJdbcDataSourceServiceFactory;
    }

    @javax.annotation.Resource(name="jndiJdbcDataSourceServiceFactory")
    public void setJndiJdbcDataSourceServiceFactory(JndiJdbcReportDataSourceServiceFactory jndiJdbcDataSourceServiceFactory) {
        this.m_logger.info((Object)"setJndiJdbcDataSourceServiceFactory() called");
        this.m_jndiJdbcDataSourceServiceFactory = jndiJdbcDataSourceServiceFactory;
    }

    protected JdbcReportDataSource createJdbcReportDataSourceFromProperties(String prefix) throws Exception {
        JdbcReportDataSourceImpl ds = new JdbcReportDataSourceImpl();
        ds.setDriverClass(this.getJdbcProps().getProperty(prefix + ".jdbc.driverClassName"));
        ds.setConnectionUrl(this.getJdbcProps().getProperty(prefix + ".jdbc.url"));
        ds.setUsername(this.getJdbcProps().getProperty(prefix + ".jdbc.username"));
        ds.setPassword(this.getJdbcProps().getProperty(prefix + ".jdbc.password"));
        if (ds.getDriverClass() == null || ds.getConnectionUrl() == null || ds.getUsername() == null || ds.getPassword() == null) {
            throw new IllegalArgumentException("some jdbc props missing for prefix " + prefix);
        }
        return ds;
    }

    protected JdbcReportDataSource createAndSaveJdbcDSFromProps(String dsURI, String prefix) throws Exception {
        JdbcReportDataSource ds = (JdbcReportDataSource)this.getRepositoryService().getResource(this.m_exContext, dsURI);
        if (ds == null) {
            ds = this.createJdbcReportDataSourceFromProperties(prefix);
            ds.setName(prefix);
            ds.setParentFolder(this.ensureParentFolderExists(dsURI));
            ds.setLabel(prefix);
            this.getRepositoryService().saveResource(this.m_exContext, (Resource)ds);
        }
        return ds;
    }

    protected JndiJdbcReportDataSource getJndiDS(String dsURI) {
        JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)this.getRepositoryService().getResource(this.m_exContext, dsURI);
        AssertJUnit.assertFalse((String)"foobar", (ds == null ? 1 : 0) != 0);
        return ds;
    }

    protected void updateResource(Resource resource, String label, String desc) throws Exception {
        resource.setLabel(label);
        resource.setDescription(desc);
    }

    protected ProfileAttribute createTestAttr(Object principal, String name, String value) {
        ProfileAttribute attr = this.getProfileAttributeService().newProfileAttribute(null);
        attr.setPrincipal(principal);
        attr.setAttrName(name);
        attr.setAttrValue(value);
        return attr;
    }

    protected Authentication setAuthenticatedUser(String username) {
        this.m_logger.info((Object)"setAuthenticatedUser() called");
        UserDetails userDetails = ((UserDetailsService)this.getUserAuthorityService()).loadUserByUsername(username);
        TestingAuthenticationToken aUser = new TestingAuthenticationToken((Object)userDetails, (Object)userDetails.getPassword(), userDetails.getAuthorities());
        aUser.setAuthenticated(true);
        SecurityContextHolder.getContext().setAuthentication((Authentication)aUser);
        this.m_logger.debug((Object)("Principal: " + aUser.getPrincipal()));
        return aUser;
    }

    public Role createRole(String roleName) {
        Role role = this.getUserAuthorityService().getRole(null, roleName);
        AssertJUnit.assertTrue((String)("Error: trying to create a role that already exists, roleName=" + roleName), (role == null ? 1 : 0) != 0);
        role = this.getUserAuthorityService().newRole(null);
        role.setRoleName(roleName);
        role.setExternallyDefined(false);
        this.getUserAuthorityService().putRole(null, role);
        return role;
    }

    public Role addRole(User user, String roleName) {
        Role role = this.getUserAuthorityService().getRole(null, roleName);
        this.getUserAuthorityService().addRole(null, user, role);
        return role;
    }

    public void removeRole(User user, String roleName) {
        Role role = this.getUserAuthorityService().getRole(null, roleName);
        if (role != null) {
            this.getUserAuthorityService().removeRole(null, user, role);
        } else {
            this.m_logger.warn((Object)("removeRole : Could not find role " + roleName + " for user " + user));
        }
    }

    public void deleteRole(String roleName) {
        Role role = this.getUserAuthorityService().getRole(null, roleName);
        if (role != null) {
            this.getUserAuthorityService().deleteRole(null, roleName);
        } else {
            this.m_logger.warn((Object)("deleteRole : Could not find role " + roleName + " to delete"));
        }
    }

    public Role getRole(String roleName) {
        Role r = this.getUserAuthorityService().getRole(null, roleName);
        if (r == null) {
            r = this.getUserAuthorityService().newRole(null);
            r.setRoleName(roleName);
            r.setExternallyDefined(false);
            this.getUserAuthorityService().putRole(null, r);
        }
        return r;
    }

    public User getUser(String username) {
        User workingUser = this.getUserAuthorityService().getUser(null, username);
        return workingUser;
    }

    public void deleteUser(String username) {
        this.getUserAuthorityService().deleteUser(null, username);
    }

    public User createUser(String userName, String password, String fullName) {
        User workingUser = this.getUserAuthorityService().getUser(null, userName);
        AssertJUnit.assertTrue((String)("Error: trying to create a user that already exists, username=" + userName), (workingUser == null ? 1 : 0) != 0);
        workingUser = this.getUserAuthorityService().newUser(null);
        workingUser.setUsername(userName);
        if (password != null) {
            workingUser.setPassword(userName);
        } else {
            workingUser.setPassword("");
        }
        workingUser.setFullName(fullName);
        workingUser.setEnabled(true);
        workingUser.setPreviousPasswordChangeTime(new Date());
        this.getUserAuthorityService().putUser(null, workingUser);
        return workingUser;
    }

    public Folder createFolder_BaseService(String baseFolderURI, String name, String label, String description) {
        String folderURI = baseFolderURI + FORWARD_SLASH + name;
        Folder folder = this.getRepositoryService().getFolder(null, folderURI);
        AssertJUnit.assertTrue((String)("Error this folder already exists, folderURI=" + folderURI), (folder == null ? 1 : 0) != 0);
        folder = new FolderImpl();
        folder.setName(name);
        folder.setLabel(label);
        folder.setDescription(description);
        Date now = new Date();
        folder.setCreationDate(now);
        folder.setUpdateDate(now);
        folder.setParentFolder(baseFolderURI);
        this.getRepositoryService().saveFolder(null, folder);
        return folder;
    }

    public Folder getOrCreateFolder(String baseFolderURI, String name, String label) {
        Folder folder = this.getRepositoryService().getFolder(null, baseFolderURI + FORWARD_SLASH + name);
        if (folder == null) {
            folder = new FolderImpl();
            folder.setName(name);
            folder.setLabel(label);
            Date now = new Date();
            folder.setCreationDate(now);
            folder.setUpdateDate(now);
            folder.setParentFolder(baseFolderURI);
            this.getRepositoryService().saveFolder(null, folder);
        }
        return folder;
    }

    public Folder getOrCreateFolder(String baseFolderURI, String name) {
        return this.getOrCreateFolder(baseFolderURI, name, name);
    }

    public Folder getFolder(String folderURI) {
        Folder folder = this.getRepositoryService().getFolder(null, folderURI);
        AssertJUnit.assertFalse((String)("Error trying to get a folder, probably does not exist, folderURI=" + folderURI), (folder == null ? 1 : 0) != 0);
        return folder;
    }

    public void deleteFolder(String folderURI) {
        this.getRepositoryService().deleteFolder(null, folderURI);
    }

    private FileResource saveOrUpdateFile(String uri, String name, String label, String description, String content, String fileType) {
        FileResource schemaRes = (FileResource)this.getRepositoryService().getResource(this.m_exContext, uri);
        if (schemaRes == null) {
            this.m_logger.debug((Object)("File: " + uri + " being created"));
            schemaRes = this.prepareFile(name, label, description, content, fileType);
            schemaRes.setParentFolder(this.ensureParentFolderExists(uri));
            this.getRepositoryService().saveResource(this.m_exContext, (Resource)schemaRes);
        }
        return schemaRes;
    }

    protected FileResource loadAndSaveFileResource(String resourcePath, String uri, String fileType) throws Exception {
        String resultString = this.loadFile(resourcePath);
        String name = this.getNameFromURI(uri);
        return this.saveOrUpdateFile(uri, name, name, name, resultString, fileType);
    }

    public RepositoryService getRepositoryService() {
        return this.m_repositoryService;
    }

    @javax.annotation.Resource(name="repositoryService")
    public void setRepositoryService(RepositoryService repository) {
        this.m_logger.info((Object)"setRepositoryService() called");
        this.m_repositoryService = repository;
    }

    @javax.annotation.Resource(name="unsecureRepositoryService")
    public void setUnsecureRepositoryService(RepositoryService unsecureRepositoryService) {
        this.m_logger.info((Object)"setUnsecureRepositoryService() called");
        this.m_unsecureRepositoryService = unsecureRepositoryService;
    }

    public RepositoryService getUnsecureRepositoryService() {
        return this.m_unsecureRepositoryService;
    }

    @javax.annotation.Resource(name="userAuthorityService")
    public void setUserAuthorityService(UserAuthorityService userAuthorityService) {
        this.m_logger.info((Object)"setUserAuthorityService() called");
        this.m_userAuthorityService = userAuthorityService;
    }

    public UserAuthorityService getUserAuthorityService() {
        return this.m_userAuthorityService;
    }

    @javax.annotation.Resource(name="objectPermissionService")
    public void setObjectPermissionService(ObjectPermissionService objectPermissionService) {
        this.m_logger.info((Object)"setObjectPermissionService() called");
        this.m_objectPermissionService = objectPermissionService;
    }

    public ObjectPermissionService getObjectPermissionService() {
        return this.m_objectPermissionService;
    }

    @javax.annotation.Resource(name="reportSchedulingService")
    public void setReportSchedulingService(ReportSchedulingService reportSchedulingService) {
        this.m_logger.info((Object)"setReportSchedulingService() called");
        this.m_reportSchedulingService = reportSchedulingService;
    }

    public ProfileAttributeService getProfileAttributeService() {
        return this.m_profileAttributeService;
    }

    public ReportSchedulingService getReportSchedulingService() {
        return this.m_reportSchedulingService;
    }

    @javax.annotation.Resource(name="olapConnectionService")
    public void setOlapConnectionService(OlapConnectionService olapConnectionService) {
        this.m_logger.info((Object)"setOlapConnectionService() called");
        this.m_olapConnectionService = olapConnectionService;
    }

    public OlapConnectionService getOlapConnectionService() {
        return this.m_olapConnectionService;
    }

    protected void logPermission(ObjectPermission perm) {
        if (perm == null) {
            return;
        }
        Object rpt = perm.getPermissionRecipient();
        String name = "?";
        if (rpt instanceof Role) {
            Role r = (Role)rpt;
            name = r.getRoleName() + (r.getTenantId() == null ? "" : "|" + r.getTenantId());
        } else if (rpt instanceof User) {
            User u = (User)rpt;
            name = u.getUsername() + (u.getTenantId() == null ? "" : "|" + u.getTenantId());
        }
        this.m_logger.info((Object)("Creating permission : " + perm.getURI() + " will have mask " + perm.getPermissionMask() + " for " + name));
    }

    protected ObjectPermission createObjectPermission(String targetPath, Object recipient, int permissionMask) {
        ObjectPermission permission = this.getObjectPermissionService().newObjectPermission(null);
        permission.setURI("repo:" + targetPath);
        permission.setPermissionRecipient(recipient);
        permission.setPermissionMask(permissionMask);
        ExecutionContextImpl ectx = new ExecutionContextImpl();
        ectx.getAttributes().add("PRIVILEGED_OPERATION");
        this.logPermission(permission);
        this.getObjectPermissionService().putObjectPermission((ExecutionContext)ectx, permission);
        return permission;
    }

    protected void deleteObjectPermission(String targetPath, Object recipient) {
        ObjectPermission op = this.getObjectPermissionService().newObjectPermission(null);
        op.setURI(targetPath);
        op.setPermissionRecipient(recipient);
        this.m_logger.info((Object)("deleteObjectPermission: about to get: " + targetPath + ", recipient: " + recipient));
        ObjectPermission op2 = this.getObjectPermissionService().getObjectPermission(null, op);
        if (op2 != null) {
            this.m_logger.info((Object)("deleteObjectPermission: got " + op2 + ". about to delete: " + targetPath + ", recipient: " + recipient));
            this.getObjectPermissionService().deleteObjectPermission(null, op);
            this.m_logger.info((Object)("deleted permission for uri: " + targetPath + ", recipient: " + recipient));
        } else {
            this.m_logger.warn((Object)("Can't delete permission for uri: " + targetPath + ", recipient: " + recipient + " because it does not exist"));
        }
    }

    @javax.annotation.Resource(name="tenantService")
    public void setTenantService(TenantService tenantService) {
        this.m_logger.info((Object)"setTenantService() called");
        this.m_tenantService = tenantService;
    }

    public TenantService getTenantService() {
        return this.m_tenantService;
    }

    @javax.annotation.Resource(name="profileAttributeService")
    public void setProfileAttributeService(ProfileAttributeService profileAttributeService) {
        this.m_logger.info((Object)"setProfileAttributeService() called");
        this.m_profileAttributeService = profileAttributeService;
    }

    @javax.annotation.Resource(name="engineService")
    public void setEngineService(EngineService engineService) {
        this.m_logger.info((Object)"setEngineService() called");
        this.m_engineService = engineService;
    }

    public EngineService getEngineService() {
        return this.m_engineService;
    }

    public String msg(String text, Object ... info) {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, LocaleContextHolder.getLocale());
        formatter.format(text, info);
        return sb.toString();
    }
}

