/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.adapters;

import java.security.Principal;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.adapters.HttpRequestIntegrationFilter;
import org.springframework.security.adapters.PrincipalSpringSecurityUserToken;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.util.MockFilterChain;

public class HttpRequestIntegrationFilterTests
extends TestCase {
    public HttpRequestIntegrationFilterTests() {
    }

    public HttpRequestIntegrationFilterTests(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        SecurityContextHolder.clearContext();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SecurityContextHolder.clearContext();
    }

    public void testCorrectOperation() throws Exception {
        HttpRequestIntegrationFilter filter = new HttpRequestIntegrationFilter();
        PrincipalSpringSecurityUserToken principal = new PrincipalSpringSecurityUserToken("key", "someone", "password", new GrantedAuthority[]{new GrantedAuthorityImpl("SOME_ROLE")}, null);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setUserPrincipal((Principal)principal);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(true);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        if (!(SecurityContextHolder.getContext().getAuthentication() instanceof PrincipalSpringSecurityUserToken)) {
            System.out.println(SecurityContextHolder.getContext().getAuthentication());
            HttpRequestIntegrationFilterTests.fail((String)"Should have returned PrincipalSpringSecurityUserToken");
        }
        PrincipalSpringSecurityUserToken castResult = (PrincipalSpringSecurityUserToken)SecurityContextHolder.getContext().getAuthentication();
        HttpRequestIntegrationFilterTests.assertEquals((Object)principal, (Object)castResult);
    }

    public void testHandlesIfHttpRequestIsNullForSomeReason() throws Exception {
        HttpRequestIntegrationFilter filter = new HttpRequestIntegrationFilter();
        try {
            filter.doFilter(null, null, null);
            HttpRequestIntegrationFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            HttpRequestIntegrationFilterTests.assertTrue((boolean)true);
        }
    }

    public void testHandlesIfThereIsNoPrincipal() throws Exception {
        HttpRequestIntegrationFilter filter = new HttpRequestIntegrationFilter();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(true);
        HttpRequestIntegrationFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        HttpRequestIntegrationFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }
}

