/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.method.aspectj;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.aspectj.lang.JoinPoint;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.AccessDecisionManager;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.MockAccessDecisionManager;
import org.springframework.security.MockApplicationEventPublisher;
import org.springframework.security.MockAuthenticationManager;
import org.springframework.security.MockJoinPoint;
import org.springframework.security.MockRunAsManager;
import org.springframework.security.RunAsManager;
import org.springframework.security.TargetObject;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.intercept.method.MapBasedMethodDefinitionSource;
import org.springframework.security.intercept.method.MethodDefinitionSource;
import org.springframework.security.intercept.method.MethodDefinitionSourceEditor;
import org.springframework.security.intercept.method.aspectj.AspectJCallback;
import org.springframework.security.intercept.method.aspectj.AspectJSecurityInterceptor;
import org.springframework.security.providers.TestingAuthenticationToken;

public class AspectJSecurityInterceptorTests
extends TestCase {
    public AspectJSecurityInterceptorTests() {
    }

    public AspectJSecurityInterceptorTests(String arg0) {
        super(arg0);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SecurityContextHolder.clearContext();
    }

    public void testCallbackIsInvokedWhenPermissionGranted() throws Exception {
        AspectJSecurityInterceptor si = new AspectJSecurityInterceptor();
        si.setApplicationEventPublisher((ApplicationEventPublisher)new MockApplicationEventPublisher(true));
        si.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManager());
        si.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        si.setRunAsManager((RunAsManager)new MockRunAsManager());
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("org.springframework.security.TargetObject.countLength=MOCK_ONE,MOCK_TWO");
        MapBasedMethodDefinitionSource map = (MapBasedMethodDefinitionSource)editor.getValue();
        si.setObjectDefinitionSource((MethodDefinitionSource)map);
        AspectJSecurityInterceptorTests.assertEquals((Object)map, (Object)si.getObjectDefinitionSource());
        si.afterPropertiesSet();
        Class<TargetObject> clazz = TargetObject.class;
        Method method = clazz.getMethod("countLength", String.class);
        MockJoinPoint joinPoint = new MockJoinPoint(new TargetObject(), method);
        MockAspectJCallback aspectJCallback = new MockAspectJCallback();
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)"rod", (Object)"koala", new GrantedAuthority[]{new GrantedAuthorityImpl("MOCK_ONE")}));
        Object result = si.invoke((JoinPoint)joinPoint, (AspectJCallback)aspectJCallback);
        AspectJSecurityInterceptorTests.assertEquals((Object)"object proceeded", (Object)result);
    }

    public void testCallbackIsNotInvokedWhenPermissionDenied() throws Exception {
        AspectJSecurityInterceptor si = new AspectJSecurityInterceptor();
        si.setApplicationEventPublisher((ApplicationEventPublisher)new MockApplicationEventPublisher(true));
        si.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManager());
        si.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        si.setRunAsManager((RunAsManager)new MockRunAsManager());
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("org.springframework.security.TargetObject.countLength=MOCK_ONE,MOCK_TWO");
        MapBasedMethodDefinitionSource map = (MapBasedMethodDefinitionSource)editor.getValue();
        si.setObjectDefinitionSource((MethodDefinitionSource)map);
        si.afterPropertiesSet();
        Class<TargetObject> clazz = TargetObject.class;
        Method method = clazz.getMethod("countLength", String.class);
        MockJoinPoint joinPoint = new MockJoinPoint(new TargetObject(), method);
        MockAspectJCallback aspectJCallback = new MockAspectJCallback();
        aspectJCallback.setThrowExceptionIfInvoked(true);
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)"rod", (Object)"koala", new GrantedAuthority[0]));
        try {
            si.invoke((JoinPoint)joinPoint, (AspectJCallback)aspectJCallback);
            AspectJSecurityInterceptorTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            AspectJSecurityInterceptorTests.assertTrue((boolean)true);
        }
    }

    private class MockAspectJCallback
    implements AspectJCallback {
        private boolean throwExceptionIfInvoked = false;

        private MockAspectJCallback() {
        }

        public Object proceedWithObject() {
            if (this.throwExceptionIfInvoked) {
                throw new IllegalStateException("AspectJCallback proceeded");
            }
            return "object proceeded";
        }

        public void setThrowExceptionIfInvoked(boolean throwExceptionIfInvoked) {
            this.throwExceptionIfInvoked = throwExceptionIfInvoked;
        }
    }
}

