/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap;

import com.sun.jndi.ldap.LdapPoolManager;
import javax.naming.directory.DirContext;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.ldap.AbstractLdapIntegrationTests;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;

public class DefaultSpringSecurityContextSourceTests
extends AbstractLdapIntegrationTests {
    @Test
    public void instantiationSucceeds() {
        new DefaultSpringSecurityContextSource("ldap://blah:789/dc=springframework,dc=org");
    }

    @Test
    public void supportsSpacesInUrl() {
        new DefaultSpringSecurityContextSource("ldap://myhost:10389/dc=spring%20framework,dc=org");
    }

    @Test
    public void poolingIsntUsedForSingleUser() throws Exception {
        DirContext ctx = this.getContextSource().getReadWriteContext("uid=Bob,ou=people,dc=springframework,dc=org", (Object)"bobspassword");
        Assert.assertNull(ctx.getEnvironment().get("com.sun.jndi.ldap.connect.pool"));
        ctx.close();
    }

    @Test(expected=BadCredentialsException.class)
    public void poolingIsntUsedForSingleUser2() throws Exception {
        DirContext ctx = this.getContextSource().getReadWriteContext("uid=Bob,ou=people,dc=springframework,dc=org", (Object)"bobspassword");
        LdapPoolManager.showStats(System.out);
        ctx.close();
        LdapPoolManager.showStats(System.out);
        ctx = this.getContextSource().getReadWriteContext("uid=Bob,ou=people,dc=springframework,dc=org", (Object)"wrongpassword");
        LdapPoolManager.showStats(System.out);
    }
}

