/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.preauth.header;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.MockAuthenticationManager;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.ui.preauth.PreAuthenticatedCredentialsNotFoundException;
import org.springframework.security.ui.preauth.header.RequestHeaderPreAuthenticatedProcessingFilter;

public class RequestHeaderPreAuthenticatedProcessingFilterTests {
    @After
    public void clearContext() {
        SecurityContextHolder.clearContext();
    }

    @Test(expected=PreAuthenticatedCredentialsNotFoundException.class)
    public void rejectsMissingHeader() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        RequestHeaderPreAuthenticatedProcessingFilter filter = new RequestHeaderPreAuthenticatedProcessingFilter();
        filter.getOrder();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
    }

    @Test
    public void defaultsToUsingSiteminderHeader() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("SM_USER", (Object)"cat");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        RequestHeaderPreAuthenticatedProcessingFilter filter = new RequestHeaderPreAuthenticatedProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((Object)"cat", (Object)SecurityContextHolder.getContext().getAuthentication().getName());
        Assert.assertEquals((Object)"N/A", (Object)SecurityContextHolder.getContext().getAuthentication().getCredentials());
    }

    @Test
    public void alternativeHeaderNameIsSupported() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("myUsernameHeader", (Object)"wolfman");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        RequestHeaderPreAuthenticatedProcessingFilter filter = new RequestHeaderPreAuthenticatedProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        filter.setPrincipalRequestHeader("myUsernameHeader");
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((Object)"wolfman", (Object)SecurityContextHolder.getContext().getAuthentication().getName());
    }

    @Test
    public void credentialsAreRetrievedIfHeaderNameIsSet() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        RequestHeaderPreAuthenticatedProcessingFilter filter = new RequestHeaderPreAuthenticatedProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        filter.setCredentialsRequestHeader("myCredentialsHeader");
        request.addHeader("SM_USER", (Object)"cat");
        request.addHeader("myCredentialsHeader", (Object)"catspassword");
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((Object)"catspassword", (Object)SecurityContextHolder.getContext().getAuthentication().getCredentials());
    }
}

