/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.InvalidConfigurationException;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Result;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.SearchException;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.store.AbstractStore;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.StoreQuery;
import net.sf.ehcache.store.TerracottaStore;
import net.sf.ehcache.store.compound.ReadWriteCopyStrategy;
import net.sf.ehcache.terracotta.TerracottaNotRunningException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransactionStore
extends AbstractStore
implements TerracottaStore {
    protected final Store underlyingStore;
    protected final ReadWriteCopyStrategy<Element> copyStrategy;

    protected AbstractTransactionStore(Store underlyingStore, ReadWriteCopyStrategy<Element> copyStrategy) {
        this.underlyingStore = underlyingStore;
        this.copyStrategy = copyStrategy;
    }

    @Override
    public void unpinAll() {
        this.underlyingStore.unpinAll();
    }

    @Override
    public boolean isPinned(Object key) {
        return this.underlyingStore.isPinned(key);
    }

    @Override
    public void setPinned(Object key, boolean pinned) {
        this.underlyingStore.setPinned(key, pinned);
    }

    protected Element copyElementForRead(Element element) {
        return this.copyStrategy.copyForRead(element);
    }

    protected Element copyElementForWrite(Element element) {
        return this.copyStrategy.copyForWrite(element);
    }

    @Override
    public Results executeQuery(StoreQuery query) {
        Results results = this.underlyingStore.executeQuery(query);
        if (results instanceof TxSearchResults) {
            return results;
        }
        return new TxSearchResults(this.underlyingStore.executeQuery(query));
    }

    @Override
    public int getInMemorySize() {
        return this.underlyingStore.getInMemorySize();
    }

    @Override
    public int getOffHeapSize() {
        return this.underlyingStore.getOffHeapSize();
    }

    @Override
    public int getOnDiskSize() {
        return this.underlyingStore.getOnDiskSize();
    }

    @Override
    public long getInMemorySizeInBytes() {
        return this.underlyingStore.getInMemorySizeInBytes();
    }

    @Override
    public long getOffHeapSizeInBytes() {
        return this.underlyingStore.getOffHeapSizeInBytes();
    }

    @Override
    public long getOnDiskSizeInBytes() {
        return this.underlyingStore.getOnDiskSizeInBytes();
    }

    @Override
    public boolean containsKeyOnDisk(Object key) {
        return this.underlyingStore.containsKeyOnDisk(key);
    }

    @Override
    public boolean containsKeyOffHeap(Object key) {
        return this.underlyingStore.containsKeyOffHeap(key);
    }

    @Override
    public boolean containsKeyInMemory(Object key) {
        return this.underlyingStore.containsKeyInMemory(key);
    }

    @Override
    public void dispose() {
        this.underlyingStore.dispose();
    }

    @Override
    public Status getStatus() {
        return this.underlyingStore.getStatus();
    }

    @Override
    public void expireElements() {
        this.underlyingStore.expireElements();
    }

    @Override
    public void flush() throws IOException {
        this.underlyingStore.flush();
    }

    @Override
    public boolean bufferFull() {
        return this.underlyingStore.bufferFull();
    }

    @Override
    public Policy getInMemoryEvictionPolicy() {
        return this.underlyingStore.getInMemoryEvictionPolicy();
    }

    @Override
    public void setInMemoryEvictionPolicy(Policy policy) {
        this.underlyingStore.setInMemoryEvictionPolicy(policy);
    }

    @Override
    public Object getInternalContext() {
        return this.underlyingStore.getInternalContext();
    }

    @Override
    public Object getMBean() {
        return this.underlyingStore.getMBean();
    }

    @Override
    public void setNodeCoherent(boolean coherent) {
        if (!coherent) {
            throw new InvalidConfigurationException("a transactional cache cannot be incoherent");
        }
        this.underlyingStore.setNodeCoherent(coherent);
    }

    @Override
    public boolean isNodeCoherent() {
        return this.underlyingStore.isNodeCoherent();
    }

    @Override
    public boolean isCacheCoherent() {
        return this.underlyingStore.isCacheCoherent();
    }

    @Override
    public boolean isClusterCoherent() {
        return this.underlyingStore.isClusterCoherent();
    }

    @Override
    public void waitUntilClusterCoherent() throws TerracottaNotRunningException, UnsupportedOperationException, InterruptedException {
        this.underlyingStore.waitUntilClusterCoherent();
    }

    @Override
    public void setAttributeExtractors(Map<String, AttributeExtractor> extractors) {
        this.underlyingStore.setAttributeExtractors(extractors);
    }

    @Override
    public <T> Attribute<T> getSearchAttribute(String attributeName) throws CacheException {
        return this.underlyingStore.getSearchAttribute(attributeName);
    }

    @Override
    public boolean hasAbortedSizeOf() {
        return this.underlyingStore.hasAbortedSizeOf();
    }

    @Override
    public Element unsafeGet(Object key) {
        if (this.underlyingStore instanceof TerracottaStore) {
            return ((TerracottaStore)this.underlyingStore).unsafeGet(key);
        }
        throw new CacheException("underlying store is not an instance of TerracottaStore");
    }

    @Override
    public Element unsafeGetQuiet(Object key) {
        if (this.underlyingStore instanceof TerracottaStore) {
            return ((TerracottaStore)this.underlyingStore).unsafeGetQuiet(key);
        }
        throw new CacheException("underlying store is not an instance of TerracottaStore");
    }

    @Override
    public Element unlockedGet(Object key) {
        if (this.underlyingStore instanceof TerracottaStore) {
            return ((TerracottaStore)this.underlyingStore).unlockedGet(key);
        }
        throw new CacheException("underlying store is not an instance of TerracottaStore");
    }

    @Override
    public Element unlockedGetQuiet(Object key) {
        if (this.underlyingStore instanceof TerracottaStore) {
            return ((TerracottaStore)this.underlyingStore).unlockedGetQuiet(key);
        }
        throw new CacheException("underlying store is not an instance of TerracottaStore");
    }

    @Override
    public Set getLocalKeys() {
        if (this.underlyingStore instanceof TerracottaStore) {
            return ((TerracottaStore)this.underlyingStore).getLocalKeys();
        }
        throw new CacheException("underlying store is not an instance of TerracottaStore");
    }

    @Override
    public CacheConfiguration.TransactionalMode getTransactionalMode() {
        if (this.underlyingStore instanceof TerracottaStore) {
            return ((TerracottaStore)this.underlyingStore).getTransactionalMode();
        }
        throw new CacheException("underlying store is not an instance of TerracottaStore");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TxResultsListIterator
    implements ListIterator<Result> {
        private final ListIterator<Result> listIterator;

        TxResultsListIterator(ListIterator<Result> listIterator) {
            this.listIterator = listIterator;
        }

        @Override
        public boolean hasNext() {
            return this.listIterator.hasNext();
        }

        @Override
        public Result next() {
            return new TxResult(this.listIterator.next());
        }

        @Override
        public boolean hasPrevious() {
            return this.listIterator.hasPrevious();
        }

        @Override
        public Result previous() {
            return new TxResult(this.listIterator.previous());
        }

        @Override
        public int nextIndex() {
            return this.listIterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.listIterator.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Result o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Result o) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TxResultsIterator
    implements Iterator<Result> {
        private final Iterator<Result> iterator;

        TxResultsIterator(Iterator<Result> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Result next() {
            return new TxResult(this.iterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TxResult
    implements Result {
        private final Result result;

        TxResult(Result result) {
            this.result = result;
        }

        Result getUnderylingResult() {
            return this.result;
        }

        @Override
        public Object getKey() throws SearchException {
            return this.result.getKey();
        }

        @Override
        public Object getValue() throws SearchException {
            return AbstractTransactionStore.this.copyElementForRead(new Element(this.result.getKey(), this.result.getValue())).getObjectValue();
        }

        @Override
        public <T> T getAttribute(Attribute<T> attribute) throws SearchException {
            return this.result.getAttribute(attribute);
        }

        @Override
        public List<Object> getAggregatorResults() throws SearchException {
            return this.result.getAggregatorResults();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TxResultsList
    implements List<Result> {
        private final List<Result> results;

        TxResultsList(List<Result> results) {
            this.results = results;
        }

        @Override
        public int size() {
            return this.results.size();
        }

        @Override
        public boolean isEmpty() {
            return this.results.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.results.contains(this.unwrapIfNeeded(o));
        }

        @Override
        public Iterator<Result> iterator() {
            return new TxResultsIterator(this.results.iterator());
        }

        @Override
        public Object[] toArray() {
            return this.wrapResultArray(this.results.toArray());
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.wrapResultArray(this.results.toArray(a));
        }

        private <T> T[] wrapResultArray(T[] array) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = new TxResult((Result)array[i]);
            }
            return array;
        }

        @Override
        public boolean add(Result o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Result> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Result> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o instanceof List) {
                List other = (List)o;
                if (this.size() != other.size()) {
                    return false;
                }
                Iterator<Result> thisIter = this.results.iterator();
                Iterator otherIter = other.iterator();
                while (thisIter.hasNext()) {
                    Object otherItem = this.unwrapIfNeeded(otherIter.next());
                    Result thisItem = thisIter.next();
                    if (otherItem == null && thisItem == null) continue;
                    if (otherItem != null && thisItem == null) {
                        return false;
                    }
                    if (thisItem != null && otherItem == null) {
                        return false;
                    }
                    if (thisItem.equals(otherItem)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return ((Object)this.results).hashCode();
        }

        @Override
        public Result get(int index) {
            return new TxResult(this.results.get(index));
        }

        @Override
        public Result set(int index, Result element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, Result element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Result remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            return this.results.indexOf(this.unwrapIfNeeded(o));
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.results.lastIndexOf(this.unwrapIfNeeded(o));
        }

        @Override
        public ListIterator<Result> listIterator() {
            return new TxResultsListIterator(this.results.listIterator());
        }

        @Override
        public ListIterator<Result> listIterator(int index) {
            return new TxResultsListIterator(this.results.listIterator(index));
        }

        @Override
        public List<Result> subList(int fromIndex, int toIndex) {
            return new TxResultsList(this.results.subList(fromIndex, toIndex));
        }

        private Object unwrapIfNeeded(Object o) {
            if (o instanceof TxResult) {
                return ((TxResult)o).getUnderylingResult();
            }
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TxSearchResults
    implements Results {
        private final Results results;

        TxSearchResults(Results results) {
            this.results = results;
        }

        @Override
        public void discard() {
            this.results.discard();
        }

        @Override
        public List<Result> all() throws SearchException {
            return new TxResultsList(this.results.all());
        }

        @Override
        public List<Result> range(int start, int count) throws SearchException, IndexOutOfBoundsException {
            return new TxResultsList(this.results.range(start, count));
        }

        @Override
        public int size() {
            return this.results.size();
        }

        @Override
        public boolean hasKeys() {
            return this.results.hasKeys();
        }

        @Override
        public boolean hasValues() {
            return this.results.hasValues();
        }

        @Override
        public boolean hasAttributes() {
            return this.results.hasAttributes();
        }

        @Override
        public boolean hasAggregators() {
            return this.results.hasAggregators();
        }
    }
}

