package com.jaspersoft.jasperserver.search.common;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.search.QueryModificationEvaluator;
import com.jaspersoft.jasperserver.search.filter.SearchAttributesHelper;

/**
 * User: carbiv
 * Date: 6/4/12
 * Time: 3:43 PM
 * @see com.jaspersoft.jasperserver.api.search.QueryModificationEvaluator;
 */
public class QueryModificationEvaluatorImpl implements QueryModificationEvaluator {

    /* in case of view by me we are going from the access events table to the resource table so we will have duplicates
    * so we need to add distinct projection to the query  */
    @Override
    public boolean useDistinctProjection(ExecutionContext context) {
        SearchAttributes searchAttributes = SearchAttributesHelper.extract(context);

        if (    searchAttributes!=null && searchAttributes.getState()!=null &&
                searchAttributes.getState().getCustomFiltersMap()!=null  && searchAttributes.getState().getCustomFiltersMap().keySet()!=null )
        {
            return searchAttributes.getState().getCustomFiltersMap().keySet().contains("accessTypeFilter");
        }
        return false;
    }
}
