package com.jaspersoft.jasperserver.war.dto;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

/**
 * @author akasych
 * @version $Id: ReportInputControl.java 23697 2012-05-10 14:10:13Z ykovalchyk $
 */
@XmlRootElement
public class ReportInputControl {
    private String id;
    private String type;
    private String uri;
    private String label;
    private Boolean mandatory;
    private Boolean readOnly;
    private Boolean  visible;
    private List<String> masterDependencies = new ArrayList<String>();
    private List<String> slaveDependencies = new ArrayList<String>();
    private List<ValidationRule> validationRules;
    private InputControlState state;

    public InputControlState getState() {
        return state;
    }

    public void setState(InputControlState state) {
        this.state = state;
    }

    @XmlElementWrapper(name = "validationRules")
    @XmlElements({
            @XmlElement(name = "rangeValidationRule", type = RangeValidationRule.class),
            @XmlElement(name = "regexpValidationRule", type = RegexpValidationRule.class),
            @XmlElement(name = "mandatoryValidationRule", type = MandatoryValidationRule.class)
    })
    public List<ValidationRule> getValidationRules() {
        return validationRules;
    }

    public void setValidationRules(List<ValidationRule> validationRules) {
        this.validationRules = validationRules;
    }

    public String getType() {
        return type;
    }




    public void setType(String type) {
        this.type = type;
    }

    public String getUri() {
        return uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Boolean getMandatory() {
        return mandatory;
    }

    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }

    public Boolean getReadOnly() {
        return readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Boolean getVisible() {
        return visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @XmlElementWrapper(name = "masterDependencies")
    @XmlElement(name = "controlId")
    public List<String> getMasterDependencies() {
        return masterDependencies;
    }

    @XmlElementWrapper(name = "slaveDependencies")
    @XmlElement(name = "controlId")
    public List<String> getSlaveDependencies() {
        return slaveDependencies;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
}
