/*
* Copyright (C) 2005 - 2009 Jaspersoft Corporation. All rights  reserved.
* http://www.jaspersoft.com.
*
* Unless you have purchased  a commercial license agreement from Jaspersoft,
* the following license terms  apply:
*
* This program is free software: you can redistribute it and/or  modify
* it under the terms of the GNU Affero General Public License  as
* published by the Free Software Foundation, either version 3 of  the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero  General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public  License
* along with this program.&nbsp; If not, see <http://www.gnu.org/licenses/>.
*/
package com.jaspersoft.jasperserver.remote.exception;

import com.jaspersoft.jasperserver.remote.exception.xml.ErrorDescriptor;

/**
 * @author Yaroslav.Kovalchyk
 * @version $Id: MandatoryParameterNotFoundException.java 22656 2012-03-20 13:43:39Z ykovalchyk $
 */
public class MandatoryParameterNotFoundException extends RemoteException{
    public MandatoryParameterNotFoundException(String parameterName){
        this("mandatory parameter " + (parameterName != null ? "'" + parameterName + "'" : "") +" not found", parameterName);
    }

    public MandatoryParameterNotFoundException(String message, String... parameters){
        super();
        setErrorDescriptor(new ErrorDescriptor.Builder().setMessage(message).setErrorCode("mandatory.parameter.error").setParameters(parameters).getErrorDescriptor());
    }
}
