/*
* Copyright (C) 2005 - 2009 Jaspersoft Corporation. All rights  reserved.
* http://www.jaspersoft.com.
*
* Unless you have purchased  a commercial license agreement from Jaspersoft,
* the following license terms  apply:
*
* This program is free software: you can redistribute it and/or  modify
* it under the terms of the GNU Affero General Public License  as
* published by the Free Software Foundation, either version 3 of  the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero  General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public  License
* along with this program.&nbsp; If not, see <http://www.gnu.org/licenses/>.
*/

package com.jaspersoft.jasperserver.remote.services.impl;

import com.jaspersoft.jasperserver.remote.common.ServerInfo;
import com.jaspersoft.jasperserver.remote.services.ServerInfoService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

import java.util.Locale;

/**
 * @author Volodya Sabadosh (vsabadosh@jaspersoft.com)
 * @version $Id $
 */
@Component("serverInfoService")
public class ServerInfoServiceImpl implements ServerInfoService {

    private final static String JS_VERSION="JS_VERSION"; // No I18N

    private final static String OS_BUILD_DATE_STAMP="OS_BUILD_DATE_STAMP"; // No I18N

    private final static String OS_BUILD_TIME_STAMP="OS_BUILD_TIME_STAMP"; // No I18N

    @javax.annotation.Resource
    protected MessageSource messageSource; // Used to get various messages

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public ServerInfo getServerInfo() {
        ServerInfo serverInfo = new ServerInfo();
        serverInfo.setVersion(getServerVersion());
        serverInfo.setBuild(getServerBuild());
        serverInfo.setEdition(getServerEdition());

        return serverInfo;
    }

    protected ServerInfo.ServerEdition getServerEdition() {
        return ServerInfo.ServerEdition.CE;
    }

    protected String getMessageVersionId() {
        return JS_VERSION;
    }

    private String getServerVersion() {
        return messageSource.getMessage(getMessageVersionId(), new Object[]{}, Locale.getDefault());
    }

    private String getServerBuild() {
        return messageSource.getMessage(OS_BUILD_DATE_STAMP, new Object[]{}, Locale.getDefault()) +
                "_" + messageSource.getMessage(OS_BUILD_TIME_STAMP, new Object[]{}, Locale.getDefault());
    }

}
