/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2007  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public License as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 **********************************************************************/

#include "constants.h"

#ifdef CHECK_RUNTIME

#include "runtime.h"

// the runtime
Runtime runtime;

/**
 ** constructor
 ** 
 ** @param     -
 ** 
 ** @return    -
 ** 
 ** @author    Diether Knof
 ** 
 ** @version   0.7.4
 **/ 
Runtime::Runtime() :
  program(),
  ai_heuristics(),
  ai_choosebestcard(),
  ai_cards_information(),
  ai_team_information(),
  tmp()
{
  program.start();
} // Runtime::Runtime()

/**
 ** destructor
 ** 
 ** @param     -
 ** 
 ** @return    -
 ** 
 ** @author    Diether Knof
 ** 
 ** @version   0.7.4
 **/ 
Runtime::~Runtime()
{ }

/**
 ** writes the runtimes in 'ostr'
 ** 
 ** @param     ostr   stream to write into
 ** 
 ** @return    -
 ** 
 ** @author    Diether Knof
 ** 
 ** @version   0.7.4
 **/ 
void
Runtime::write(ostream& ostr) const
{
  ostr << "runtime\n"
    << "  program:              "
    << setw(8) << this->program.msec() << '\n'
    << "  ai heuristics:        "
    << setw(8) << this->ai_heuristics.msec() << '\n'
    << "  ai choose best card:  "
    << setw(8) << this->ai_choosebestcard.msec() << '\n'
    << "  ai cards information: " 
    << setw(8) << this->ai_cards_information.msec() << '\n'
    << "  ai team information:  "
    << setw(8) << this->ai_team_information.msec() << '\n';
  if (this->tmp.msec() > 0)
    ostr << "  tmp:                  "
      << setw(8) << this->tmp.msec() << '\n';

  return ;
} // void Runtime::write(ostream& ostr) const

/**
 ** writes the runtimes in 'ostr'
 ** 
 ** @param     ostr      stream to write into
 ** @param     runtime   runtime to write
 ** 
 ** @return    output stream
 ** 
 ** @author    Diether Knof
 ** 
 ** @version   0.7.4
 **/ 
ostream&
operator<<(ostream& ostr, Runtime const& runtime)
{
  runtime.write(ostr);
  return ostr;
} // ostream& operator<<(ostream& ostr, Runtime runtime)

#endif // #ifdef CHECK_RUNTIME
