/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2010  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public License as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 *********************************************************************/

#ifndef CLASS_RATING_AVERAGE_PHYSICAL_HEADER
#define CLASS_RATING_AVERAGE_PHYSICAL_HEADER

#include "rating.h"

/**
 ** average rater
 ** Returns the average value of the given values,
 ** skipping the maximal and the minimal value
 **/
class Rating::AveragePhysical : public Rating
{
  public:
    // constructor
    AveragePhysical() :
      Rating(AVERAGE_PHYSICAL),
      values_sum(0), values_n(0),
      value_max(0), value_min(0)
    { }
    // destructor
    ~AveragePhysical() { }

    // adds a value
    void add(int const value)
    {
      if (this->values_n == 0) {
	this->value_max = value;
	this->value_min = value;
      } else {
	if (value > this->value_max)
	  this->value_max = value;
	if (value < this->value_min)
	  this->value_min = value;
      }
      this->values_sum += value;
      this->values_n += 1;
    } // void add(int const value)

    // returns the rated value
    int value() const
    {
      if (this->values_n == 0)
	return INT_MIN;
      if (this->values_n <= 2)
	return this->values_sum / this->values_n;
      return ((this->values_sum - this->value_max - this->value_min)
	      / (this->values_n - 2));
    } // int value() const

  private:
    // the sum of the values
    int values_sum;
    // the number of values
    // (here 'int' instead of 'unsigned' because of conversion to unsigned)
    int values_n;
    // the maximum value
    int value_max;
    // the minimum value
    int value_min;

}; // class Rating::AveragePhysical : public Rating

#endif // #ifndef CLASS_RATING_AVERAGE_PHYSICAL_HEADER
