/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2011  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public License as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 *********************************************************************/

#include "constants.h"

#ifdef USE_UI_TEXT

#include "ui.h"
#include "../../misc/language.h"
#include "../../utils/string.h"

namespace UI_TEXT_NS {

  /**
   **
   ** reads a line from the input
   **
   ** @param	-
   **
   ** @return	-
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   **/
  void
    UI_Text::getline()
    {
      if ((this->istr_ == &cin)
	  && (this->ostr_ == &cout))
	this->ostr() << this->prompt << flush;
      std::getline(this->istr(), this->line);
      if (this->istr().eof()) {
	::game_status = GAMESTATUS::QUIT;
      } // if (this->istr().eof())
      if (!this->istr().good() && !this->istr().eof()) {
	cerr << "UI Text: Problems with reading the line.\n"
	  << "Aborting." << endl;
	exit(0);
      } // if (!this->istr().good())

      return ;
    } // void UI_Text::getline()

  /**
   **
   ** test the line for the keyword:
   ** -> result
   **
   ** @param	keyword	keyword to test
   **
   ** @return	whether the read line is the keyword (with translation)
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   **/
  bool
    UI_Text::iskeyword(string const& keyword) const
    {
      return this->iskeyword(this->line, keyword);
    } // bool UI_Text::iskeyword(string const& keyword) const

  /**
   **
   ** test 'text' for the keyword:
   ** -> result
   **
   ** @param	text	text to test
   ** @param	keyword	keyword to test
   **
   ** @return	whether the text is the keyword (with translation)
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   **/
  bool
    UI_Text::iskeyword(string const& text, string const& keyword) const
    {
      return (   (text == keyword)
              || (text == ::language(keyword)));
    } // bool UI_Text::iskeyword(string const& text, string const& keyword) const

  /**
   **
   ** test the first word of the line for the keyword:
   ** -> result
   **
   ** @param	keyword	keyword to test
   **
   ** @return	whether the first word of the read line is the keyword
   **		(with translation)
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   **/
  bool
    UI_Text::first_iskeyword(string const& keyword) const
    {
      return this->first_iskeyword(this->line, keyword);
    } // bool UI_Text::first_iskeyword(string const& keyword) const

  /**
   **
   ** test the first word of 'text' for the keyword:
   ** -> result
   **
   ** @param	text	text to test
   ** @param	keyword	keyword to test
   **
   ** @return	whether the first word of 'text' is the keyword
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   **/
  bool
    UI_Text::first_iskeyword(string const& text, string const& keyword) const
    {
      return this->iskeyword(DK::Utils::String::word_first(text), keyword);
    } // bool UI_Text::first_iskeyword(string const& text, string const& keyword) const

} // namespace UI_TEXT_NS

#endif // #ifdef USE_UI_TEXT
