/*
 * Decompiled with CFR 0.152.
 */
package de.upb.javaparser.actions;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.upb.javaparser.JavaParserFrontend;
import de.upb.javaparser.options.JavaParserOptions;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

public class ParseJavaDirectoryAction
extends AbstractAction {
    private DirectoryAndJavaFilter dirJavaFilter = new DirectoryAndJavaFilter();

    public void actionPerformed(ActionEvent event) {
        FrameMain frameMain = FrameMain.get();
        JFileChooser fileChooser = frameMain.getFileChooser();
        fileChooser.setFileFilter(null);
        fileChooser.setFileSelectionMode(1);
        if (fileChooser.showOpenDialog((Component)frameMain) == 0) {
            File directory = fileChooser.getSelectedFile();
            HashSet javaFiles = new HashSet();
            this.collectJavaFiles(directory, javaFiles, JavaParserOptions.get().isParseRecursively());
            JavaParserFrontend.get().parseFiles(javaFiles);
        }
    }

    private void collectJavaFiles(File directory, HashSet javaFiles, boolean recursive) {
        File[] containedFiles = directory.listFiles(this.dirJavaFilter);
        int i = 0;
        while (i < containedFiles.length) {
            if (recursive && containedFiles[i].isDirectory()) {
                this.collectJavaFiles(containedFiles[i], javaFiles, recursive);
            }
            if (containedFiles[i].getName().endsWith(".java")) {
                javaFiles.add(containedFiles[i]);
            }
            ++i;
        }
    }

    public class DirectoryAndJavaFilter
    implements FileFilter {
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".java");
        }
    }
}

