/*
 * Decompiled with CFR 0.152.
 */
package de.upb.javaparser.syntaxtree;

import de.upb.javaparser.syntaxtree.Node;
import de.upb.javaparser.visitor.ObjectVisitor;
import de.upb.javaparser.visitor.Visitor;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class NodeToken
implements Node {
    private Node parent;
    public String tokenImage;
    public Vector specialTokens;
    public int beginLine;
    public int beginColumn;
    public int endLine;
    public int endColumn;
    public int kind;

    public NodeToken(String s) {
        this(s, -1, -1, -1, -1, -1);
    }

    public NodeToken(String s, int kind, int beginLine, int beginColumn, int endLine, int endColumn) {
        this.tokenImage = s;
        this.specialTokens = null;
        this.kind = kind;
        this.beginLine = beginLine;
        this.beginColumn = beginColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public NodeToken getSpecialAt(int i) {
        if (this.specialTokens == null) {
            throw new NoSuchElementException("No specials in token");
        }
        return (NodeToken)this.specialTokens.elementAt(i);
    }

    public int numSpecials() {
        if (this.specialTokens == null) {
            return 0;
        }
        return this.specialTokens.size();
    }

    public void addSpecial(NodeToken s) {
        if (this.specialTokens == null) {
            this.specialTokens = new Vector();
        }
        this.specialTokens.addElement(s);
        s.setParent(this);
    }

    public void trimSpecials() {
        if (this.specialTokens == null) {
            return;
        }
        this.specialTokens.trimToSize();
    }

    public String toString() {
        return this.tokenImage;
    }

    public String withSpecials() {
        if (this.specialTokens == null) {
            return this.tokenImage;
        }
        StringBuffer buf = new StringBuffer();
        Enumeration e = this.specialTokens.elements();
        while (e.hasMoreElements()) {
            buf.append(e.nextElement().toString());
        }
        buf.append(this.tokenImage);
        return buf.toString();
    }

    public void accept(Visitor v) {
        v.visit(this);
    }

    public Object accept(ObjectVisitor v, Object argu) {
        return v.visit(this, argu);
    }

    public void setParent(Node n) {
        this.parent = n;
    }

    public Node getParent() {
        return this.parent;
    }
}

