/*
 * Decompiled with CFR 0.152.
 */
package de.upb.javaparser.visitor;

import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.metamodel.FAttr;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FCommentary;
import de.uni_paderborn.fujaba.metamodel.FDeclaration;
import de.uni_paderborn.fujaba.metamodel.FDiagram;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FFile;
import de.uni_paderborn.fujaba.metamodel.FMethod;
import de.uni_paderborn.fujaba.metamodel.FPackage;
import de.uni_paderborn.fujaba.metamodel.FParam;
import de.uni_paderborn.fujaba.metamodel.FStereotype;
import de.uni_paderborn.fujaba.metamodel.FType;
import de.uni_paderborn.fujaba.uml.ASTRootNode;
import de.uni_paderborn.fujaba.uml.UMLArray;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLBaseTypes;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLClassDiagram;
import de.uni_paderborn.fujaba.uml.UMLCommentary;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLFile;
import de.uni_paderborn.fujaba.uml.UMLGeneralization;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLPackage;
import de.uni_paderborn.fujaba.uml.UMLParam;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStereotype;
import de.uni_paderborn.fujaba.uml.UMLStereotypeManager;
import de.uni_paderborn.fujaba.uml.UMLType;
import de.upb.javaast.methodast.BlockNode;
import de.upb.javaast.methodast.RootBlockNode;
import de.upb.javaast.methodast.visitors.ApplToDeclGenerator;
import de.upb.javaparser.options.JavaParserOptions;
import de.upb.javaparser.syntaxtree.ClassDeclaration;
import de.upb.javaparser.syntaxtree.CompilationUnit;
import de.upb.javaparser.syntaxtree.ConstructorBody;
import de.upb.javaparser.syntaxtree.ConstructorDeclaration;
import de.upb.javaparser.syntaxtree.FieldDeclaration;
import de.upb.javaparser.syntaxtree.FormalParameter;
import de.upb.javaparser.syntaxtree.FormalParameters;
import de.upb.javaparser.syntaxtree.ImportDeclaration;
import de.upb.javaparser.syntaxtree.Initializer;
import de.upb.javaparser.syntaxtree.InterfaceDeclaration;
import de.upb.javaparser.syntaxtree.MethodBody;
import de.upb.javaparser.syntaxtree.MethodDeclaration;
import de.upb.javaparser.syntaxtree.MethodDeclarator;
import de.upb.javaparser.syntaxtree.MyConstructorBody;
import de.upb.javaparser.syntaxtree.MyMethodBody;
import de.upb.javaparser.syntaxtree.Name;
import de.upb.javaparser.syntaxtree.NameList;
import de.upb.javaparser.syntaxtree.Node;
import de.upb.javaparser.syntaxtree.NodeChoice;
import de.upb.javaparser.syntaxtree.NodeListOptional;
import de.upb.javaparser.syntaxtree.NodeSequence;
import de.upb.javaparser.syntaxtree.NodeToken;
import de.upb.javaparser.syntaxtree.PackageDeclaration;
import de.upb.javaparser.syntaxtree.PrimitiveType;
import de.upb.javaparser.syntaxtree.ResultType;
import de.upb.javaparser.syntaxtree.Type;
import de.upb.javaparser.syntaxtree.UnmodifiedClassDeclaration;
import de.upb.javaparser.syntaxtree.UnmodifiedInterfaceDeclaration;
import de.upb.javaparser.syntaxtree.VariableDeclarator;
import de.upb.javaparser.syntaxtree.VariableDeclaratorId;
import de.upb.javaparser.visitor.MethodASTGenerator;
import de.upb.javaparser.visitor.ObjectDepthFirstVisitor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UMLModelGenerator
extends ObjectDepthFirstVisitor {
    private static final Pattern WRAPPER_CLASS_PATTERN = Pattern.compile("(java\\.lang\\.)?(Boolean|Character|Byte|Short|Integer|Long|Float|Double)");
    private UMLFile currentUmlFile;
    private UMLPackage currentPackage;
    private Stack classStack = new Stack();
    private Stack methodStack = new Stack();
    private static HashMap primitiveWrapperClasses = new HashMap();
    private static HashMap arrays = new HashMap();

    public UMLModelGenerator(String filename) {
        this.setUmlFile(filename);
    }

    public UMLClassDiagram getCurrentClassDiagram() {
        String packageName;
        UMLDiagram tmpDiag;
        UMLClassDiagram umlClassDiagram = null;
        if (!JavaParserOptions.get().isDiagramPerPackage() && (tmpDiag = UMLProject.get().getCurrentUMLDiagram()) != null && tmpDiag instanceof UMLClassDiagram) {
            umlClassDiagram = (UMLClassDiagram)tmpDiag;
        }
        if (umlClassDiagram == null && (umlClassDiagram = this.getClassDiagram(packageName = this.currentPackage != null ? this.currentPackage.getFullPackageName() : "default package")) == null) {
            umlClassDiagram = new UMLClassDiagram();
            umlClassDiagram.setName(packageName);
            UMLProject.get().addToDiags((FDiagram)umlClassDiagram);
        }
        return umlClassDiagram;
    }

    private UMLClass getCurrentClass() {
        return (UMLClass)this.classStack.peek();
    }

    private UMLMethod getCurrentMethod() {
        return (UMLMethod)this.methodStack.peek();
    }

    public Object visit(CompilationUnit n, Object argu) {
        UMLCommentary umlCommentary = new UMLCommentary();
        argu = null;
        if (n.f0.present()) {
            n.f0.accept(this, umlCommentary);
        } else {
            argu = umlCommentary;
        }
        NodeListOptional nodeListOptional = n.f1;
        int i = 0;
        while (i < nodeListOptional.size()) {
            Node node = nodeListOptional.elementAt(i);
            node.accept(this, argu);
            argu = null;
            ++i;
        }
        if (umlCommentary.getText() != null) {
            this.currentUmlFile.setComment((FCommentary)umlCommentary);
        }
        n.f2.accept(this, null);
        this.currentUmlFile.setFooter(new StringBuffer(this.getSpecialTokens(n.f3)));
        return this.currentUmlFile;
    }

    public Object visit(PackageDeclaration n, Object argu) {
        UMLPackage umlPackage;
        UMLCommentary umlCommentary = (UMLCommentary)argu;
        if (umlCommentary != null) {
            umlCommentary.setText(this.getSpecialTokens(n.f0));
        }
        String packageName = (String)n.f1.accept(this, null);
        this.currentPackage = umlPackage = UMLProject.get().getNewFromPackages(packageName);
        return umlPackage;
    }

    public Object visit(ImportDeclaration n, Object argu) {
        UMLCommentary umlCommentary = (UMLCommentary)argu;
        if (umlCommentary != null) {
            umlCommentary.setText(this.getSpecialTokens(n.f0));
        }
        String importName = (String)n.f1.accept(this, null);
        if (n.f2.present()) {
            UMLPackage importPackage = UMLProject.get().getNewFromPackages(importName);
            this.currentUmlFile.addToImportedPackages((FPackage)importPackage);
            return importPackage;
        }
        UMLClass importClass = UMLProject.get().getOrNewClass(null, importName);
        this.currentUmlFile.addToImportedClasses((FClass)importClass);
        return importClass;
    }

    public Object visit(ClassDeclaration n, Object argu) {
        UMLCommentary umlCommentary = new UMLCommentary();
        if (n.f0.present()) {
            NodeChoice nodeChoice = (NodeChoice)n.f0.elementAt(0);
            NodeToken nodeToken = (NodeToken)nodeChoice.choice;
            umlCommentary.setText(this.getSpecialTokens(nodeToken));
            argu = null;
        } else {
            argu = umlCommentary;
        }
        UMLClass umlClass = (UMLClass)n.f1.accept(this, argu);
        umlClass.setComment((FCommentary)umlCommentary);
        umlClass.setVisibility(3);
        if (n.f0.present()) {
            Enumeration enumeration = n.f0.elements();
            while (enumeration.hasMoreElements()) {
                NodeChoice nodeChoice = (NodeChoice)enumeration.nextElement();
                NodeToken nodeToken = (NodeToken)nodeChoice.choice;
                this.setClassModifier(umlClass, nodeToken.kind);
            }
        }
        return umlClass;
    }

    public Object visit(UnmodifiedClassDeclaration n, Object argu) {
        NodeSequence nodeSequence;
        UMLCommentary umlCommentary = (UMLCommentary)argu;
        if (umlCommentary != null) {
            umlCommentary.setText(this.getSpecialTokens(n.f0));
        }
        String className = n.f1.toString();
        String fullQualifiedClassName = this.currentPackage != null ? String.valueOf(this.currentPackage.getFullPackageName()) + "." + className : className;
        UMLClass umlClass = UMLProject.get().findClass(null, className);
        if (umlClass == null) {
            umlClass = UMLProject.get().findClass(null, fullQualifiedClassName);
        }
        if (umlClass == null) {
            umlClass = new UMLClass();
            umlClass.setName(className);
        } else {
            UMLProject.get().removeFromReferences(umlClass);
            umlClass.removeAllFromAttrs();
            umlClass.removeAllFromMethods();
            umlClass.removeAllFromDeclares();
            umlClass.removeAllFromStereotypes();
        }
        umlClass.setParsed(true);
        this.setPackage(umlClass, this.currentPackage);
        umlClass.setFile((FFile)this.currentUmlFile);
        if (!this.classStack.isEmpty()) {
            this.getCurrentClass().addToDeclares((FClass)umlClass);
            this.getCurrentClass().addToParsedMembers((FDeclaration)umlClass);
        }
        this.classStack.push(umlClass);
        this.getCurrentClassDiagram().addToElements((ASGElement)umlClass);
        if (n.f2.present()) {
            nodeSequence = (NodeSequence)n.f2.node;
            this.parseGeneralization((Name)nodeSequence.elementAt(1), false);
        }
        if (n.f3.present()) {
            nodeSequence = (NodeSequence)n.f3.node;
            NameList nameList = (NameList)nodeSequence.elementAt(1);
            this.parseGeneralization(nameList.f0, true);
            NodeListOptional nodeListOptional = nameList.f1;
            Enumeration enumeration = nodeListOptional.elements();
            while (enumeration.hasMoreElements()) {
                nodeSequence = (NodeSequence)enumeration.nextElement();
                this.parseGeneralization((Name)nodeSequence.elementAt(1), true);
            }
        }
        n.f4.accept(this, null);
        if (!JavaParserOptions.get().isIncrementalParsing()) {
            ApplToDeclGenerator applToDeclGenerator = new ApplToDeclGenerator();
            applToDeclGenerator.visit((FElement)umlClass);
        }
        this.classStack.pop();
        return umlClass;
    }

    public Object visit(InterfaceDeclaration n, Object argu) {
        UMLCommentary umlCommentary = new UMLCommentary();
        if (n.f0.present()) {
            NodeChoice nodeChoice = (NodeChoice)n.f0.elementAt(0);
            NodeToken nodeToken = (NodeToken)nodeChoice.choice;
            umlCommentary.setText(this.getSpecialTokens(nodeToken));
            argu = null;
        } else {
            argu = umlCommentary;
        }
        UMLClass umlClass = (UMLClass)n.f1.accept(this, argu);
        umlClass.setComment((FCommentary)umlCommentary);
        umlClass.setVisibility(3);
        if (n.f0.present()) {
            Enumeration enumeration = n.f0.elements();
            while (enumeration.hasMoreElements()) {
                NodeChoice nodeChoice = (NodeChoice)enumeration.nextElement();
                NodeToken nodeToken = (NodeToken)nodeChoice.choice;
                this.setClassModifier(umlClass, nodeToken.kind);
            }
        }
        return umlClass;
    }

    public Object visit(UnmodifiedInterfaceDeclaration n, Object argu) {
        UMLCommentary umlCommentary = (UMLCommentary)argu;
        if (umlCommentary != null) {
            umlCommentary.setText(this.getSpecialTokens(n.f0));
        }
        String className = n.f1.toString();
        String fullQualifiedClassName = this.currentPackage != null ? String.valueOf(this.currentPackage.getFullPackageName()) + "." + className : className;
        UMLClass umlClass = UMLProject.get().findClass(null, className);
        if (umlClass == null) {
            umlClass = UMLProject.get().findClass(null, fullQualifiedClassName);
        }
        if (umlClass == null) {
            umlClass = new UMLClass();
            umlClass.setName(className);
        } else {
            UMLProject.get().removeFromReferences(umlClass);
            umlClass.removeAllFromAttrs();
            umlClass.removeAllFromMethods();
            umlClass.removeAllFromDeclares();
            umlClass.removeAllFromStereotypes();
        }
        umlClass.setParsed(true);
        this.setPackage(umlClass, this.currentPackage);
        umlClass.addToStereotypes((FStereotype)this.getStereotype("interface"));
        umlClass.setFile((FFile)this.currentUmlFile);
        if (!this.classStack.isEmpty()) {
            this.getCurrentClass().addToDeclares((FClass)umlClass);
            this.getCurrentClass().addToParsedMembers((FDeclaration)umlClass);
        }
        this.classStack.push(umlClass);
        this.getCurrentClassDiagram().addToElements((ASGElement)umlClass);
        if (n.f2.present()) {
            NodeSequence nodeSequence = (NodeSequence)n.f2.node;
            NameList nameList = (NameList)nodeSequence.elementAt(1);
            this.parseGeneralization(nameList.f0, true);
            NodeListOptional optNode = nameList.f1;
            Enumeration enumeration = optNode.elements();
            while (enumeration.hasMoreElements()) {
                nodeSequence = (NodeSequence)enumeration.nextElement();
                this.parseGeneralization((Name)nodeSequence.elementAt(1), true);
            }
        }
        n.f4.accept(this, null);
        this.classStack.pop();
        return umlClass;
    }

    public Object visit(FieldDeclaration n, Object argu) {
        UMLCommentary umlCommentary = new UMLCommentary();
        if (n.f0.present()) {
            NodeChoice nodeChoice = (NodeChoice)n.f0.elementAt(0);
            umlCommentary.setText(this.getSpecialTokens((NodeToken)nodeChoice.choice));
        } else {
            argu = umlCommentary;
        }
        UMLType umlType = (UMLType)n.f1.accept(this, argu);
        UMLAttr umlAttr = (UMLAttr)n.f2.accept(this, null);
        umlAttr.setComment((FCommentary)umlCommentary);
        umlAttr.setAttrType((FType)umlType);
        umlAttr.setVisibility(3);
        int i = 0;
        while (i < n.f0.size()) {
            NodeChoice nodeChoice = (NodeChoice)n.f0.elementAt(i);
            NodeToken nodeToken = (NodeToken)nodeChoice.choice;
            int modifier = nodeToken.kind;
            this.setFieldModifier(umlAttr, modifier);
            ++i;
        }
        this.getCurrentClass().addToAttrs((FAttr)umlAttr);
        this.getCurrentClass().addToParsedMembers((FDeclaration)umlAttr);
        NodeListOptional optNode = n.f3;
        Enumeration enumeration = optNode.elements();
        while (enumeration.hasMoreElements()) {
            NodeSequence nodeSequence = (NodeSequence)enumeration.nextElement();
            VariableDeclarator varDeclarator = (VariableDeclarator)nodeSequence.elementAt(1);
            umlAttr = (UMLAttr)varDeclarator.accept(this, null);
            umlAttr.setAttrType((FType)umlType);
            umlAttr.setVisibility(3);
            int i2 = 0;
            while (i2 < n.f0.size()) {
                NodeChoice nodeChoice = (NodeChoice)n.f0.elementAt(i2);
                NodeToken nodeToken = (NodeToken)nodeChoice.choice;
                int modifier = nodeToken.kind;
                this.setFieldModifier(umlAttr, modifier);
                ++i2;
            }
            this.getCurrentClass().addToAttrs((FAttr)umlAttr);
            this.getCurrentClass().addToParsedMembers((FDeclaration)umlAttr);
        }
        return umlAttr;
    }

    public Object visit(VariableDeclarator n, Object argu) {
        UMLAttr umlAttr = new UMLAttr();
        umlAttr.setParsed(true);
        n.f0.accept(this, umlAttr);
        if (n.f1.present()) {
            NodeSequence nodeSequence = (NodeSequence)n.f1.node;
            umlAttr.setInitialValue(this.getPlainSourceCode(nodeSequence.elementAt(1)).toString());
        }
        return umlAttr;
    }

    public Object visit(VariableDeclaratorId n, Object argu) {
        if (argu instanceof UMLAttr) {
            UMLAttr umlAttr = (UMLAttr)argu;
            umlAttr.setName(n.f0.toString());
            if (n.f1.size() > 0) {
                UMLType umlType;
                UMLType umlArray = umlType = umlAttr.getAttrType();
                int i = 0;
                while (i < n.f1.size()) {
                    umlArray = umlType = UMLModelGenerator.getUMLArray(umlArray);
                    ++i;
                }
                umlAttr.setAttrType((FType)umlType);
            }
            return umlAttr;
        }
        if (argu instanceof UMLParam) {
            UMLParam umlParam = (UMLParam)argu;
            umlParam.setName(n.f0.toString());
            if (n.f1.size() > 0) {
                UMLType umlType;
                UMLType umlArray = umlType = umlParam.getParamType();
                int i = 0;
                while (i < n.f1.size()) {
                    umlArray = umlType = UMLModelGenerator.getUMLArray(umlArray);
                    ++i;
                }
                umlParam.setParamType((FType)umlType);
            }
            return umlParam;
        }
        return null;
    }

    public Object visit(MethodDeclaration n, Object argu) {
        UMLMethod umlMethod = new UMLMethod();
        umlMethod.setParsed(true);
        this.methodStack.push(umlMethod);
        UMLCommentary umlCommentary = new UMLCommentary();
        umlMethod.setComment((FCommentary)umlCommentary);
        if (n.f0.present()) {
            NodeChoice nodeChoice = (NodeChoice)n.f0.elementAt(0);
            NodeToken nodeToken = (NodeToken)nodeChoice.choice;
            umlCommentary.setText(this.getSpecialTokens(nodeToken));
            argu = null;
        } else {
            argu = umlCommentary;
        }
        umlMethod.setVisibility(3);
        int i = 0;
        while (i < n.f0.size()) {
            NodeChoice nodeChoice = (NodeChoice)n.f0.elementAt(i);
            NodeToken nodeToken = (NodeToken)nodeChoice.choice;
            this.setMethodModifier(umlMethod, nodeToken.kind);
            ++i;
        }
        UMLType umlType = (UMLType)n.f1.accept(this, argu);
        umlMethod.setResultType((FType)umlType);
        n.f2.accept(this, umlMethod);
        if (n.f3.present()) {
            this.addToThrows(umlMethod, (NameList)((NodeSequence)n.f3.node).elementAt(1));
        }
        if (n.f4.which == 0) {
            NodeSequence nodeSequence = (NodeSequence)n.f4.choice;
            MethodBody methodBodyNode = (MethodBody)nodeSequence.elementAt(1);
            String methodBody = (String)methodBodyNode.accept(this, null);
            String leftBrace = this.getPlainSourceCode(nodeSequence.elementAt(0)).toString();
            String rightBrace = this.getPlainSourceCode(nodeSequence.elementAt(2)).toString();
            if (!(methodBodyNode instanceof MyMethodBody)) {
                RootBlockNode rootBlockNode = (RootBlockNode)umlMethod.getASTRootNode();
                BlockNode blockNode = rootBlockNode.getBlock();
                blockNode.setLeftBrace(leftBrace);
                blockNode.setRightBrace(rightBrace);
            }
            StringBuffer buffer = new StringBuffer(leftBrace);
            buffer.append(methodBody);
            buffer.append(rightBrace);
            umlMethod.setMethodBody(buffer.toString());
        }
        this.getCurrentClass().addToMethods((FMethod)umlMethod);
        this.getCurrentClass().addToParsedMembers((FDeclaration)umlMethod);
        this.methodStack.pop();
        return umlMethod;
    }

    public Object visit(MethodDeclarator n, Object argu) {
        UMLMethod umlMethod = (UMLMethod)argu;
        umlMethod.setName(n.f0.toString());
        n.f1.accept(this, argu);
        UMLType umlArray = umlMethod.getResultType();
        int i = 0;
        while (i < n.f2.size()) {
            UMLArray umlType = UMLModelGenerator.getUMLArray(umlArray);
            umlArray = umlType;
            ++i;
        }
        umlMethod.setResultType((FType)umlArray);
        return umlMethod;
    }

    public Object visit(FormalParameters n, Object argu) {
        UMLMethod umlMethod = (UMLMethod)argu;
        if (n.f1.present()) {
            NodeSequence nodeSequence = (NodeSequence)n.f1.node;
            UMLParam umlParam = (UMLParam)nodeSequence.elementAt(0).accept(this, argu);
            umlMethod.addToParam((FParam)umlParam);
            NodeListOptional nodeListOptional = (NodeListOptional)nodeSequence.elementAt(1);
            if (nodeListOptional.present()) {
                int i = 0;
                while (i < nodeListOptional.size()) {
                    nodeSequence = (NodeSequence)nodeListOptional.elementAt(i);
                    umlParam = (UMLParam)nodeSequence.elementAt(1).accept(this, argu);
                    umlMethod.addToParam((FParam)umlParam);
                    ++i;
                }
            }
        }
        return umlMethod;
    }

    public Object visit(FormalParameter n, Object argu) {
        UMLParam umlParam = new UMLParam();
        if (n.f0.present()) {
            umlParam.addToStereotypes((FStereotype)this.getStereotype("final"));
        }
        UMLType umlType = (UMLType)n.f1.accept(this, null);
        umlParam.setParamType((FType)umlType);
        n.f2.accept(this, umlParam);
        return umlParam;
    }

    public Object visit(MethodBody n, Object argu) {
        String methodBody = null;
        if (n instanceof MyMethodBody) {
            methodBody = n.toString();
        } else {
            MethodASTGenerator methodASTGenerator = new MethodASTGenerator();
            RootBlockNode rootBlockNode = (RootBlockNode)n.accept(methodASTGenerator, null);
            this.getCurrentMethod().setASTRootNode((ASTRootNode)rootBlockNode);
            methodBody = rootBlockNode.toString();
        }
        return methodBody;
    }

    public Object visit(ConstructorDeclaration n, Object argu) {
        UMLMethod umlMethod = new UMLMethod();
        umlMethod.setParsed(true);
        this.methodStack.push(umlMethod);
        umlMethod.setVisibility(3);
        if (n.f0.present()) {
            NodeChoice nodeChoice = (NodeChoice)n.f0.node;
            NodeToken nodeToken = (NodeToken)nodeChoice.choice;
            this.setMethodModifier(umlMethod, nodeToken.kind);
        }
        UMLBaseTypes umlType = UMLProject.get().getFromBaseTypes("constructor");
        umlMethod.setResultType((FType)umlType);
        String methodName = n.f1.toString();
        umlMethod.setName(methodName);
        n.f2.accept(this, umlMethod);
        if (n.f3.present()) {
            this.addToThrows(umlMethod, (NameList)((NodeSequence)n.f3.node).elementAt(1));
        }
        String leftBrace = this.getPlainSourceCode(n.f4).toString();
        String methodBody = (String)n.f5.accept(this, null);
        String rightBrace = this.getPlainSourceCode(n.f6).toString();
        if (!(n.f5 instanceof MyConstructorBody)) {
            RootBlockNode rootBlockNode = (RootBlockNode)umlMethod.getASTRootNode();
            BlockNode blockNode = rootBlockNode.getBlock();
            blockNode.setLeftBrace(leftBrace);
            blockNode.setRightBrace(rightBrace);
        }
        StringBuffer buffer = new StringBuffer(leftBrace);
        buffer.append(methodBody);
        buffer.append(rightBrace);
        umlMethod.setMethodBody(buffer.toString());
        this.getCurrentClass().addToParsedMembers((FDeclaration)umlMethod);
        this.getCurrentClass().addToMethods((FMethod)umlMethod);
        this.methodStack.pop();
        return umlMethod;
    }

    public Object visit(ConstructorBody n, Object argu) {
        String methodBody = null;
        if (n instanceof MyConstructorBody) {
            methodBody = n.toString();
        } else {
            MethodASTGenerator methodASTGenerator = new MethodASTGenerator();
            RootBlockNode rootBlockNode = (RootBlockNode)n.accept(methodASTGenerator, null);
            this.getCurrentMethod().setASTRootNode((ASTRootNode)rootBlockNode);
            methodBody = rootBlockNode.toString();
        }
        return methodBody;
    }

    public Object visit(Initializer n, Object argu) {
        UMLMethod umlMethod = new UMLMethod();
        umlMethod.setParsed(true);
        this.methodStack.push(umlMethod);
        umlMethod.setName("{}");
        UMLBaseTypes umlType = UMLProject.get().getFromBaseTypes("Initializer");
        umlMethod.setResultType((FType)umlType);
        if (n.f0.present()) {
            umlMethod.setStatic(true);
        }
        umlMethod.setMethodBody(this.getPlainSourceCode(n.f1).toString());
        this.getCurrentClass().addToMethods((FMethod)umlMethod);
        this.methodStack.pop();
        return umlMethod;
    }

    public Object visit(Type n, Object argu) {
        String typeName;
        Matcher matcher;
        UMLType umlType = n.f0.which == 0 ? (UMLType)n.f0.choice.accept(this, argu) : ((matcher = WRAPPER_CLASS_PATTERN.matcher(typeName = (String)n.f0.choice.accept(this, argu))).matches() ? this.findTypeInPrimitiveWrapperClasses(typeName) : this.findType(typeName));
        UMLType umlArray = umlType;
        int i = 0;
        while (i < n.f1.size()) {
            umlArray = umlType = UMLModelGenerator.getUMLArray(umlArray);
            ++i;
        }
        return umlType;
    }

    public Object visit(PrimitiveType n, Object argu) {
        UMLBaseTypes umlType = null;
        UMLProject umlProject = UMLProject.get();
        UMLCommentary umlCommentary = (UMLCommentary)argu;
        if (umlCommentary != null) {
            umlCommentary.setText(this.getSpecialTokens((NodeToken)n.f0.choice));
        }
        switch (n.f0.which) {
            case 0: {
                umlType = umlProject.getFromBaseTypes("Boolean");
                break;
            }
            case 1: {
                umlType = umlProject.getFromBaseTypes("Character");
                break;
            }
            case 2: {
                umlType = umlProject.getFromBaseTypes("Byte");
                break;
            }
            case 3: {
                umlType = umlProject.getFromBaseTypes("ShortInteger");
                break;
            }
            case 4: {
                umlType = umlProject.getFromBaseTypes("Integer");
                break;
            }
            case 5: {
                umlType = umlProject.getFromBaseTypes("LongInteger");
                break;
            }
            case 6: {
                umlType = umlProject.getFromBaseTypes("Float");
                break;
            }
            case 7: {
                umlType = umlProject.getFromBaseTypes("Double");
            }
        }
        return umlType;
    }

    public Object visit(ResultType n, Object argu) {
        UMLCommentary umlCommentary = (UMLCommentary)argu;
        UMLBaseTypes umlType = null;
        UMLProject umlProject = UMLProject.get();
        if (n.f0.which == 0) {
            umlType = umlProject.getFromBaseTypes("Void");
            if (umlCommentary != null) {
                umlCommentary.setText(this.getSpecialTokens((NodeToken)n.f0.choice));
            }
        } else {
            umlType = (UMLType)n.f0.accept(this, argu);
        }
        return umlType;
    }

    public Object visit(Name n, Object argu) {
        UMLCommentary umlCommentary = (UMLCommentary)argu;
        if (umlCommentary != null) {
            umlCommentary.setText(this.getSpecialTokens(n.f0));
        }
        StringBuffer buffer = new StringBuffer(n.f0.toString());
        Enumeration enumeration = n.f1.elements();
        while (enumeration.hasMoreElements()) {
            NodeSequence sequence = (NodeSequence)enumeration.nextElement();
            buffer = buffer.append(".");
            buffer = buffer.append(((NodeToken)sequence.elementAt(1)).toString());
        }
        return buffer.toString();
    }

    private UMLType findType(String typeName) {
        UMLType umlType = UMLProject.get().findType(null, typeName);
        if (umlType == null) {
            if (this.currentPackage != null) {
                umlType = UMLProject.get().findType(null, String.valueOf(this.currentPackage.getFullPackageName()) + "." + typeName);
            }
            if (umlType == null) {
                umlType = this.findTypeInImports(typeName);
            }
            if (umlType == null) {
                umlType = UMLProject.get().getOrNewType(null, typeName);
            }
        }
        return umlType;
    }

    private UMLType findTypeInImports(String typeName) {
        UMLClass umlType = null;
        Iterator iterClasses = this.currentUmlFile.iteratorOfImportedClasses();
        while (iterClasses.hasNext() && umlType == null) {
            UMLClass clazz = (UMLClass)iterClasses.next();
            if (!clazz.getName().equals(typeName)) continue;
            umlType = clazz;
        }
        if (umlType == null) {
            Iterator iterPackages = this.currentUmlFile.iteratorOfImportedPackages();
            while (iterPackages.hasNext() && umlType == null) {
                UMLPackage pack = (UMLPackage)iterPackages.next();
                umlType = UMLProject.get().findClass(null, String.valueOf(pack.getFullPackageName()) + "." + typeName);
            }
        }
        return umlType;
    }

    private UMLType findTypeInPrimitiveWrapperClasses(String typeName) {
        String primitiveTypeName = typeName.substring(typeName.lastIndexOf(".") + 1, typeName.length());
        UMLClass wrapperBaseType = (UMLClass)primitiveWrapperClasses.get(primitiveTypeName);
        if (wrapperBaseType == null) {
            UMLPackage javaLangPackage = UMLProject.get().findPackage("java.lang", true);
            wrapperBaseType = new UMLClass();
            wrapperBaseType.setDeclaredInPackage((FPackage)javaLangPackage);
            wrapperBaseType.setName(primitiveTypeName);
            wrapperBaseType.addToStereotypes((FStereotype)this.getStereotype("type"));
            primitiveWrapperClasses.put(primitiveTypeName, wrapperBaseType);
        }
        return wrapperBaseType;
    }

    private void setUmlFile(String exactFileName) {
        if (this.currentUmlFile == null) {
            UMLProject theProject;
            if (exactFileName.endsWith(".java")) {
                exactFileName = exactFileName.substring(0, exactFileName.length() - 5);
            }
            if ((theProject = UMLProject.get()).hasInFiles(exactFileName)) {
                this.currentUmlFile = theProject.getFromFiles(exactFileName);
            } else {
                this.currentUmlFile = new UMLFile();
                this.currentUmlFile.setProject(theProject);
            }
        }
    }

    private void parseGeneralization(Name nameNode, boolean isInterface) {
        UMLClass currentClass = this.getCurrentClass();
        String name = (String)nameNode.accept(this, null);
        UMLClass fatherClass = (UMLClass)this.findType(name);
        if (isInterface) {
            fatherClass.addToStereotypes((FStereotype)this.getStereotype("interface"));
        }
        this.getCurrentClassDiagram().addToElements((ASGElement)fatherClass);
        UMLGeneralization umlGeneralization = currentClass.getParentGeneralization(fatherClass);
        if (umlGeneralization == null) {
            umlGeneralization = new UMLGeneralization(currentClass, fatherClass);
            this.getCurrentClassDiagram().addToElements((ASGElement)umlGeneralization);
        }
    }

    private void addToThrows(UMLMethod umlMethod, NameList nameList) {
        Name nameNode = nameList.f0;
        String name = nameNode.f0.toString();
        umlMethod.addToThrowsTypes(UMLProject.get().getOrNewType(null, name));
        NodeListOptional optNode = nameList.f1;
        Enumeration enumeration = optNode.elements();
        while (enumeration.hasMoreElements()) {
            NodeSequence sequence = (NodeSequence)enumeration.nextElement();
            nameNode = (Name)sequence.elementAt(1);
            umlMethod.addToThrowsTypes(UMLProject.get().getOrNewType(null, nameNode.f0.toString()));
        }
    }

    private void setPackage(UMLClass umlClass, UMLPackage umlPackage) {
        if (umlPackage != null) {
            umlClass.setDeclaredInPackage((FPackage)umlPackage);
        } else {
            UMLPackage rootPackage = UMLProject.get().getRootPackage();
            umlClass.setDeclaredInPackage((FPackage)rootPackage);
        }
    }

    private void setClassModifier(UMLClass umlClass, int modifier) {
        switch (modifier) {
            case 14: {
                umlClass.setAbstract(true);
                break;
            }
            case 30: {
                umlClass.addToStereotypes((FStereotype)this.getStereotype("final"));
                break;
            }
            case 48: {
                umlClass.setVisibility(1);
                break;
            }
            case 64: {
                umlClass.addToStereotypes((FStereotype)this.getStereotype("strictfp"));
                break;
            }
            default: {
                System.err.println("Class '" + umlClass.getName() + "' has unknown modifier " + modifier);
            }
        }
    }

    private void setMethodModifier(UMLMethod method, int modifier) {
        switch (modifier) {
            case 14: {
                method.setAbstract(true);
                break;
            }
            case 30: {
                method.setFinal(true);
                break;
            }
            case 48: {
                method.setVisibility(1);
                break;
            }
            case 47: {
                method.setVisibility(2);
                break;
            }
            case 46: {
                method.setVisibility(0);
                break;
            }
            case 51: {
                method.setStatic(true);
                break;
            }
            case 42: {
                method.setUmlNative(true);
                break;
            }
            case 54: {
                method.setUmlSynchronized(true);
                break;
            }
            default: {
                System.err.println("Method '" + method.getName() + "' has unknown modifier " + modifier);
            }
        }
    }

    private void setFieldModifier(UMLAttr attr, int modifier) {
        switch (modifier) {
            case 48: {
                attr.setVisibility(1);
                break;
            }
            case 47: {
                attr.setVisibility(2);
                break;
            }
            case 46: {
                attr.setVisibility(0);
                break;
            }
            case 51: {
                attr.setUmlStatic(true);
                break;
            }
            case 30: {
                attr.setFinal(true);
                break;
            }
            case 58: {
                attr.setTransient(true);
                break;
            }
            case 62: {
                attr.addToStereotypes((FStereotype)this.getStereotype("volatile"));
                break;
            }
            default: {
                System.err.println("Attribute '" + attr.getName() + "' has unknown modifier " + modifier);
            }
        }
    }

    private UMLStereotype getStereotype(String name) {
        UMLStereotype umlStereotype;
        UMLStereotypeManager umlStereotypeManager = UMLProject.get().getStereotypeManager();
        if (umlStereotypeManager.hasKeyInStereotypes(name)) {
            umlStereotype = umlStereotypeManager.getFromStereotypes(name);
        } else {
            umlStereotype = new UMLStereotype(name);
            umlStereotypeManager.addToStereotypes(umlStereotype);
        }
        return umlStereotype;
    }

    private UMLClassDiagram getClassDiagram(String name) {
        UMLClassDiagram umlClassDiagram = null;
        boolean found = false;
        Iterator iter = UMLProject.get().iteratorOfDiags();
        while (iter.hasNext() && !found) {
            ASGDiagram asgDiagram = (ASGDiagram)iter.next();
            if (!(asgDiagram instanceof UMLClassDiagram) || !asgDiagram.getName().equals(name)) continue;
            umlClassDiagram = (UMLClassDiagram)asgDiagram;
        }
        return umlClassDiagram;
    }

    private static UMLArray getUMLArray(UMLType elementType) {
        UMLArray array = (UMLArray)arrays.get(elementType);
        if (array == null) {
            array = new UMLArray(elementType);
            arrays.put(elementType, array);
        }
        return array;
    }
}

