/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.xmlreflect;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class StoreXML {
    private StoreXML() {
    }

    public static void storeXML(Element xml, String fileName) {
        StoreXML.storeXML(xml, fileName, false);
    }

    public static void storeXML(Element xml, String fileName, boolean zipped) {
        try {
            OutputStream outstream = new FileOutputStream(fileName);
            if (zipped) {
                outstream = new GZIPOutputStream(outstream);
            }
            BufferedOutputStream fout = new BufferedOutputStream(outstream);
            XMLOutputter xout = new XMLOutputter();
            xout.setNewlines(true);
            xout.setIndent(" ");
            xout.output(new Document(xml), (OutputStream)fout);
            fout.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Element restoreXML(String fileName) {
        try {
            BufferedInputStream fio;
            try {
                fio = new BufferedInputStream(new GZIPInputStream(new FileInputStream(fileName)));
            }
            catch (Exception e) {
                fio = new BufferedInputStream(new FileInputStream(fileName));
            }
            Element element = StoreXML.restoreXML(fio);
            fio.close();
            return element;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Element restoreXML(InputStream is) {
        try {
            SAXBuilder sbuild = new SAXBuilder();
            Document doc = sbuild.build(is);
            return doc.getRootElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

