/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.xmlreflect.util;

import de.tu_bs.xmlreflect.util.errors.AccessorException;
import de.tu_bs.xmlreflect.util.errors.AccessorInvocationException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class AccessorMethodsUtilizer {
    private static Map classesCache = new HashMap();

    public static Object getField(Object object, String fieldName) {
        if (object != null) {
            try {
                Method getter;
                String suffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                String getterName = "get" + suffix;
                Class<?> cls = object.getClass();
                try {
                    getter = cls.getMethod(getterName, null);
                }
                catch (NoSuchMethodException e) {
                    getterName = "is" + suffix;
                    getter = cls.getMethod(getterName, null);
                }
                return getter.invoke(object, null);
            }
            catch (NoSuchMethodException e) {
                throw new AccessorException("Could not find getter for field " + fieldName, e);
            }
            catch (IllegalAccessException e) {
                throw new AccessorException("Could not access getter for field " + fieldName, e);
            }
            catch (InvocationTargetException e) {
                throw new AccessorInvocationException("Could not invoke getter for field " + fieldName, e.getCause());
            }
        }
        return null;
    }

    public static Object getQualifiedField(Object object, String fieldName, Object key) {
        if (object != null) {
            try {
                String suffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                String getterName = "getFrom" + suffix;
                Class<?> cls = object.getClass();
                Method getter = null;
                Method[] methods = cls.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Class<?>[] paramTypes;
                    Method method = methods[i];
                    if (!method.getName().equals(getterName) || (paramTypes = method.getParameterTypes()).length != 1 || !paramTypes[0].isAssignableFrom(key.getClass())) continue;
                    getter = method;
                }
                if (getter != null) {
                    Object[] args = new Object[]{key};
                    return getter.invoke(object, args);
                }
                throw new AccessorException("Could not find add method for qualified field " + fieldName + " with type " + key.getClass().getName(), null);
            }
            catch (IllegalAccessException e) {
                throw new AccessorException("Could not access getter for qualified field " + fieldName, e);
            }
            catch (InvocationTargetException e) {
                throw new AccessorInvocationException("Could not invoke getter for qualified field " + fieldName, e.getCause());
            }
        }
        return null;
    }

    public static void setField(Object object, String fieldName, Object newValue) {
        if (object != null) {
            try {
                Object[] args;
                Class<?> cls = object.getClass();
                Method setter = AccessorMethodsUtilizer.getSetMethodForField(cls, fieldName);
                if (setter != null) {
                    args = new Object[]{newValue};
                    Class<?>[] parameterTypes = setter.getParameterTypes();
                    if (!(!parameterTypes[0].isPrimitive() && (newValue == null || parameterTypes[0].isInstance(newValue)) || parameterTypes[0].isPrimitive() && newValue != null)) {
                        throw new IllegalArgumentException("Could not set field " + fieldName + " in " + object.getClass() + " to value of type " + (newValue != null ? newValue.getClass() : null));
                    }
                } else {
                    throw new AccessorException("Could not find getter/setter pair for field " + fieldName + " in " + object.getClass(), new NoSuchMethodException());
                }
                setter.invoke(object, args);
            }
            catch (IllegalAccessException e) {
                throw new AccessorException("Could not access getter/setter pair for field " + fieldName + " in " + object.getClass(), e);
            }
            catch (InvocationTargetException e) {
                throw new AccessorInvocationException("Could not invoke getter/setter pair for field " + fieldName + " in " + object.getClass(), e.getCause());
            }
        }
    }

    private static Method getSetMethodForField(Class cls, String fieldName) {
        ClassInfo classInfo = AccessorMethodsUtilizer.getClassInfo(cls);
        FieldInfo fieldInfo = classInfo.getFieldInfo(fieldName);
        if (!fieldInfo.setSearched) {
            Method getter;
            String suffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            String getterName = "get" + suffix;
            String setterName = "set" + suffix;
            try {
                getter = cls.getMethod(getterName, null);
            }
            catch (NoSuchMethodException e) {
                getterName = "is" + suffix;
                try {
                    getter = cls.getMethod(getterName, null);
                }
                catch (NoSuchMethodException e1) {
                    getter = null;
                }
            }
            Method setter = null;
            if (getter != null) {
                Method[] methods = cls.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Class<?>[] parameterTypes;
                    Method method = methods[i];
                    if (!setterName.equals(method.getName()) || (parameterTypes = method.getParameterTypes()).length != 1) continue;
                    for (int j = 0; j < parameterTypes.length; ++j) {
                        Class<?> parameterType = parameterTypes[j];
                        if (!parameterType.isAssignableFrom(getter.getReturnType())) continue;
                        setter = method;
                    }
                }
            }
            fieldInfo.setSearched = true;
            fieldInfo.setMethod = setter;
        }
        return fieldInfo.setMethod;
    }

    public static void addToField(Object object, String fieldName, Object newValue) {
        if (object != null && newValue != null) {
            try {
                Class<?> newValueClass = newValue.getClass();
                Class<?> cls = object.getClass();
                Method addMethod = AccessorMethodsUtilizer.getAddMethodForField(cls, fieldName, newValueClass);
                if (addMethod == null) {
                    throw new AccessorException("Could not find add method for field " + fieldName + " with type " + newValueClass.getName() + " in " + object.getClass(), null);
                }
                Object[] args = new Object[]{newValue};
                addMethod.invoke(object, args);
            }
            catch (IllegalAccessException e) {
                throw new AccessorException("Could not access add method for field " + fieldName, e);
            }
            catch (InvocationTargetException e) {
                throw new AccessorInvocationException("Could not invoke add method for field " + fieldName, e.getCause());
            }
        }
    }

    private static Method getAddMethodForField(Class cls, String fieldName, Class newValueClass) {
        ClassInfo classInfo = AccessorMethodsUtilizer.getClassInfo(cls);
        FieldInfo fieldInfo = classInfo.getFieldInfo(fieldName);
        if (!fieldInfo.addSearched) {
            String suffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            String addName = "addTo" + suffix;
            Method addMethod = null;
            Method[] methods = cls.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] paramTypes;
                Method method = methods[i];
                if (!method.getName().equals(addName) || (paramTypes = method.getParameterTypes()).length != 1 || !paramTypes[0].isAssignableFrom(newValueClass)) continue;
                addMethod = method;
            }
            fieldInfo.addMethod = addMethod;
            fieldInfo.addSearched = true;
        }
        return fieldInfo.addMethod;
    }

    public static void addToQualifiedField(Object object, String fieldName, Object key, Object newValue) {
        block7: {
            if (object != null && newValue != null) {
                try {
                    Class<?> cls = object.getClass();
                    Class<?> keyClass = key != null ? key.getClass() : null;
                    Class<?> newValueClass = newValue.getClass();
                    Method addMethod = AccessorMethodsUtilizer.getAddMethodForQualifiedField(cls, fieldName, keyClass, newValueClass);
                    if (addMethod != null) {
                        if (addMethod.getParameterTypes().length == 2) {
                            Object[] args = new Object[]{key, newValue};
                            addMethod.invoke(object, args);
                        } else {
                            Object[] args = new Object[]{newValue};
                            addMethod.invoke(object, args);
                        }
                        break block7;
                    }
                    throw new AccessorException("Could not find add method for qualified field " + fieldName + " with type " + (keyClass != null ? keyClass.getName() : "(null)") + ", " + newValueClass.getName() + " in " + object.getClass(), null);
                }
                catch (IllegalAccessException e) {
                    throw new AccessorException("Could not access add method for qualified field " + fieldName, e);
                }
                catch (InvocationTargetException e) {
                    throw new AccessorInvocationException("Could not invoke add method for qualified field " + fieldName, e.getCause());
                }
            }
        }
    }

    private static Method getAddMethodForQualifiedField(Class cls, String fieldName, Class keyClass, Class newValueClass) {
        ClassInfo classInfo = AccessorMethodsUtilizer.getClassInfo(cls);
        FieldInfo fieldInfo = classInfo.getFieldInfo(fieldName);
        if (!fieldInfo.addQualifiedSearched) {
            String suffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            String addName = "addTo" + suffix;
            String setName = "set" + suffix;
            Method addMethod = null;
            Method[] methods = cls.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals(addName) && !method.getName().equals(setName)) continue;
                Class<?>[] paramTypes = method.getParameterTypes();
                if (paramTypes.length == 2) {
                    if (keyClass != null && !paramTypes[0].isAssignableFrom(keyClass) || !paramTypes[1].isAssignableFrom(newValueClass)) continue;
                    addMethod = method;
                    continue;
                }
                if (paramTypes.length != 1 || !paramTypes[0].isAssignableFrom(newValueClass) || addMethod != null) continue;
                addMethod = method;
            }
            fieldInfo.addQualifiedMethod = addMethod;
            fieldInfo.addQualifiedSearched = true;
        }
        return fieldInfo.addQualifiedMethod;
    }

    private static ClassInfo getClassInfo(Class cls) {
        ClassInfo info = (ClassInfo)classesCache.get(cls);
        if (info == null) {
            info = new ClassInfo();
            classesCache.put(cls, info);
        }
        return info;
    }

    private static class FieldInfo {
        private Method addQualifiedMethod;
        private boolean addQualifiedSearched;
        private Method addMethod;
        private boolean addSearched;
        private Method setMethod;
        public boolean setSearched;

        private FieldInfo() {
        }
    }

    private static class ClassInfo {
        private Map fields = new HashMap();

        private ClassInfo() {
        }

        private FieldInfo getFieldInfo(String fieldName) {
            FieldInfo fieldInfo = (FieldInfo)this.fields.get(fieldName);
            if (fieldInfo == null) {
                fieldInfo = new FieldInfo();
                this.fields.put(fieldName, fieldInfo);
            }
            return fieldInfo;
        }
    }
}

