/*
 * Decompiled with CFR 0.152.
 */
package de.uni_kassel.fujaba.refactorings.actions.gui;

import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FTreeSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class MethodSelectionDialog
extends JDialog {
    private Set methods;
    private JList methodList;
    private MethodsAbstractListModel dataModel;
    private Object[] methodsArray;
    JLabel noMethodsLabel;
    private boolean allowMultiSelection;

    public boolean addToMethods(UMLMethod value) {
        boolean changed = false;
        if (value != null) {
            if (this.methods == null) {
                this.methods = new FTreeSet(new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return ((UMLMethod)o1).getFullMethodName().compareTo(((UMLMethod)o2).getFullMethodName());
                    }
                });
            }
            changed = this.methods.add(value);
            this.firePropertyChange("methods", null, value);
            this.methodsArray = null;
            this.dataModel.fireContentsChanged();
        }
        return changed;
    }

    public boolean hasInMethods(UMLMethod value) {
        return this.methods != null && value != null && this.methods.contains(value);
    }

    public Iterator iteratorOfMethods() {
        if (this.methods == null) {
            return FEmptyIterator.get();
        }
        return this.methods.iterator();
    }

    public void removeAllFromMethods() {
        Iterator iter = this.iteratorOfMethods();
        while (iter.hasNext()) {
            UMLMethod tmpValue = (UMLMethod)iter.next();
            this.removeFromMethods(tmpValue);
        }
    }

    public boolean removeFromMethods(UMLMethod value) {
        boolean changed = false;
        if (this.methods != null && value != null) {
            changed = this.methods.remove(value);
            this.firePropertyChange("methods", value, null);
            this.methodsArray = null;
            this.dataModel.fireContentsChanged();
        }
        return changed;
    }

    public int sizeOfMethods() {
        return this.methods == null ? 0 : this.methods.size();
    }

    public MethodSelectionDialog(Frame owner, String title, boolean modal, boolean allowMultiSelection) throws HeadlessException {
        super(owner, title, modal);
        this.allowMultiSelection = allowMultiSelection;
        this.init();
    }

    private void init() {
        JPanel content = new JPanel();
        content.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)content, "Center");
        content.setLayout(new BorderLayout(10, 10));
        JPanel buttonPanel = new JPanel();
        content.add((Component)buttonPanel, "South");
        buttonPanel.setLayout(new FlowLayout(1));
        this.noMethodsLabel = new JLabel("no suitable methods found");
        content.add((Component)this.noMethodsLabel, "North");
        JButton okButton = new JButton("Ok");
        okButton.setMnemonic('o');
        buttonPanel.add(okButton);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MethodSelectionDialog.this.okPressed();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setMnemonic('c');
        buttonPanel.add(cancelButton);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MethodSelectionDialog.this.cancelPressed();
            }
        });
        this.getRootPane().setDefaultButton(okButton);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    MethodSelectionDialog.this.cancelPressed();
                }
            }
        });
        this.dataModel = new MethodsAbstractListModel();
        this.methodList = new JList(this.dataModel);
        content.add((Component)this.methodList, "Center");
        if (this.allowMultiSelection) {
            this.methodList.setSelectionMode(2);
        } else {
            this.methodList.setSelectionMode(0);
        }
        this.pack();
    }

    UMLMethod[] getMethodsArray() {
        if (this.methodsArray == null) {
            this.methodsArray = this.methods.toArray(new UMLMethod[0]);
        }
        return (UMLMethod[])this.methodsArray;
    }

    public void show() {
        this.updateMethodList();
        super.show();
    }

    public void pack() {
        super.pack();
        Point location = this.getParent().getLocation();
        location.x += (this.getParent().getWidth() - this.getWidth()) / 2;
        location.y += (this.getParent().getHeight() - this.getHeight()) / 2;
        this.setLocation(location);
    }

    private void updateMethodList() {
        this.methodList.revalidate();
        this.methodList.repaint();
        this.pack();
    }

    void cancelPressed() {
        this.removeAllFromMethods();
        this.dispose();
    }

    void okPressed() {
        int index = 0;
        Iterator it = this.iteratorOfMethods();
        while (it.hasNext()) {
            UMLMethod method = (UMLMethod)it.next();
            if (index < 0 || !this.methodList.getSelectionModel().isSelectedIndex(index)) {
                this.removeFromMethods(method);
            }
            ++index;
        }
        this.dispose();
    }

    private class MethodsAbstractListModel
    extends AbstractListModel {
        MethodsAbstractListModel() {
        }

        public int getSize() {
            return MethodSelectionDialog.this.sizeOfMethods();
        }

        public Object getElementAt(int index) {
            return MethodSelectionDialog.this.getMethodsArray()[index].getFullMethodName();
        }

        protected void fireContentsChanged() {
            MethodSelectionDialog.this.noMethodsLabel.setVisible(MethodSelectionDialog.this.sizeOfMethods() == 0);
            this.fireContentsChanged(MethodSelectionDialog.this, 0, MethodSelectionDialog.this.sizeOfMethods());
        }
    }
}

