/*
 * Decompiled with CFR 0.152.
 */
package de.upb.tools.fca;

import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FEmptySet;
import de.upb.tools.fca.FLinkedList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class FDuplicatedMap
implements Map,
Cloneable,
Serializable {
    public static int last = 0;
    private int id;
    transient Map map;
    private int size;
    private transient Collection values;
    private transient Set entrySet = null;

    public FDuplicatedMap(Map map) {
        this.map = map;
        map.clear();
        this.size = 0;
        this.id = ++last;
    }

    Map getMap() {
        return this.map;
    }

    public synchronized Object clone() {
        Map cloneMap = null;
        Class<?> cloneMapClass = this.map.getClass();
        FDuplicatedMap clone = null;
        try {
            cloneMap = (Map)cloneMapClass.newInstance();
            clone = (FDuplicatedMap)this.getClass().newInstance();
            clone.map = cloneMap;
            cloneMap.clear();
            clone.size = 0;
            clone.id = ++last;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getClass().getName() + ": " + e.getMessage());
        }
        Iterator entryIter = this.map.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry entry = entryIter.next();
            Object currentKey = entry.getKey();
            Collection collect = (Collection)entry.getValue();
            Iterator collectIter = collect.iterator();
            while (collectIter.hasNext()) {
                clone.put(currentKey, collectIter.next());
            }
        }
        return clone;
    }

    public synchronized int size() {
        return this.map.size();
    }

    public synchronized int size(Object key) {
        int size = 0;
        Collection tmp = (Collection)this.map.get(key);
        if (tmp != null) {
            size = tmp.size();
        }
        return size;
    }

    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    public synchronized boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public synchronized boolean containsValue(Object value) {
        Iterator colIter = this.map.values().iterator();
        while (colIter.hasNext()) {
            Iterator valIter = ((Collection)colIter.next()).iterator();
            while (valIter.hasNext()) {
                if (!this.valEquals(value, valIter.next())) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean containsEntry(Object key, Object value) {
        Collection tmp = (Collection)this.map.get(key);
        if (tmp != null) {
            return tmp.contains(value);
        }
        return false;
    }

    public synchronized Object get(Object key) {
        Iterator it;
        Collection tmp = (Collection)this.map.get(key);
        if (tmp != null && (it = tmp.iterator()).hasNext()) {
            return it.next();
        }
        return null;
    }

    public synchronized Object put(Object key, Object value) {
        Collection tmp = (Collection)this.map.get(key);
        if (tmp == null) {
            tmp = this.createValueCollection();
            this.map.put(key, tmp);
        }
        if (tmp.contains(value)) {
            return value;
        }
        ++this.size;
        tmp.add(value);
        return null;
    }

    protected Collection createValueCollection() {
        return new FLinkedList();
    }

    public synchronized Object remove(Object key) {
        Collection tmp = (Collection)this.map.get(key);
        if (tmp != null) {
            this.size -= tmp.size();
            this.map.remove(key);
        }
        return tmp;
    }

    public synchronized Object remove(Object key, Object value) {
        Collection tmp = (Collection)this.map.get(key);
        if (tmp != null) {
            Iterator iter = tmp.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!this.valEquals(value, obj)) continue;
                tmp.remove(obj);
                if (tmp.isEmpty()) {
                    this.map.remove(key);
                }
                --this.size;
                return value;
            }
        }
        return null;
    }

    public synchronized void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    public synchronized void clear() {
        Iterator iter = this.map.values().iterator();
        while (iter.hasNext()) {
            ((Collection)iter.next()).clear();
        }
        this.map.clear();
        this.size = 0;
    }

    public synchronized Set keySet() {
        return this.map.keySet();
    }

    public synchronized Collection values() {
        if (this.values == null) {
            this.values = new ValuesSet();
        }
        return this.values;
    }

    public synchronized Collection values(Object key) {
        return (Collection)this.map.get(key);
    }

    public synchronized Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public synchronized Set entrySet(Object key) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName());
        buf.append("[id=");
        buf.append(this.id);
        buf.append(",map=");
        buf.append(this.map);
        buf.append("]");
        return buf.toString();
    }

    boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    boolean keyEquals(Object o1, Object o2) {
        return this.valEquals(o1, o2);
    }

    private class MyMap
    implements Map.Entry {
        Object key;
        Object value;

        public MyMap(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return FDuplicatedMap.this.keyEquals(this.key, entry.getKey()) && FDuplicatedMap.this.valEquals(this.value, entry.getValue());
        }

        public int hashCode() {
            int keyHash = this.key == null ? 0 : this.key.hashCode();
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }
    }

    private class FDuplicatedMapIterator
    extends FEmptyIterator {
        public static final int VALUES = 0;
        public static final int ENTRIES = 1;
        Iterator colIter;
        Iterator valIter;
        private Object key;
        private Object value;
        private boolean fetched;
        private int type;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FDuplicatedMapIterator(int type) {
            FDuplicatedMap fDuplicatedMap = FDuplicatedMap.this;
            synchronized (fDuplicatedMap) {
                this.type = type;
                this.colIter = FDuplicatedMap.this.map.entrySet().iterator();
                this.value = null;
                if (this.colIter.hasNext()) {
                    Map.Entry entry = (Map.Entry)this.colIter.next();
                    this.key = entry.getKey();
                    this.valIter = ((Collection)entry.getValue()).iterator();
                    if (this.valIter.hasNext()) {
                        this.value = this.valIter.next();
                    }
                }
                this.fetched = true;
            }
        }

        public boolean hasNext() {
            if (!this.fetched && this.value != null) {
                if (!this.valIter.hasNext() && this.colIter.hasNext()) {
                    Map.Entry entry = (Map.Entry)this.colIter.next();
                    this.key = entry.getKey();
                    this.valIter = ((Collection)entry.getValue()).iterator();
                }
                this.value = this.valIter.hasNext() ? this.valIter.next() : null;
                this.fetched = true;
            }
            return this.value != null;
        }

        public Object next() {
            if (!this.fetched && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.fetched = false;
            if (this.type == 0) {
                return this.value;
            }
            return new MyMap(this.key, this.value);
        }
    }

    private class ValuesSet
    extends FEmptySet {
        private ValuesSet() {
        }

        public int size() {
            return FDuplicatedMap.this.size();
        }

        public boolean isEmpty() {
            return FDuplicatedMap.this.isEmpty();
        }

        public boolean contains(Object obj) {
            return FDuplicatedMap.this.containsValue(obj);
        }

        public Iterator iterator() {
            return new FDuplicatedMapIterator(0);
        }

        public void clear() {
            FDuplicatedMap.this.clear();
        }
    }

    private class EntrySet
    extends FEmptySet {
        private EntrySet() {
        }

        public int size() {
            return FDuplicatedMap.this.size();
        }

        public boolean isEmpty() {
            return FDuplicatedMap.this.isEmpty();
        }

        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return FDuplicatedMap.this.containsEntry(entry.getKey(), entry.getValue());
        }

        public Iterator iterator() {
            return new FDuplicatedMapIterator(1);
        }

        public void clear() {
            FDuplicatedMap.this.clear();
        }
    }
}

