/*
 * Decompiled with CFR 0.152.
 */
package de.upb.tools.fca;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class FFilterIterator
implements Iterator {
    private final Iterator clientIterator;
    private final Filter filter;
    private final Translator translator;
    private transient boolean cacheEmpty = true;
    private transient Object cache = null;
    private transient boolean failedSearch = false;

    public FFilterIterator(Filter filter, Iterator iterator) {
        this(filter, null, iterator);
    }

    public FFilterIterator(Filter filter, Translator translator, Iterator iterator) {
        this.clientIterator = iterator;
        this.filter = filter;
        this.translator = translator;
        if (iterator == null) {
            throw new NullPointerException();
        }
    }

    public boolean hasNext() {
        if (this.filter != null) {
            boolean next;
            boolean bl = next = !this.cacheEmpty;
            if (!next && this.clientIterator.hasNext()) {
                next = this.findNext();
            }
            return next;
        }
        return this.clientIterator.hasNext();
    }

    public Object next() throws NoSuchElementException {
        if (this.filter != null) {
            if (this.cacheEmpty && !this.findNext()) {
                throw new NoSuchElementException();
            }
            Object result = this.cache;
            this.cacheEmpty = true;
            this.failedSearch = false;
            this.cache = null;
            if (this.translator == null) {
                return result;
            }
            return this.translator.translate(result);
        }
        if (this.translator == null) {
            return this.clientIterator.next();
        }
        return this.translator.translate(this.clientIterator.next());
    }

    private boolean findNext() {
        while (this.cacheEmpty && this.clientIterator.hasNext()) {
            this.failedSearch = true;
            this.cache = this.clientIterator.next();
            this.cacheEmpty = !this.filter.include(this.cache);
        }
        if (this.cacheEmpty) {
            this.cache = null;
        } else {
            this.failedSearch = false;
        }
        return !this.cacheEmpty;
    }

    public void remove() throws UnsupportedOperationException, IllegalStateException {
        if (!this.cacheEmpty || this.failedSearch) {
            throw new IllegalStateException();
        }
        this.clientIterator.remove();
    }

    public static final class NotFilter
    implements Filter {
        private final Filter filter;

        public NotFilter(Filter filter) {
            this.filter = filter;
        }

        public boolean include(Object o) {
            return !this.filter.include(o);
        }
    }

    public static final class OrFilter
    implements Filter {
        private final Filter[] filters;

        public OrFilter(Filter[] filters) {
            this.filters = filters;
        }

        public boolean include(Object o) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (!this.filters[i].include(o)) continue;
                return true;
            }
            return false;
        }
    }

    public static final class AndFilter
    implements Filter {
        private final Filter[] filters;

        public AndFilter(Filter[] filters) {
            this.filters = filters;
        }

        public boolean include(Object o) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i].include(o)) continue;
                return false;
            }
            return true;
        }
    }

    public static interface Filter {
        public boolean include(Object var1);
    }

    public static interface Translator {
        public Object translate(Object var1);
    }
}

