/*
 * Decompiled with CFR 0.152.
 */
package de.upb.tools.fca;

import de.upb.tools.fca.FHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class FHashSet
extends AbstractSet
implements Set,
Cloneable,
Serializable {
    private transient FHashMap map;
    private static final Object DUMMY_VALUE = "DUMMYVALUE";

    public FHashSet() {
        this.map = new FHashMap();
    }

    public FHashSet(Collection c) {
        this.map = new FHashMap(Math.max(2 * c.size(), 11));
        this.addAll(c);
    }

    public FHashSet(int initialCapacity, float loadFactor) {
        this.map = new FHashMap(initialCapacity, loadFactor);
    }

    public FHashSet(int initialCapacity) {
        this.map = new FHashMap(initialCapacity);
    }

    public synchronized Object clone() {
        try {
            FHashSet newSet = (FHashSet)super.clone();
            newSet.map = (FHashMap)this.map.clone();
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public synchronized void clear() {
        this.map.clear();
    }

    public synchronized int size() {
        return this.map.size();
    }

    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    public synchronized boolean add(Object obj) {
        return this.map.put(obj, DUMMY_VALUE) != DUMMY_VALUE;
    }

    public synchronized boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    public synchronized boolean remove(Object obj) {
        return this.map.remove(obj) == DUMMY_VALUE;
    }

    public synchronized Iterator iterator() {
        return this.map.keySet().iterator();
    }

    public boolean removeAll(Collection c) {
        boolean modified = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            modified |= this.remove(i.next());
        }
        return modified;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.map.capacity());
        out.writeFloat(this.map.loadFactor());
        out.writeInt(this.map.size());
        Iterator iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            out.writeObject(iter.next());
        }
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int capacity = in.readInt();
        float loadFactor = in.readFloat();
        this.map = new FHashMap(capacity, loadFactor);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object e = in.readObject();
            this.map.put(e, DUMMY_VALUE);
        }
    }
}

