/*
 * Decompiled with CFR 0.152.
 */
package de.upb.tools.fca;

import de.upb.tools.fca.FEmptyListIterator;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class FLinkedList
extends AbstractSequentialList
implements List,
Cloneable,
Serializable {
    transient Element header = new Element(null, null, null);
    transient int size = 0;
    private transient Element currentElement;
    transient int clearCount = 0;
    private static final transient boolean BEFORE = true;
    private static final transient boolean AFTER = false;

    public FLinkedList() {
        this.header.next = this.header;
        this.header.previous = this.header;
    }

    public FLinkedList(Collection c) {
        this();
        this.addAll(c);
    }

    public FLinkedList(Object[] array) {
        this();
        for (int i = 0; i < array.length; ++i) {
            this.add(array[i]);
        }
    }

    private static final boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public synchronized Object clone() {
        return new FLinkedList(this);
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator iter = this.iterator();
        buf.append("FLinkedList[");
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(",");
        }
        buf.append("]");
        return new String(buf);
    }

    public synchronized Object getFirst() {
        if (this.header.next == this.header) {
            throw new NoSuchElementException();
        }
        return this.header.next.key;
    }

    public synchronized Object getLast() {
        if (this.header.next == this.header) {
            throw new NoSuchElementException();
        }
        return this.header.previous.key;
    }

    public synchronized Object removeFirst() {
        Element firstElement = this.header.next;
        if (firstElement == this.header) {
            throw new NoSuchElementException();
        }
        this.removeElement(firstElement);
        return firstElement.key;
    }

    public synchronized Object removeLast() {
        Element lastElement = this.header.previous;
        if (lastElement == this.header) {
            throw new NoSuchElementException();
        }
        this.removeElement(this.header.previous);
        return lastElement.key;
    }

    public synchronized void addFirst(Object key) {
        this.addAfter(key, this.header);
    }

    public synchronized void addLast(Object key) {
        this.addBefore(key, this.header);
    }

    public synchronized boolean contains(Object key) {
        return this.indexOf(key) != -1;
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized boolean add(Object key) {
        this.addBefore(key, this.header);
        return true;
    }

    public synchronized boolean remove(Object key) {
        if (key == null) {
            Element elem = this.header.next;
            while (elem != this.header) {
                if (elem.key == null) {
                    this.removeElement(elem);
                    return true;
                }
                elem = elem.next;
            }
        } else {
            Element elem = this.header.next;
            while (elem != this.header) {
                if (FLinkedList.equals(key, elem.key)) {
                    this.removeElement(elem);
                    return true;
                }
                elem = elem.next;
            }
        }
        return false;
    }

    public synchronized boolean addAll(Collection c) {
        return this.addAll(this.size, c);
    }

    public synchronized boolean addAll(int index, Collection collection) {
        if (collection.size() == 0) {
            return false;
        }
        Element successor = index >= this.size ? this.header.previous : this.getElement(index);
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            successor = this.addAfter(iter.next(), successor);
        }
        return true;
    }

    public synchronized void clear() {
        this.header.next = this.header.previous = this.header;
        this.size = 0;
        ++this.clearCount;
    }

    public synchronized Object get(int index) {
        return this.getElement((int)index).key;
    }

    public synchronized Object set(int index, Object key) {
        Element elem = this.getElement(index);
        Object oldKey = elem.key;
        elem.key = key;
        return oldKey;
    }

    public synchronized void add(int index, Object key) {
        Element successor = index >= this.size ? this.header : this.getElement(index);
        this.addBefore(key, successor);
    }

    public synchronized void addAfter(Object value, Object sibling) {
        if (sibling == null) {
            Element elem = this.header.next;
            while (elem != this.header) {
                if (elem.key == null) {
                    this.addAfter(value, elem);
                    return;
                }
                elem = elem.next;
            }
        } else {
            Element elem = this.header.next;
            while (elem != this.header) {
                if (FLinkedList.equals(sibling, elem.key)) {
                    this.addAfter(value, elem);
                    return;
                }
                elem = elem.next;
            }
        }
        this.addLast(value);
    }

    public synchronized Object remove(int index) {
        Element elem = this.getElement(index);
        this.removeElement(elem);
        return elem.key;
    }

    public int indexOf(Object key) {
        return this.indexOf(key, 0);
    }

    public synchronized int indexOf(Object key, int from) {
        int index;
        Element elem = this.header.next;
        for (index = 0; index < from && elem != this.header; ++index) {
            elem = elem.next;
        }
        if (key == null) {
            while (elem != this.header) {
                if (elem.key == null) {
                    return index;
                }
                ++index;
                elem = elem.next;
            }
        } else {
            while (elem != this.header) {
                if (FLinkedList.equals(key, elem.key)) {
                    return index;
                }
                ++index;
                elem = elem.next;
            }
        }
        return -1;
    }

    public synchronized int lastIndexOf(Object key, int last) {
        int index;
        Element elem = this.header.previous;
        for (index = this.size - 1; index > last && elem != this.header; --index) {
            elem = elem.previous;
        }
        if (key == null) {
            while (elem != this.header) {
                --index;
                if (elem.key == null) {
                    return index;
                }
                elem = elem.previous;
            }
        } else {
            while (elem != this.header) {
                --index;
                if (FLinkedList.equals(key, elem.key)) {
                    return index;
                }
                elem = elem.previous;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object key) {
        return this.lastIndexOf(key, this.size);
    }

    public synchronized boolean isEmpty() {
        return this.header.next == this.header;
    }

    public synchronized Iterator iterator() {
        return new FLinkedListIterator();
    }

    public ListIterator listIterator() {
        return new FLinkedListIterator();
    }

    public synchronized ListIterator listIterator(int index) {
        return new FLinkedListIterator(index);
    }

    public synchronized boolean add(Iterator iter, Object value) {
        if (!(iter instanceof FLinkedListIterator)) {
            throw new IllegalArgumentException("Not an Iterator on this List");
        }
        FLinkedListIterator fIter = (FLinkedListIterator)iter;
        if (fIter.orgList != this) {
            throw new IllegalArgumentException("Not an Iterator on this List");
        }
        if (fIter.expectedClearCount != this.clearCount) {
            throw new ConcurrentModificationException();
        }
        if (fIter.position) {
            this.addBefore(value, fIter.current);
        } else {
            this.addAfter(value, fIter.current);
        }
        return true;
    }

    public synchronized boolean remove(Iterator iter) {
        if (!(iter instanceof FLinkedListIterator)) {
            throw new IllegalArgumentException("Not an Iterator on this List");
        }
        FLinkedListIterator fIter = (FLinkedListIterator)iter;
        if (fIter.orgList != this) {
            throw new IllegalArgumentException("Not an Iterator on this List");
        }
        if (fIter.expectedClearCount != this.clearCount) {
            throw new ConcurrentModificationException();
        }
        if (fIter.last == this.header) {
            throw new NoSuchElementException();
        }
        if (fIter.last.next.previous == fIter.last) {
            this.removeElement(fIter.last);
            return true;
        }
        return false;
    }

    final Element getElement(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        Element elem = this.header;
        if (index < this.size / 2) {
            for (int i = 0; i <= index; ++i) {
                elem = elem.next;
            }
        } else {
            for (int i = this.size; i > index; --i) {
                elem = elem.previous;
            }
        }
        return elem;
    }

    protected void removeElement(Element elem) {
        elem.previous.next = elem.next;
        elem.next.previous = elem.previous;
        --this.size;
    }

    protected Element addAfter(Object obj, Element afterElem) {
        Element elem;
        afterElem.next.previous = elem = new Element(obj, afterElem.next, afterElem);
        afterElem.next = elem;
        ++this.size;
        return elem;
    }

    protected Element addBefore(Object obj, Element beforeElem) {
        Element elem;
        beforeElem.previous.next = elem = new Element(obj, beforeElem, beforeElem.previous);
        beforeElem.previous = elem;
        ++this.size;
        return elem;
    }

    public synchronized Object[] toArray() {
        Object[] result = new Object[this.size];
        int i = 0;
        Element elem = this.header.next;
        while (elem != this.header) {
            result[i] = elem.key;
            ++i;
            elem = elem.next;
        }
        return result;
    }

    public synchronized Object[] toArray(Object[] array) {
        if (array.length < this.size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.size);
        }
        int i = 0;
        Element elem = this.header.next;
        while (elem != this.header) {
            array[i] = elem.key;
            ++i;
            elem = elem.next;
        }
        if (array.length > this.size) {
            array[this.size] = null;
        }
        return array;
    }

    public Object getNextOf(Object aObject) {
        Object result = null;
        if (this.currentElement != null && aObject == this.currentElement.key && aObject != this.header.previous.key) {
            this.currentElement = this.currentElement.next;
            result = this.currentElement.key;
        } else if (this.currentElement != null && aObject == this.currentElement.key && aObject == this.header.previous.key) {
            result = null;
        } else if (aObject != this.header.previous.key) {
            int size = this.size();
            Element elem = this.header.next;
            boolean found = false;
            for (int index = 0; index < size && !found; ++index) {
                if (elem.key == aObject) {
                    found = true;
                    this.currentElement = elem.next;
                    result = this.currentElement.key;
                }
                elem = elem.next;
            }
        }
        return result;
    }

    public Object getNextIndexOf(Object aObject, int aIndex) {
        return this.getNextOf(aObject, aIndex);
    }

    public Object getNextOf(Object aObject, int aIndex) {
        int index;
        int size;
        Object result = null;
        if (aIndex < 1 && aIndex < this.size) {
            return null;
        }
        if (this.currentElement != null && this.currentElement.key != aObject) {
            size = this.size();
            boolean found = false;
            Element elem = this.header.next;
            for (index = 0; index < size && !found; ++index) {
                if (elem.key == aObject) {
                    found = true;
                    this.currentElement = elem;
                }
                elem = elem.next;
            }
        }
        if (aIndex == 1) {
            result = this.getNextOf(aObject);
        } else if (aIndex >= 2) {
            size = this.size();
            Element elem = this.header.next;
            boolean found = false;
            for (index = 0; index < size && !found; ++index) {
                if (elem.key == aObject) {
                    found = true;
                    this.currentElement = elem;
                }
                elem = elem.next;
            }
            elem = this.currentElement;
            boolean outOfBounds = false;
            for (int index2 = 0; index2 < aIndex && !outOfBounds; ++index2) {
                if (elem == this.header) {
                    outOfBounds = true;
                    result = null;
                }
                elem = elem.next;
            }
            if (!outOfBounds) {
                this.currentElement = elem;
                result = elem.key;
            }
        }
        return result;
    }

    public Object getPreviousOf(Object aObject) {
        Object result = null;
        if (this.currentElement != null && aObject == this.currentElement.key && aObject != this.header.next.key) {
            this.currentElement = this.currentElement.previous;
            result = this.currentElement.key;
        } else if (this.currentElement != null && aObject == this.currentElement.key && aObject == this.header.next.key) {
            result = null;
        } else if (aObject != this.header.next.key) {
            int size = this.size();
            Element elem = this.header.next;
            boolean found = false;
            for (int index = 0; index < size && !found; ++index) {
                if (elem.key == aObject) {
                    found = true;
                    this.currentElement = elem.previous;
                    result = this.currentElement.key;
                }
                elem = elem.next;
            }
        }
        return result;
    }

    public Object getPreviousIndexOf(Object aObject, int aIndex) {
        return this.getPreviousOf(aObject, aIndex);
    }

    public Object getPreviousOf(Object aObject, int aIndex) {
        int index;
        int size;
        Object result = null;
        if (aIndex < 1 && aIndex < this.size) {
            return null;
        }
        if (this.currentElement != null && this.currentElement.key != aObject) {
            size = this.size();
            boolean found = false;
            Element elem = this.header.next;
            for (index = 0; index < size && !found; ++index) {
                if (elem.key == aObject) {
                    found = true;
                    this.currentElement = elem;
                }
                elem = elem.next;
            }
        }
        if (aIndex == 1) {
            result = this.getPreviousOf(aObject);
        } else if (aIndex >= 2) {
            size = this.size();
            Element elem = this.header.next;
            boolean found = false;
            for (index = 0; index < size && !found; ++index) {
                if (elem.key == aObject) {
                    found = true;
                    this.currentElement = elem;
                }
                elem = elem.next;
            }
            elem = this.currentElement;
            boolean outOfBounds = false;
            for (int index2 = 0; index2 < aIndex && !outOfBounds; ++index2) {
                if (elem == this.header) {
                    outOfBounds = true;
                    result = null;
                }
                elem = elem.previous;
            }
            if (!outOfBounds) {
                this.currentElement = elem;
                result = elem.key;
            }
        }
        return result;
    }

    public Object next() {
        Object result = null;
        if (this.currentElement != this.header.previous) {
            this.currentElement = this.currentElement.next;
            result = this.currentElement.next.key;
        } else {
            result = null;
        }
        return result;
    }

    public Object previous() {
        Object result = null;
        if (this.currentElement != this.header.next) {
            this.currentElement = this.currentElement.previous;
            result = this.currentElement.previous.key;
        } else {
            result = null;
        }
        return result;
    }

    public boolean isBefore(Object leftObject, Object rightObject) {
        return this.indexOf(leftObject) < this.indexOf(rightObject);
    }

    public boolean isAfter(Object leftObject, Object rightObject) {
        return this.indexOf(leftObject) > this.indexOf(rightObject);
    }

    protected static class Element {
        protected Object key;
        protected Element previous;
        protected Element next;

        public Element(Object key, Element next, Element previous) {
            this.key = key;
            this.previous = previous;
            this.next = next;
        }
    }

    private class FLinkedListIterator
    extends FEmptyListIterator {
        Element current;
        boolean position = true;
        int expectedClearCount;
        FLinkedList orgList;
        Element last;
        private Element theHeader;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected FLinkedListIterator() {
            this.expectedClearCount = FLinkedList.this.clearCount;
            this.orgList = FLinkedList.this;
            this.last = FLinkedList.this.header;
            this.theHeader = FLinkedList.this.header;
            FLinkedList fLinkedList = this.orgList;
            synchronized (fLinkedList) {
                this.current = this.theHeader.next;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected FLinkedListIterator(int index) {
            this.expectedClearCount = FLinkedList.this.clearCount;
            this.orgList = FLinkedList.this;
            this.last = FLinkedList.this.header;
            this.theHeader = FLinkedList.this.header;
            if (index < 0 || index > FLinkedList.this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + FLinkedList.this.size);
            }
            FLinkedList fLinkedList = this.orgList;
            synchronized (fLinkedList) {
                if (index < FLinkedList.this.size / 2) {
                    this.current = this.theHeader.next;
                    for (int i = 0; i < index; ++i) {
                        this.current = this.current.next;
                    }
                } else {
                    this.current = this.theHeader;
                    for (int i = FLinkedList.this.size; i > index; --i) {
                        this.current = this.current.previous;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean hasNext() {
            FLinkedList fLinkedList = this.orgList;
            synchronized (fLinkedList) {
                if (!this.position) {
                    if (this.expectedClearCount != FLinkedList.this.clearCount) {
                        this.current = this.theHeader;
                    } else {
                        do {
                            this.current = this.current.next;
                        } while (this.current != this.theHeader && this.current.previous.next != this.current);
                    }
                    this.position = true;
                }
                return this.current != this.theHeader;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean hasPrevious() {
            FLinkedList fLinkedList = this.orgList;
            synchronized (fLinkedList) {
                if (this.position) {
                    if (this.expectedClearCount != FLinkedList.this.clearCount) {
                        this.current = this.theHeader;
                    } else {
                        do {
                            this.current = this.current.previous;
                        } while (this.current != this.theHeader && this.current.next.previous != this.current);
                    }
                    this.position = false;
                }
                return this.current != this.theHeader;
            }
        }

        public synchronized Object next() {
            if (!this.position) {
                this.hasNext();
            }
            if (this.current == this.theHeader) {
                throw new NoSuchElementException();
            }
            this.position = false;
            this.last = this.current;
            return this.current.key;
        }

        public synchronized Object previous() {
            if (this.position) {
                this.hasPrevious();
            }
            if (this.current == this.theHeader) {
                throw new NoSuchElementException();
            }
            this.position = true;
            this.last = this.current;
            return this.current.key;
        }

        public String toString() {
            return this.current.key + "";
        }
    }
}

