/*
 * Decompiled with CFR 0.152.
 */
package de.upb.tools.fca;

import de.upb.tools.fca.FDuplicatedTreeMap;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FEmptySet;
import de.upb.tools.pcs.CollectionChangeEvent;
import de.upb.tools.pcs.PropertyChangeInterface;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FPropMap
implements Serializable,
Cloneable,
Map {
    private transient PropertyChangeInterface owner = null;
    private transient String propertyName = null;
    transient Map map = null;

    private FPropMap() {
    }

    public FPropMap(Map map, PropertyChangeInterface owner, String name) {
        this.setOwner(owner);
        this.setPropertyName(name);
        this.map = map;
        if (this.getPropertyChangeSupport() != null && map != null) {
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.firePropertyChange(null, entry.getValue(), entry.getKey(), 1);
            }
        }
    }

    public void clear() {
        Map.Entry[] entries = null;
        PropertyChangeSupport propertyChangeSupport = this.getPropertyChangeSupport();
        if (this.map == null) {
            return;
        }
        if (propertyChangeSupport != null) {
            entries = (Map.Entry[])this.map.entrySet().toArray();
        }
        this.map.clear();
        if (propertyChangeSupport != null) {
            for (int i = 0; i < entries.length; ++i) {
                this.firePropertyChange(entries[i].getValue(), null, entries[i].getKey(), 2);
            }
        }
    }

    public boolean containsKey(Object key) {
        return this.map != null && this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map != null && this.map.containsValue(value);
    }

    public Object get(Object key) {
        if (this.map != null) {
            return this.map.get(key);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    public Object put(Object key, Object value) {
        PropertyChangeSupport propertyChangeSupport = this.getPropertyChangeSupport();
        boolean old = propertyChangeSupport != null && !(this.map instanceof FDuplicatedTreeMap) && this.map.containsKey(key);
        Object result = this.map.put(key, value);
        if (propertyChangeSupport != null) {
            this.firePropertyChange(result, value, key, old ? 3 : 1);
        }
        return result;
    }

    public void putAll(Map t) {
        if (this.map == null) {
            throw new NullPointerException();
        }
        if (this.getPropertyChangeSupport() == null) {
            this.map.putAll(t);
        } else {
            Iterator iter = t.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public Object remove(Object key) {
        if (this.map == null) {
            return null;
        }
        boolean old = this.getPropertyChangeSupport() != null && this.map.containsKey(key);
        Object result = this.map.remove(key);
        if (old) {
            if (this.map instanceof FDuplicatedTreeMap && result != null) {
                Iterator iter = ((Collection)result).iterator();
                while (iter.hasNext()) {
                    this.firePropertyChange(iter.next(), null, key, 2);
                }
            } else {
                this.firePropertyChange(result, null, key, 2);
            }
        }
        return result;
    }

    public int size() {
        if (this.map == null) {
            return 0;
        }
        return this.map.size();
    }

    public String toString() {
        return super.toString() + "\n\t[underlying Map: " + this.map.toString() + "]";
    }

    public Collection values() {
        if (this.map == null) {
            return new FEmptySet();
        }
        return new ValuesCollection();
    }

    public Set entrySet() {
        if (this.map == null) {
            return new FEmptySet();
        }
        return new EntrySet();
    }

    public Set keySet() {
        if (this.map == null) {
            return new FEmptySet();
        }
        return new KeySet();
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.owner == null ? null : this.owner.getPropertyChangeSupport();
    }

    public void setOwner(PropertyChangeInterface owner) {
        this.owner = owner;
    }

    public PropertyChangeInterface getOwner() {
        return this.owner;
    }

    public void setPropertyName(String name) {
        this.propertyName = name;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    protected void firePropertyChange(Object oldValue, Object newValue, Object key, int type) {
        PropertyChangeSupport propertyChangeSupport = this.getPropertyChangeSupport();
        if (propertyChangeSupport != null) {
            propertyChangeSupport.firePropertyChange(CollectionChangeEvent.get((Object)this.owner, this.propertyName, (Object)this, oldValue, newValue, key, type));
        }
    }

    private static class Element
    implements Map.Entry {
        private Map.Entry entry = null;
        private FPropMap map = null;

        public Element(FPropMap map, Map.Entry source) {
            this.entry = source;
            this.map = map;
        }

        public Object getKey() {
            return this.entry.getKey();
        }

        public Object getValue() {
            return this.entry.getValue();
        }

        public Object setValue(Object value) {
            Object oldValue = this.entry.setValue(value);
            if (value != oldValue && this.map != null) {
                this.map.firePropertyChange(oldValue, value, this.entry.getKey(), 3);
            }
            return oldValue;
        }
    }

    private class FPropMapIterator
    extends FEmptyIterator {
        private static final int KEYS = 0;
        private static final int VALUES = 1;
        private static final int ENTRIES = 2;
        private int type;
        private Iterator mapIter = null;
        private Map.Entry current = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FPropMapIterator(int type) {
            FPropMap fPropMap = FPropMap.this;
            synchronized (fPropMap) {
                this.type = type;
                this.mapIter = FPropMap.this.map != null ? FPropMap.this.map.entrySet().iterator() : FEmptyIterator.get();
            }
        }

        public synchronized boolean hasNext() {
            return this.mapIter.hasNext();
        }

        public synchronized Object next() {
            Map.Entry result;
            this.current = result = (Map.Entry)this.mapIter.next();
            if (this.type == 2) {
                return new Element(FPropMap.this, result);
            }
            if (this.type == 1) {
                return result.getValue();
            }
            if (this.type == 0) {
                return result.getKey();
            }
            throw new RuntimeException("Unknown Type-ID: " + this.type);
        }

        public synchronized void remove() {
            this.mapIter.remove();
            if (FPropMap.this.getPropertyChangeSupport() != null) {
                FPropMap.this.firePropertyChange(this.current.getValue(), null, this.current.getKey(), 2);
            }
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new FPropMapIterator(2);
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Object key = ((Map.Entry)o).getKey();
            Object val = ((Map.Entry)o).getValue();
            if (FPropMap.this.map instanceof FDuplicatedTreeMap) {
                return ((FDuplicatedTreeMap)FPropMap.this.map).containsEntry(key, val);
            }
            Object myVal = FPropMap.this.get(key);
            return myVal == null ? val == null : myVal.equals(val);
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Object key = ((Map.Entry)o).getKey();
            Object val = ((Map.Entry)o).getValue();
            Object myVal = FPropMap.this.get(key);
            if (myVal == null && val == null || myVal.equals(val)) {
                FPropMap.this.remove(key);
                return true;
            }
            return false;
        }

        public int size() {
            return FPropMap.this.size();
        }

        public void clear() {
            FPropMap.this.clear();
        }
    }

    private class ValuesCollection
    extends AbstractCollection {
        private ValuesCollection() {
        }

        public Iterator iterator() {
            return new FPropMapIterator(1);
        }

        public int size() {
            return FPropMap.this.size();
        }

        public boolean contains(Object obj) {
            return FPropMap.this.containsValue(obj);
        }

        public void clear() {
            FPropMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new FPropMapIterator(0);
        }

        public int size() {
            return FPropMap.this.size();
        }

        public boolean contains(Object o) {
            return FPropMap.this.containsKey(o);
        }

        public boolean remove(Object o) {
            return FPropMap.this.remove(o) != null;
        }

        public void clear() {
            FPropMap.this.clear();
        }
    }
}

