/*
 * Decompiled with CFR 0.152.
 */
package de.upb.tools.fca;

import de.upb.tools.fca.FTreeSet;
import de.upb.tools.pcs.CollectionChangeEvent;
import de.upb.tools.pcs.PropertyChangeInterface;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Vector;

public class FPropTreeSet
extends FTreeSet {
    private PropertyChangeInterface owner = null;
    private String propertyName = null;

    private FPropTreeSet() {
    }

    FPropTreeSet(SortedMap map, PropertyChangeInterface owner, String name) {
        super(map);
        this.setOwner(owner);
        this.setPropertyName(name);
        if (this.getPropertyChangeSupport() != null) {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                this.firePropertyChange(null, iter.next(), 1);
            }
        }
    }

    public FPropTreeSet(PropertyChangeInterface owner, String name) {
        this.setOwner(owner);
        this.setPropertyName(name);
    }

    public FPropTreeSet(Comparator comp, PropertyChangeInterface owner, String name) {
        super(comp);
        this.setOwner(owner);
        this.setPropertyName(name);
    }

    public FPropTreeSet(Collection collection, PropertyChangeInterface owner, String name) {
        super(collection);
        this.setOwner(owner);
        this.setPropertyName(name);
        if (this.getPropertyChangeSupport() != null) {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                this.firePropertyChange(null, iter.next(), 1);
            }
        }
    }

    public FPropTreeSet(SortedSet set, PropertyChangeInterface owner, String name) {
        super(set);
        this.setOwner(owner);
        this.setPropertyName(name);
        if (this.getPropertyChangeSupport() != null) {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                this.firePropertyChange(null, iter.next(), 1);
            }
        }
    }

    public synchronized Object clone() {
        return new FPropTreeSet(this, null, null);
    }

    public synchronized void clear() {
        Object[] entries = null;
        PropertyChangeSupport propertyChangeSupport = this.getPropertyChangeSupport();
        if (propertyChangeSupport != null) {
            entries = this.toArray();
        }
        super.clear();
        if (propertyChangeSupport != null) {
            for (int i = 0; i < entries.length; ++i) {
                this.firePropertyChange(entries[i], null, 2);
            }
        }
    }

    public synchronized boolean add(Object obj) {
        boolean added = super.add(obj);
        if (added && this.getPropertyChangeSupport() != null) {
            this.firePropertyChange(null, obj, 1);
        }
        return added;
    }

    public synchronized boolean addAll(Collection c) {
        Vector added = null;
        if (this.getPropertyChangeSupport() != null && this.size() == 0 && c.size() > 0 && c instanceof SortedSet) {
            added = new Vector();
            Comparator comp = this.comparator();
            Iterator myIter = this.iterator();
            Iterator cIter = c.iterator();
            while (cIter.hasNext()) {
                Object cObj = cIter.next();
                Object myObj = null;
                int result = -1;
                while (myIter.hasNext() && result < 0) {
                    myObj = myIter.next();
                    result = comp.compare(myObj, cObj);
                }
                if (result == 0) continue;
                added.add(cObj);
            }
        }
        boolean result = super.addAll(c);
        if (added != null) {
            Iterator iter = added.iterator();
            while (iter.hasNext()) {
                this.firePropertyChange(null, iter.next(), 1);
            }
        }
        return result;
    }

    public synchronized boolean remove(Object obj) {
        boolean removed = super.remove(obj);
        if (removed && this.getPropertyChangeSupport() != null) {
            this.firePropertyChange(obj, null, 2);
        }
        return removed;
    }

    public synchronized SortedSet subSet(Object fromElement, Object toElement) {
        FPropTreeSet subset = new FPropTreeSet(this.map.subMap(fromElement, toElement), null, null);
        subset.setOwner(this.getOwner());
        subset.setPropertyName(this.getPropertyName());
        return subset;
    }

    public synchronized SortedSet headSet(Object toElement) {
        FPropTreeSet subset = new FPropTreeSet(this.map.headMap(toElement), null, null);
        subset.setOwner(this.getOwner());
        subset.setPropertyName(this.getPropertyName());
        return subset;
    }

    public synchronized SortedSet tailSet(Object fromElement) {
        FPropTreeSet subset = new FPropTreeSet(this.map.tailMap(fromElement), null, null);
        subset.setOwner(this.getOwner());
        subset.setPropertyName(this.getPropertyName());
        return subset;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.owner == null ? null : this.owner.getPropertyChangeSupport();
    }

    public void setOwner(PropertyChangeInterface owner) {
        this.owner = owner;
    }

    public PropertyChangeInterface getOwner() {
        return this.owner;
    }

    public void setPropertyName(String name) {
        this.propertyName = name;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    protected void firePropertyChange(Object oldValue, Object newValue, int type) {
        PropertyChangeSupport propertyChangeSupport = this.getPropertyChangeSupport();
        if (propertyChangeSupport != null) {
            propertyChangeSupport.firePropertyChange(CollectionChangeEvent.get(this.owner, this.propertyName, this, oldValue, newValue, type));
        }
    }
}

