/*
 * Decompiled with CFR 0.152.
 */
package de.upb.tools.fca;

import de.upb.tools.fca.FEmptyIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class FTreeMap
extends AbstractMap
implements SortedMap,
Cloneable,
Serializable {
    private Comparator comparator = null;
    transient Node rootNode = null;
    private transient int size = 0;
    transient int clearCount = 0;
    private static final transient boolean RED = true;
    private static final transient boolean BLACK = false;
    private transient KeySet keySet = null;
    private transient Collection valueCollection = null;
    private transient Set entrySet = null;
    private int maxDepth;
    StringBuffer[] lines = null;

    public FTreeMap() {
    }

    public FTreeMap(Comparator comp) {
        this.comparator = comp;
    }

    public FTreeMap(Map map) {
        this.putAll(map);
    }

    public FTreeMap(SortedMap map) {
        this.comparator = map.comparator();
        try {
            this.buildFromSorted(map.size(), map.entrySet().iterator(), null, null);
        }
        catch (IOException cannotHappen) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator iter = this.entrySet().iterator();
        buf.append("FTreeMap(");
        buf.append(this.size());
        buf.append(")[");
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(",");
        }
        buf.append("]");
        return new String(buf);
    }

    public synchronized Object clone() {
        return new FTreeMap(this);
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        return this.rootNode == null;
    }

    public synchronized boolean containsKey(Object key) {
        return this.getNode(key) != null;
    }

    public synchronized boolean containsValue(Object value) {
        if (this.rootNode != null) {
            Node xNode = FTreeMap.treeMinimum(this.rootNode);
            while (xNode != null) {
                if (FTreeMap.valEquals(value, xNode.getValue())) {
                    return true;
                }
                xNode = FTreeMap.treeSuccessor(xNode);
            }
        }
        return false;
    }

    public synchronized Object get(Object key) {
        Node node = this.getNode(key);
        return node == null ? null : node.getValue();
    }

    public synchronized Object put(Object key, Object value) {
        return this.insertKeyValue(key, value);
    }

    public synchronized void removeValue(Object value) {
        Iterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Object entryValue = entry.getValue();
            if ((value != null || entryValue != null) && (value == null || !value.equals(entryValue))) continue;
            this.deleteNode((Node)entry);
        }
    }

    public synchronized Object remove(Object key) {
        Node node = this.getNode(key);
        if (node == null) {
            return null;
        }
        this.deleteNode(node);
        return node.getValue();
    }

    public synchronized void putAll(Map map) {
        Comparator myComp;
        Comparator mapComp;
        int mapSize = map.size();
        if (this.size == 0 && mapSize != 0 && map instanceof SortedMap && ((mapComp = ((SortedMap)map).comparator()) == (myComp = this.comparator()) || mapComp != null && ((Object)mapComp).equals(myComp))) {
            try {
                this.buildFromSorted(mapSize, map.entrySet().iterator(), null, null);
            }
            catch (IOException cannotHappen) {
            }
            catch (ClassNotFoundException cannotHappen) {
                // empty catch block
            }
            return;
        }
        super.putAll(map);
    }

    public synchronized void clear() {
        this.size = 0;
        ++this.clearCount;
        this.rootNode = null;
    }

    public synchronized Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public synchronized Collection values() {
        if (this.valueCollection == null) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    public synchronized Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public synchronized Comparator comparator() {
        return this.comparator;
    }

    public synchronized SortedMap subMap(Object fromKey, Object toKey) {
        return new SubMap(fromKey, toKey);
    }

    public synchronized SortedMap headMap(Object toKey) {
        return new SubMap(toKey, true);
    }

    public synchronized SortedMap tailMap(Object fromKey) {
        return new SubMap(fromKey, false);
    }

    public synchronized Object firstKey() {
        if (this.rootNode == null) {
            throw new NoSuchElementException();
        }
        return FTreeMap.key(FTreeMap.treeMinimum(this.rootNode));
    }

    public synchronized Object lastKey() {
        if (this.rootNode == null) {
            throw new NoSuchElementException();
        }
        return FTreeMap.key(FTreeMap.treeMaximum(this.rootNode));
    }

    final Node getNode(Object key) {
        Node xNode = this.rootNode;
        while (xNode != null) {
            int cmp = this.compare(key, xNode.getKey());
            if (cmp < 0) {
                xNode = xNode.left;
                continue;
            }
            if (cmp > 0) {
                xNode = xNode.right;
                continue;
            }
            return xNode;
        }
        return null;
    }

    static final Node treeSuccessor(Node node) {
        Node xNode = node;
        if (xNode.right != null) {
            xNode = xNode.right;
            while (xNode.left != null) {
                xNode = xNode.left;
            }
            return xNode;
        }
        Node yNode = xNode.parent;
        while (yNode != null && xNode == yNode.right) {
            xNode = yNode;
            yNode = yNode.parent;
        }
        return yNode;
    }

    static final Node treeMinimum(Node node) {
        Node xNode = node;
        while (xNode.left != null) {
            xNode = xNode.left;
        }
        return xNode;
    }

    final Node getPrecedingNode(Object key) {
        Node xNode = this.rootNode;
        if (xNode == null) {
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, xNode.getKey())) > 0) {
                if (xNode.right != null) {
                    xNode = xNode.right;
                    continue;
                }
                return xNode;
            }
            if (xNode.left == null) break;
            xNode = xNode.left;
        }
        Node parent = xNode.parent;
        Node yNode = xNode;
        while (parent != null && yNode == parent.left) {
            yNode = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private static final Node treeMaximum(Node node) {
        Node xNode = node;
        while (xNode.right != null) {
            xNode = xNode.right;
        }
        return xNode;
    }

    Node getCeilNode(Object key) {
        Node xNode = this.rootNode;
        if (xNode == null) {
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, xNode.getKey())) == 0) {
                return xNode;
            }
            if (cmp < 0) {
                if (xNode.left != null) {
                    xNode = xNode.left;
                    continue;
                }
                return xNode;
            }
            if (xNode.right == null) break;
            xNode = xNode.right;
        }
        Node parent = xNode.parent;
        Node yNode = xNode;
        while (parent != null && yNode == parent.right) {
            yNode = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private final void leftRotate(Node node) {
        Node rightChild = node.right;
        node.right = rightChild.left;
        if (rightChild.left != null) {
            rightChild.left.parent = node;
        }
        rightChild.parent = node.parent;
        if (node.parent == null) {
            this.rootNode = rightChild;
        } else if (node == node.parent.left) {
            node.parent.left = rightChild;
        } else {
            node.parent.right = rightChild;
        }
        rightChild.left = node;
        node.parent = rightChild;
    }

    private final void rightRotate(Node node) {
        Node leftChild = node.left;
        node.left = leftChild.right;
        if (leftChild.right != null) {
            leftChild.right.parent = node;
        }
        leftChild.parent = node.parent;
        if (node.parent == null) {
            this.rootNode = leftChild;
        } else if (node == node.parent.right) {
            node.parent.right = leftChild;
        } else {
            node.parent.left = leftChild;
        }
        leftChild.right = node;
        node.parent = leftChild;
    }

    private final Object insertKeyValue(Object key, Object value) {
        Node yNode = null;
        Node xNode = this.rootNode;
        int cmp = 0;
        while (xNode != null) {
            yNode = xNode;
            cmp = this.compare(key, xNode.getKey());
            if (cmp < 0) {
                xNode = xNode.left;
                continue;
            }
            if (cmp <= 0) break;
            xNode = xNode.right;
        }
        if (yNode == null) {
            ++this.size;
            this.rootNode = this.createNode(key, value, null);
            return null;
        }
        if (cmp < 0) {
            ++this.size;
            yNode.left = this.createNode(key, value, yNode);
            this.fixupAfterInsert(yNode.left);
            return null;
        }
        if (cmp > 0) {
            ++this.size;
            yNode.right = this.createNode(key, value, yNode);
            this.fixupAfterInsert(yNode.right);
            return null;
        }
        Object oldValue = yNode.getValue();
        yNode.setValue(value);
        return oldValue;
    }

    private final void fixupAfterInsert(Node xNode) {
        FTreeMap.setColor(xNode, true);
        while (xNode != null && xNode != this.rootNode && FTreeMap.colorOf(FTreeMap.parentOf(xNode))) {
            Node xParent;
            Node pNode;
            if (FTreeMap.parentOf(xNode) == FTreeMap.leftOf(FTreeMap.parentOf(FTreeMap.parentOf(xNode)))) {
                pNode = FTreeMap.rightOf(FTreeMap.parentOf(FTreeMap.parentOf(xNode)));
                if (FTreeMap.colorOf(pNode)) {
                    FTreeMap.setColor(FTreeMap.parentOf(xNode), false);
                    pNode.color = false;
                    FTreeMap.setColor(FTreeMap.parentOf(FTreeMap.parentOf(xNode)), true);
                    xNode = FTreeMap.parentOf(FTreeMap.parentOf(xNode));
                    continue;
                }
                if (xNode == FTreeMap.rightOf(FTreeMap.parentOf(xNode)) && (xNode = FTreeMap.parentOf(xNode)) != null) {
                    this.leftRotate(xNode);
                }
                FTreeMap.setColor(FTreeMap.parentOf(xNode), false);
                xParent = FTreeMap.parentOf(FTreeMap.parentOf(xNode));
                if (xParent == null) continue;
                xParent.color = true;
                this.rightRotate(xParent);
                continue;
            }
            pNode = FTreeMap.leftOf(FTreeMap.parentOf(FTreeMap.parentOf(xNode)));
            if (FTreeMap.colorOf(pNode)) {
                FTreeMap.setColor(FTreeMap.parentOf(xNode), false);
                pNode.color = false;
                FTreeMap.setColor(FTreeMap.parentOf(FTreeMap.parentOf(xNode)), true);
                xNode = FTreeMap.parentOf(FTreeMap.parentOf(xNode));
                continue;
            }
            if (xNode == FTreeMap.leftOf(FTreeMap.parentOf(xNode)) && (xNode = FTreeMap.parentOf(xNode)) != null) {
                this.rightRotate(xNode);
            }
            FTreeMap.setColor(FTreeMap.parentOf(xNode), false);
            xParent = FTreeMap.parentOf(FTreeMap.parentOf(xNode));
            if (xParent == null) continue;
            xParent.color = true;
            this.leftRotate(xParent);
        }
        FTreeMap.setColor(this.rootNode, false);
    }

    protected void deleteNode(Node zNode) {
        Node successor = FTreeMap.treeSuccessor(zNode);
        --this.size;
        Node yNode = zNode.left == null || zNode.right == null ? zNode : FTreeMap.treeSuccessor(zNode);
        boolean yColor = yNode.color;
        Node xNode = yNode.left != null ? yNode.left : yNode.right;
        if (xNode != null) {
            xNode.parent = yNode.parent;
        }
        if (yNode.parent == null) {
            this.rootNode = xNode;
        } else if (yNode.parent.left == yNode) {
            yNode.parent.left = xNode;
        } else {
            yNode.parent.right = xNode;
        }
        if (yNode != zNode) {
            yNode.left = zNode.left;
            if (zNode.left != null) {
                zNode.left.parent = yNode;
            }
            yNode.right = zNode.right;
            if (zNode.right != null) {
                zNode.right.parent = yNode;
            }
            yNode.parent = zNode.parent;
            if (zNode.parent == null) {
                this.rootNode = yNode;
            } else if (zNode.parent.left == zNode) {
                zNode.parent.left = yNode;
            } else {
                zNode.parent.right = yNode;
            }
            yNode.color = zNode.color;
        }
        if (!yColor) {
            this.fixupAfterDelete(xNode);
        }
        zNode.parent = zNode;
        zNode.left = zNode;
        zNode.right = successor;
    }

    private void fixupAfterDelete(Node xNode) {
        while (xNode != null && xNode != this.rootNode && !FTreeMap.colorOf(xNode)) {
            Node xParent;
            Node wNode;
            if (xNode == FTreeMap.leftOf(FTreeMap.parentOf(xNode))) {
                wNode = FTreeMap.rightOf(FTreeMap.parentOf(xNode));
                if (FTreeMap.colorOf(wNode)) {
                    wNode.color = false;
                    xParent = FTreeMap.parentOf(xNode);
                    if (xParent != null) {
                        xParent.color = true;
                        this.leftRotate(xParent);
                    }
                    wNode = FTreeMap.rightOf(FTreeMap.parentOf(xNode));
                }
                if (!FTreeMap.colorOf(FTreeMap.leftOf(wNode)) && !FTreeMap.colorOf(FTreeMap.rightOf(wNode))) {
                    FTreeMap.setColor(wNode, true);
                    xNode = FTreeMap.parentOf(xNode);
                    continue;
                }
                if (!FTreeMap.colorOf(FTreeMap.rightOf(wNode))) {
                    FTreeMap.setColor(FTreeMap.leftOf(wNode), false);
                    FTreeMap.setColor(wNode, true);
                    if (wNode != null) {
                        this.rightRotate(wNode);
                    }
                    wNode = FTreeMap.rightOf(FTreeMap.parentOf(xNode));
                }
                FTreeMap.setColor(FTreeMap.rightOf(wNode), false);
                xParent = FTreeMap.parentOf(xNode);
                if (xParent != null) {
                    FTreeMap.setColor(wNode, xParent.color);
                    xParent.color = false;
                    this.leftRotate(xParent);
                } else {
                    FTreeMap.setColor(wNode, false);
                }
                xNode = this.rootNode;
                continue;
            }
            wNode = FTreeMap.leftOf(FTreeMap.parentOf(xNode));
            if (FTreeMap.colorOf(wNode)) {
                wNode.color = false;
                xParent = FTreeMap.parentOf(xNode);
                if (xParent != null) {
                    xParent.color = true;
                    this.rightRotate(xParent);
                }
                wNode = FTreeMap.leftOf(FTreeMap.parentOf(xNode));
            }
            if (!FTreeMap.colorOf(FTreeMap.rightOf(wNode)) && !FTreeMap.colorOf(FTreeMap.leftOf(wNode))) {
                FTreeMap.setColor(wNode, true);
                xNode = FTreeMap.parentOf(xNode);
                continue;
            }
            if (!FTreeMap.colorOf(FTreeMap.leftOf(wNode))) {
                FTreeMap.setColor(FTreeMap.rightOf(wNode), false);
                FTreeMap.setColor(wNode, true);
                if (wNode != null) {
                    this.leftRotate(wNode);
                }
                wNode = FTreeMap.leftOf(FTreeMap.parentOf(xNode));
            }
            FTreeMap.setColor(FTreeMap.leftOf(wNode), false);
            xParent = FTreeMap.parentOf(xNode);
            if (xParent != null) {
                FTreeMap.setColor(wNode, xParent.color);
                xParent.color = false;
                this.rightRotate(xParent);
            } else {
                FTreeMap.setColor(wNode, false);
            }
            xNode = this.rootNode;
        }
        FTreeMap.setColor(xNode, false);
    }

    protected Node createNode(Object key, Object value, Node parent) {
        return new Node(key, value, parent);
    }

    private static final Node parentOf(Node node) {
        return node == null ? null : node.parent;
    }

    private static final Node leftOf(Node node) {
        return node == null ? null : node.left;
    }

    private static final Node rightOf(Node node) {
        return node == null ? null : node.right;
    }

    private static final boolean colorOf(Node node) {
        return node == null ? false : node.color;
    }

    private static final void setColor(Node node, boolean color) {
        if (node != null) {
            node.color = color;
        }
    }

    static final Object key(Node node) {
        return node == null ? null : node.getKey();
    }

    static final boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    final int compare(Object key1, Object key2) {
        if (this.comparator == null) {
            if (key1 == null) {
                if (key2 == null) {
                    return 0;
                }
                return -1;
            }
            return ((Comparable)key1).compareTo(key2);
        }
        return this.comparator.compare(key1, key2);
    }

    public synchronized void readTreeSet(int size, ObjectInputStream s, Object defaultVal) throws IOException, ClassNotFoundException {
        this.buildFromSorted(size, null, s, defaultVal);
    }

    public synchronized void addAllForTreeSet(SortedSet set, Object defaultVal) {
        try {
            this.buildFromSorted(set.size(), set.iterator(), null, defaultVal);
        }
        catch (IOException cannotHappen) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private synchronized void buildFromSorted(int size, Iterator iter, ObjectInputStream in, Object defaultVal) throws IOException, ClassNotFoundException {
        this.size = size;
        this.rootNode = this.buildFromSorted(0, 0, size - 1, FTreeMap.computeRedLevel(size), iter, in, defaultVal);
    }

    private Node buildFromSorted(int level, int lo, int hi, int redLevel, Iterator iter, ObjectInputStream in, Object defaultVal) throws IOException, ClassNotFoundException {
        Object value;
        Object key;
        if (hi < lo) {
            return null;
        }
        int mid = (lo + hi) / 2;
        Node leftNode = null;
        if (lo < mid) {
            leftNode = this.buildFromSorted(level + 1, lo, mid - 1, redLevel, iter, in, defaultVal);
        }
        if (iter != null) {
            if (defaultVal == null) {
                Map.Entry entry = (Map.Entry)iter.next();
                key = entry.getKey();
                value = entry.getValue();
            } else {
                key = iter.next();
                value = defaultVal;
            }
        } else {
            key = in.readObject();
            value = defaultVal != null ? defaultVal : in.readObject();
        }
        Node middleNode = this.createNode(key, value, null);
        if (level == redLevel) {
            middleNode.color = true;
        }
        if (leftNode != null) {
            middleNode.left = leftNode;
            leftNode.parent = middleNode;
        }
        if (mid < hi) {
            Node rightNode;
            middleNode.right = rightNode = this.buildFromSorted(level + 1, mid + 1, hi, redLevel, iter, in, defaultVal);
            rightNode.parent = middleNode;
        }
        return middleNode;
    }

    private static int computeRedLevel(int sz) {
        int level = 0;
        int m = sz - 1;
        while (m >= 0) {
            ++level;
            m = m / 2 - 1;
        }
        return level;
    }

    private int maxDepth(Node node) {
        int leftDepth = 1;
        if (node.left != null) {
            leftDepth = this.maxDepth(node.left) + 1;
        }
        int rightDepth = 1;
        if (node.right != null) {
            rightDepth = this.maxDepth(node.right) + 1;
        }
        return leftDepth > rightDepth ? leftDepth : rightDepth;
    }

    public void treePrint() {
        this.nodeTreePrint(this.rootNode);
    }

    private void nodeTreePrint(Node node) {
        if (node != null) {
            int i;
            this.maxDepth = this.maxDepth(node);
            this.lines = new StringBuffer[100];
            for (i = 0; i < this.lines.length; ++i) {
                this.lines[i] = new StringBuffer();
            }
            this._fillLevels(node, null, 0);
            for (i = 0; i < this.lines.length && this.lines[i].length() != 0; ++i) {
                System.out.println(this.lines[i]);
            }
        }
    }

    private void _fillLevels(Node current, Node caller, int level) {
        if (level < this.maxDepth) {
            int i;
            int indent = 2 << this.maxDepth - level - 1;
            int indentLR = indent / 2;
            this._fillLevels(current == null ? null : current.left, current, level + 1);
            this._fillLevels(current == null ? null : current.right, current, level + 1);
            if (this.lines[level].length() == 0) {
                for (i = 0; i < indent / 2; ++i) {
                    this.lines[level].append(" ");
                }
            } else {
                for (i = 0; i < indent - 1; ++i) {
                    this.lines[level].append(" ");
                }
            }
            if (current != null && current.left != null) {
                this.lines[level].append("|");
                for (i = 0; i < indentLR - 1; ++i) {
                    this.lines[level].append("-");
                }
            } else {
                for (i = 0; i < indentLR; ++i) {
                    this.lines[level].append(" ");
                }
            }
            this.lines[level].append(current == null ? " " : current.getKey());
            if (current != null && current.right != null) {
                for (i = 0; i < indentLR - 1; ++i) {
                    this.lines[level].append("-");
                }
                this.lines[level].append("|");
            } else {
                for (i = 0; i < indentLR; ++i) {
                    this.lines[level].append(" ");
                }
            }
        }
    }

    static class Node
    implements Map.Entry {
        Node parent;
        Node left = null;
        Node right = null;
        private Object key;
        private Object value;
        boolean color;

        public Node(Object key, Object value, Node parent) {
            this.key = key;
            this.value = value;
            this.parent = parent;
        }

        public Object clone() {
            return new Node(this.key, this.value, this.parent);
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return FTreeMap.valEquals(this.key, entry.getKey()) && FTreeMap.valEquals(this.value, entry.getValue());
        }

        public int hashCode() {
            int keyHash = this.key == null ? 0 : this.key.hashCode();
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }

        public String toString() {
            return "(" + this.key + "=" + this.value + ")";
        }

        public Node getParent() {
            return this.parent;
        }
    }

    private class FTreeMapIterator
    extends FEmptyIterator {
        public static final int KEYS = 0;
        public static final int VALUES = 1;
        public static final int ENTRIES = 2;
        private int type;
        private int expectedClearCount;
        private Node currentNode;
        private Object firstExcluded;
        private boolean fetched;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FTreeMapIterator(int type) {
            this.expectedClearCount = FTreeMap.this.clearCount;
            FTreeMap fTreeMap = FTreeMap.this;
            synchronized (fTreeMap) {
                this.type = type;
                this.currentNode = FTreeMap.this.rootNode != null ? FTreeMap.treeMinimum(FTreeMap.this.rootNode) : null;
                this.firstExcluded = null;
                this.fetched = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FTreeMapIterator(Node first, Node firstExcluded) {
            this.expectedClearCount = FTreeMap.this.clearCount;
            FTreeMap fTreeMap = FTreeMap.this;
            synchronized (fTreeMap) {
                this.type = 2;
                this.currentNode = first;
                this.firstExcluded = firstExcluded;
                this.fetched = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            if (!this.fetched) {
                FTreeMap fTreeMap = FTreeMap.this;
                synchronized (fTreeMap) {
                    if (this.expectedClearCount != FTreeMap.this.clearCount) {
                        this.currentNode = null;
                    } else if (this.currentNode != null) {
                        if (this.currentNode.parent != this.currentNode) {
                            this.currentNode = FTreeMap.treeSuccessor(this.currentNode);
                        } else {
                            Object oldkey = this.currentNode.getKey();
                            this.currentNode = FTreeMap.this.getCeilNode(oldkey);
                            if (this.currentNode != null && FTreeMap.this.compare(this.currentNode.getKey(), oldkey) == 0) {
                                this.currentNode = FTreeMap.treeSuccessor(this.currentNode);
                            }
                        }
                    }
                }
                this.fetched = true;
            }
            return this.currentNode != this.firstExcluded;
        }

        public Object next() {
            if (!this.fetched) {
                this.hasNext();
            }
            if (this.currentNode == this.firstExcluded) {
                throw new NoSuchElementException();
            }
            this.fetched = false;
            if (this.type == 0) {
                return this.currentNode.getKey();
            }
            if (this.type == 1) {
                return this.currentNode.getValue();
            }
            return this.currentNode;
        }
    }

    private class SubMap
    extends AbstractMap
    implements SortedMap,
    Serializable {
        boolean fromStart = false;
        boolean toEnd = false;
        Object fromKey;
        Object toKey;
        private transient Set entrySet = null;

        SubMap(Object fromKey, Object toKey) {
            if (FTreeMap.this.compare(fromKey, toKey) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.fromKey = fromKey;
            this.toKey = toKey;
        }

        SubMap(Object key, boolean headMap) {
            if (headMap) {
                this.fromStart = true;
                this.toKey = key;
            } else {
                this.toEnd = true;
                this.fromKey = key;
            }
        }

        SubMap(boolean fromStart, Object fromKey, boolean toEnd, Object toKey) {
            this.fromStart = fromStart;
            this.fromKey = fromKey;
            this.toEnd = toEnd;
            this.toKey = toKey;
        }

        public synchronized boolean isEmpty() {
            return this.entrySet.isEmpty();
        }

        public synchronized boolean containsKey(Object key) {
            return this.inRange(key) && FTreeMap.this.containsKey(key);
        }

        public synchronized Object get(Object key) {
            if (!this.inRange(key)) {
                return null;
            }
            return FTreeMap.this.get(key);
        }

        public synchronized Object put(Object key, Object value) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
            return FTreeMap.this.put(key, value);
        }

        public synchronized Comparator comparator() {
            return FTreeMap.this.comparator();
        }

        public synchronized Object firstKey() {
            Node firstNode = this.fromStart ? FTreeMap.treeMinimum(FTreeMap.this.rootNode) : FTreeMap.this.getCeilNode(this.fromKey);
            return FTreeMap.key(firstNode);
        }

        public synchronized Object lastKey() {
            Node lastNode = this.toEnd ? FTreeMap.treeMinimum(FTreeMap.this.rootNode) : FTreeMap.this.getPrecedingNode(this.toKey);
            return FTreeMap.key(lastNode);
        }

        public synchronized Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new EntrySetView();
            }
            return this.entrySet;
        }

        public synchronized SortedMap subMap(Object fromKey, Object toKey) {
            if (!this.inRange(fromKey)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange2(toKey)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(fromKey, toKey);
        }

        public synchronized SortedMap headMap(Object toKey) {
            if (!this.inRange2(toKey)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(this.fromStart, this.fromKey, false, toKey);
        }

        public synchronized SortedMap tailMap(Object fromKey) {
            if (!this.inRange(fromKey)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new SubMap(false, fromKey, this.toEnd, this.toKey);
        }

        synchronized boolean inRange(Object key) {
            return !(!this.fromStart && FTreeMap.this.compare(key, this.fromKey) < 0 || !this.toEnd && FTreeMap.this.compare(key, this.toKey) >= 0);
        }

        private synchronized boolean inRange2(Object key) {
            return !(!this.fromStart && FTreeMap.this.compare(key, this.fromKey) < 0 || !this.toEnd && FTreeMap.this.compare(key, this.toKey) > 0);
        }

        private class EntrySetView
        extends AbstractSet {
            private EntrySetView() {
            }

            public synchronized int size() {
                int size = 0;
                Iterator iter = this.iterator();
                while (iter.hasNext()) {
                    ++size;
                    iter.next();
                }
                return size;
            }

            public synchronized boolean isEmpty() {
                return !this.iterator().hasNext();
            }

            public synchronized boolean contains(Object obj) {
                if (!(obj instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)obj;
                Object key = entry.getKey();
                if (!SubMap.this.inRange(key)) {
                    return false;
                }
                Node node = FTreeMap.this.getNode(key);
                return node != null && FTreeMap.valEquals(node.getValue(), entry.getValue());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized boolean remove(Object obj) {
                if (!(obj instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)obj;
                Object key = entry.getKey();
                if (!SubMap.this.inRange(key)) {
                    return false;
                }
                FTreeMap fTreeMap = FTreeMap.this;
                synchronized (fTreeMap) {
                    Node node = FTreeMap.this.getNode(key);
                    if (node != null && FTreeMap.valEquals(node.getValue(), entry.getValue())) {
                        FTreeMap.this.deleteNode(node);
                        return true;
                    }
                }
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized Iterator iterator() {
                FTreeMap fTreeMap = FTreeMap.this;
                synchronized (fTreeMap) {
                    Node fromNode = SubMap.this.fromStart ? FTreeMap.treeMinimum(((SubMap)SubMap.this).FTreeMap.this.rootNode) : FTreeMap.this.getCeilNode(SubMap.this.fromKey);
                    Node toNode = SubMap.this.toEnd ? null : FTreeMap.this.getCeilNode(SubMap.this.toKey);
                    return new FTreeMapIterator(fromNode, toNode);
                }
            }
        }
    }

    private class ValueCollection
    extends AbstractCollection {
        private ValueCollection() {
        }

        public synchronized Iterator iterator() {
            return new FTreeMapIterator(1);
        }

        public synchronized boolean contains(Object value) {
            Node xNode = FTreeMap.treeMinimum(FTreeMap.this.rootNode);
            while (xNode != null) {
                if (FTreeMap.valEquals(xNode.getValue(), value)) {
                    return true;
                }
                xNode = FTreeMap.treeSuccessor(xNode);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean remove(Object value) {
            FTreeMap fTreeMap = FTreeMap.this;
            synchronized (fTreeMap) {
                Node xNode = FTreeMap.treeMinimum(FTreeMap.this.rootNode);
                while (xNode != null) {
                    if (FTreeMap.valEquals(xNode.getValue(), value)) {
                        FTreeMap.this.deleteNode(xNode);
                        return true;
                    }
                    xNode = FTreeMap.treeSuccessor(xNode);
                }
            }
            return false;
        }

        public synchronized int size() {
            return FTreeMap.this.size();
        }

        public synchronized void clear() {
            FTreeMap.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public synchronized Iterator iterator() {
            return new FTreeMapIterator(2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Object value = entry.getValue();
            FTreeMap fTreeMap = FTreeMap.this;
            synchronized (fTreeMap) {
                Node node = FTreeMap.this.getNode(entry.getKey());
                return node != null && FTreeMap.valEquals(node.getValue(), value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Object value = entry.getValue();
            FTreeMap fTreeMap = FTreeMap.this;
            synchronized (fTreeMap) {
                Node node = FTreeMap.this.getNode(entry.getKey());
                if (node != null && FTreeMap.valEquals(node.getValue(), value)) {
                    FTreeMap.this.deleteNode(node);
                    return true;
                }
            }
            return false;
        }

        public synchronized int size() {
            return FTreeMap.this.size();
        }

        public synchronized void clear() {
            FTreeMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public synchronized Iterator iterator() {
            return new FTreeMapIterator(0);
        }

        public synchronized boolean contains(Object key) {
            return FTreeMap.this.containsKey(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean remove(Object key) {
            Node xNode = FTreeMap.this.getNode(key);
            if (xNode == null) {
                return false;
            }
            FTreeMap fTreeMap = FTreeMap.this;
            synchronized (fTreeMap) {
                FTreeMap.this.deleteNode(xNode);
            }
            return true;
        }

        public synchronized int size() {
            return FTreeMap.this.size();
        }

        public synchronized void clear() {
            FTreeMap.this.clear();
        }
    }
}

