/*
 * Decompiled with CFR 0.152.
 */
package de.upb.tools.sdm;

import de.upb.tools.fca.EnumerationForAnIterator;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FTreeSet;
import de.upb.tools.fca.StandardComparator;
import de.upb.tools.sdm.FState;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;

public class FComplexState
extends FState {
    public static final int HISTORY_NONE = 0;
    public static final int HISTORY_DEEP = 1;
    public static final int HISTORY_SHALLOW = 2;
    private int historyKind = 0;
    private FTreeSet subStates = new FTreeSet(StandardComparator.get());
    private FState historyState;
    private TreeSet initial;

    public FComplexState() {
    }

    public FComplexState(String name) {
        this.name = name;
    }

    public void setHistoryKind(int historyKind) {
        if (historyKind == 0 || historyKind == 1 || historyKind == 2) {
            this.historyKind = historyKind;
        }
    }

    public int getHistoryKind() {
        return this.historyKind;
    }

    public boolean hasHistory() {
        return this.historyKind == 1 || this.historyKind == 2;
    }

    public boolean hasInSubStates(FState elem) {
        return this.subStates.contains(elem);
    }

    public Enumeration elementsOfSubStates() {
        return new EnumerationForAnIterator(this.iteratorOfSubStates());
    }

    public Iterator iteratorOfSubStates() {
        return this.subStates.iterator();
    }

    public void addToSubStates(FState elem) {
        if (elem != null && !this.hasInSubStates(elem)) {
            this.subStates.add(elem);
            elem.setParent(this);
        }
    }

    public void removeFromSubStates(FState elem) {
        if (this.hasInSubStates(elem)) {
            this.subStates.remove(elem);
            elem.setParent(null);
        }
    }

    public void removeAllFromSubStates() {
        Iterator iter = this.iteratorOfSubStates();
        while (iter.hasNext()) {
            FState item = (FState)iter.next();
            iter.remove();
            item.setParent(null);
        }
    }

    public FState getHistoryState() {
        return this.historyState;
    }

    public void setHistoryState(FState historyState) {
        if (this.historyState != historyState) {
            if (this.historyState != null) {
                FState oldHistoryState = this.historyState;
                this.historyState = null;
                oldHistoryState.setRevHistoryState(null);
            }
            this.historyState = historyState;
            if (historyState != null) {
                historyState.setRevHistoryState(this);
            }
        }
    }

    public void addToInitial(FState elem) {
        if (elem != null && !this.hasInInitial(elem)) {
            if (this.initial == null) {
                this.initial = new TreeSet(new StandardComparator());
            }
            this.initial.add(elem);
            elem.setRevInitial(this);
        }
    }

    public boolean hasInInitial(FState elem) {
        if (this.initial == null) {
            return false;
        }
        return this.initial.contains(elem);
    }

    public Iterator iteratorOfInitial() {
        return this.initial == null ? FEmptyIterator.get() : this.initial.iterator();
    }

    public void removeFromInitial(FState elem) {
        if (this.hasInInitial(elem)) {
            this.initial.remove(elem);
            elem.setRevInitial(null);
        }
    }

    public int sizeOfInitial() {
        if (this.initial == null) {
            return 0;
        }
        return this.initial.size();
    }

    public FState getInitial() {
        return this.getFirstFromInitial();
    }

    public void setInitial(FState state) {
        this.removeAllFromInitial();
        this.addToInitial(state);
    }

    public FState getFirstFromInitial() {
        return this.initial.isEmpty() ? null : (FState)this.initial.first();
    }

    public void removeAllFromInitial() {
        Iterator iter = this.iteratorOfInitial();
        while (iter.hasNext()) {
            FState tmpFState = (FState)iter.next();
            iter.remove();
            tmpFState.setRevInitial(null);
        }
    }

    public void removeYou() {
        this.removeAllFromSubStates();
        this.setHistoryState(null);
        this.removeAllFromInitial();
        super.removeYou();
    }
}

