/*
 * Decompiled with CFR 0.152.
 */
package de.upb.tools.sdm;

import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import de.upb.tools.sdm.FAdjustObjectListener;
import de.upb.tools.sdm.FReactive;
import de.upb.tools.sdm.FReactiveManagerRemote;
import java.util.Iterator;
import java.util.LinkedList;

public class FReactiveManager {
    private static FReactiveManager myFReactiveManager = null;
    private FHashSet freactives;
    private LinkedList adjustObjectListeners;

    private FReactiveManager() {
        FReactiveManagerRemote.get(this);
    }

    public static FReactiveManager get() {
        if (myFReactiveManager == null) {
            myFReactiveManager = new FReactiveManager();
        }
        return myFReactiveManager;
    }

    public boolean hasInFreactives(FReactive value) {
        return this.freactives != null && value != null && this.freactives.contains(value);
    }

    public Iterator iteratorOfFreactives() {
        return this.freactives == null ? FEmptyIterator.get() : this.freactives.iterator();
    }

    public int sizeOfFreactives() {
        return this.freactives == null ? 0 : this.freactives.size();
    }

    public boolean addToFreactives(FReactive value) {
        boolean changed = false;
        if (value != null) {
            if (this.freactives == null) {
                this.freactives = new FHashSet();
            }
            if (changed = this.freactives.add(value)) {
                value.setManager(this);
            }
        }
        return changed;
    }

    public boolean removeFromFreactives(FReactive value) {
        boolean changed = false;
        if (this.freactives != null && value != null && (changed = this.freactives.remove(value))) {
            value.setManager(null);
        }
        return changed;
    }

    public void removeAllFromFreactives() {
        Iterator iter = this.iteratorOfFreactives();
        while (iter.hasNext()) {
            FReactive tmpValue = (FReactive)iter.next();
            this.removeFromFreactives(tmpValue);
        }
    }

    public void addToAdjustObjectListeners(FAdjustObjectListener value) {
        if (value != null && !this.hasInAdjustObjectListeners(value)) {
            if (this.adjustObjectListeners == null) {
                this.adjustObjectListeners = new LinkedList();
            }
            this.adjustObjectListeners.add(value);
        }
    }

    public boolean hasInAdjustObjectListeners(FAdjustObjectListener value) {
        if (this.adjustObjectListeners == null) {
            return false;
        }
        return this.adjustObjectListeners.contains(value);
    }

    public Iterator iteratorOfAdjustObjectListeners() {
        return this.adjustObjectListeners == null ? FEmptyIterator.get() : this.adjustObjectListeners.iterator();
    }

    public void removeFromAdjustObjectListeners(FAdjustObjectListener value) {
        if (this.hasInAdjustObjectListeners(value)) {
            this.adjustObjectListeners.remove(value);
        }
    }

    public int sizeOfAdjustObjectListeners() {
        if (this.adjustObjectListeners == null) {
            return 0;
        }
        return this.adjustObjectListeners.size();
    }

    public void removeAllFromAdjustObjectListeners() {
        Iterator iter = this.iteratorOfAdjustObjectListeners();
        while (iter.hasNext()) {
            FAdjustObjectListener tmpNotifier = (FAdjustObjectListener)iter.next();
            this.removeFromAdjustObjectListeners(tmpNotifier);
        }
    }

    public void removeYou() {
        this.removeAllFromFreactives();
        this.removeAllFromAdjustObjectListeners();
    }
}

