/*
 * Decompiled with CFR 0.152.
 */
package de.upb.tools.sdm;

import de.upb.tools.fca.FCollections;
import de.upb.tools.fca.FDuplicatedTreeMap;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.sdm.FComplexState;
import de.upb.tools.sdm.FEvent;
import de.upb.tools.sdm.FTransition;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FState {
    protected String name = "";
    private Method exitAction = null;
    private Method entryAction = null;
    private Method doAction = null;
    private int idOfAfterTransition = 0;
    private int idOfWhenTransition = 0;
    long timeoutForAfterEvent = 0L;
    long timeoutForWhenEvent = 0L;
    private Set deferredEvents = Collections.synchronizedSet(new HashSet());
    private transient FDuplicatedTreeMap transitions;
    private FComplexState parent;
    private FComplexState revHistoryState;
    private FComplexState revInitial;

    public FState() {
    }

    public FState(String name) {
        this();
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String setName(String name) {
        if (this.name == null || this.name != null && !this.name.equals(name)) {
            this.name = name;
        }
        return this.name;
    }

    public Method getExitAction() {
        return this.exitAction;
    }

    public Method setExitAction(Method exitAction) {
        if (this.exitAction == null || this.exitAction != null && !this.exitAction.equals(exitAction)) {
            this.exitAction = exitAction;
        }
        return this.exitAction;
    }

    public Method getEntryAction() {
        return this.entryAction;
    }

    public Method setEntryAction(Method entryAction) {
        if (this.entryAction == null || this.entryAction != null && !this.entryAction.equals(entryAction)) {
            this.entryAction = entryAction;
        }
        return this.entryAction;
    }

    public Method getDoAction() {
        return this.doAction;
    }

    public void setDoAction(Method v) {
        this.doAction = v;
    }

    public int getIdOfAfterTransition() {
        return this.idOfAfterTransition;
    }

    public void setIdOfAfterTransition(int v) {
        this.idOfAfterTransition = v;
    }

    public int getIdOfWhenTransition() {
        return this.idOfWhenTransition;
    }

    public void setIdOfWhenTransition(int v) {
        this.idOfWhenTransition = v;
    }

    public long getTimeoutForAfterEvent() {
        return this.timeoutForAfterEvent;
    }

    public void setTimeoutForAfterEvent(long v) {
        this.timeoutForAfterEvent = v;
    }

    public long getTimeoutForWhenEvent() {
        return this.timeoutForWhenEvent;
    }

    public void setTimeoutForWhenEvent(long v) {
        this.timeoutForWhenEvent = v;
    }

    public void addToDeferredEvents(String event) {
        if (event != null) {
            this.deferredEvents.add(event);
        }
    }

    public boolean hasInDeferredEvents(FEvent event) {
        return this.deferredEvents.contains(event.toString());
    }

    public boolean hasInDeferredEvents(String event) {
        return this.deferredEvents.contains(event);
    }

    public void removeFromDeferredEvents(String event) {
        this.deferredEvents.remove(event);
    }

    public void removeAllFromDeferredEvents() {
        this.deferredEvents.clear();
    }

    public Iterator iteratorOfDeferredEvents() {
        return this.deferredEvents.iterator();
    }

    public boolean hasInTransitions(FTransition obj) {
        return this.transitions != null && obj != null && obj.getName() != null && this.transitions.get(obj.getName()) == obj;
    }

    public boolean hasInTransitions(String key) {
        return this.transitions != null && key != null && this.transitions.containsKey(key);
    }

    public Iterator iteratorOfTransitions() {
        return this.transitions == null ? FEmptyIterator.get() : this.transitions.values().iterator();
    }

    public Iterator iteratorOfTransitions(String key) {
        return this.transitions == null ? FEmptyIterator.get() : FCollections.iterator(this.transitions.values(key));
    }

    public Iterator keysOfTransitions() {
        return this.transitions == null ? FEmptyIterator.get() : this.transitions.keySet().iterator();
    }

    public Iterator entriesOfTransitions() {
        return this.transitions == null ? FEmptyIterator.get() : this.transitions.entrySet().iterator();
    }

    public int sizeOfTransitions() {
        return this.transitions == null ? 0 : this.transitions.size();
    }

    public int sizeOfTransitions(String key) {
        return this.transitions == null ? 0 : this.transitions.size(key);
    }

    public boolean addToTransitions(FTransition obj) {
        boolean changed = false;
        if (obj != null && obj.getName() != null) {
            FTransition oldValue;
            if (this.transitions == null) {
                this.transitions = new FDuplicatedTreeMap();
            }
            if ((oldValue = (FTransition)this.transitions.put(obj.getName(), obj)) == null) {
                obj.setSourceState(this);
                changed = true;
            }
        }
        return changed;
    }

    public boolean removeFromTransitions(FTransition obj) {
        FTransition oldValue;
        boolean changed = false;
        if (this.transitions != null && obj != null && obj.getName() != null && (oldValue = (FTransition)this.transitions.remove(obj.getName(), obj)) != null) {
            oldValue.setSourceState(null);
            changed = true;
        }
        return changed;
    }

    public boolean removeKeyFromTransitions(String key) {
        Collection tmpCol;
        boolean changed = false;
        if (this.transitions != null && key != null && (tmpCol = (Collection)this.transitions.remove(key)) != null) {
            Iterator iter = tmpCol.iterator();
            while (iter.hasNext()) {
                FTransition tmpObj = (FTransition)iter.next();
                tmpObj.setSourceState(null);
            }
            changed = true;
        }
        return changed;
    }

    public void removeAllFromTransitions() {
        Iterator iter = this.iteratorOfTransitions();
        while (iter.hasNext()) {
            FTransition tmpObj = (FTransition)iter.next();
            this.removeFromTransitions(tmpObj);
        }
    }

    public FComplexState getParent() {
        return this.parent;
    }

    public void setParent(FComplexState parent) {
        if (this.parent != parent) {
            if (this.parent != null) {
                FComplexState oldParent = this.parent;
                this.parent = null;
                oldParent.removeFromSubStates(this);
            }
            this.parent = parent;
            if (parent != null) {
                parent.addToSubStates(this);
            }
        }
    }

    public FComplexState getRevHistoryState() {
        return this.revHistoryState;
    }

    public void setRevHistoryState(FComplexState revHistoryState) {
        if (this.revHistoryState != revHistoryState) {
            if (this.revHistoryState != null) {
                FComplexState oldRevHistoryState = this.revHistoryState;
                this.revHistoryState = null;
                oldRevHistoryState.setHistoryState(null);
            }
            this.revHistoryState = revHistoryState;
            if (revHistoryState != null) {
                revHistoryState.setHistoryState(this);
            }
        }
    }

    public void setRevInitial(FComplexState elem) {
        if (this.revInitial != elem) {
            if (this.revInitial != null) {
                FComplexState oldRevInitial = this.revInitial;
                this.revInitial = null;
                oldRevInitial.removeFromInitial(this);
            }
            this.revInitial = elem;
            if (elem != null) {
                elem.addToInitial(this);
            }
        }
    }

    public FComplexState getRevInitial() {
        return this.revInitial;
    }

    public int getDepth() {
        int depth = -1;
        FState parent = this;
        do {
            parent = parent.getParent();
            ++depth;
        } while (parent != null);
        return depth;
    }

    public boolean hasAsParent(FState state) {
        for (FState parent = this; parent != null; parent = parent.getParent()) {
            if (parent != state) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    public void removeYou() {
        Iterator iter = this.iteratorOfTransitions();
        while (iter.hasNext()) {
            FTransition tmpTransitions = (FTransition)iter.next();
            this.removeFromTransitions(tmpTransitions);
        }
        this.setParent(null);
        this.setRevInitial(null);
    }
}

