/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.ant;

import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLFile;
import de.uni_paderborn.fujaba.uml.UMLPackage;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLType;
import de.uni_paderborn.fujaba.uml.UMLTypeList;
import de.upb.tools.sdm.Path;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class AbstractRepairUMLProjectTask
extends Task {
    private static final transient Logger log;
    private static final String ALL_UMLCLASS = "rootPackage.packages*.declares";
    private String srcFileName = null;
    private String targetFileName = null;
    private UMLProject umlProject = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.ant.AbstractRepairUMLProjectTask");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public void execute() throws BuildException {
        this.validate();
        this.loadProject();
        this.repairProject();
        this.saveProject();
    }

    public void validate() {
        if (this.getSrcFileName() == null) {
            throw new BuildException("srcFileName is missing !");
        }
        if (this.getTargetFileName() == null) {
            throw new BuildException("targetFileName is missing !");
        }
        File srcFile = new File(this.getSrcFileName());
        if (!srcFile.exists()) {
            throw new BuildException("srcFileName: '" + srcFile.getAbsolutePath() + "' does not exist !");
        }
        File targetFile = new File(this.getTargetFileName());
        if (targetFile.exists()) {
            throw new BuildException("targetFileName: '" + targetFile.getAbsolutePath() + "' already exists !");
        }
    }

    public abstract void loadProject();

    public abstract void saveProject();

    public void repairProject() {
        this.repairUMLType();
        this.repairUMLFile();
        this.repairTypelist();
    }

    private void repairTypelist() {
        UMLTypeList typeList = this.umlProject.getTypeList();
        LinkedList<Map.Entry> theList = new LinkedList<Map.Entry>();
        Iterator iter = typeList.entriesOfTypes();
        while (iter.hasNext()) {
            Map.Entry element = (Map.Entry)iter.next();
            if (log.isInfoEnabled()) {
                log.info((Object)((Object)((Object)this) + ".analyze key='" + element.getKey() + "' value='" + element.getValue() + "'"));
            }
            theList.add(element);
        }
        iter = theList.iterator();
        while (iter.hasNext()) {
            String name;
            Map.Entry tmpEntry = (Map.Entry)iter.next();
            String typeName = (String)tmpEntry.getKey();
            UMLType tmpType = (UMLType)tmpEntry.getValue();
            String string = name = tmpType instanceof UMLClass ? ((UMLClass)tmpType).getFullClassName() : tmpType.getName();
            if (log.isInfoEnabled()) {
                log.info((Object)((Object)((Object)this) + ".updateing type " + name));
            }
            typeList.removeKeyFromTypes(typeName);
            typeList.addToTypes(tmpType);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)((Object)((Object)this) + ".finished()"));
        }
    }

    private void repairUMLFile() {
        UMLFile element;
        LinkedList<UMLFile> toBeRemoved = new LinkedList<UMLFile>();
        Iterator iter = this.umlProject.iteratorOfFiles();
        while (iter.hasNext()) {
            element = (UMLFile)iter.next();
            if (log.isInfoEnabled()) {
                log.info((Object)((Object)((Object)this) + ".analyzing " + element));
            }
            if (element.sizeOfContains() != 0) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)((Object)((Object)this) + ".--> must remove " + element));
            }
            if (toBeRemoved.contains(element)) continue;
            toBeRemoved.add(element);
        }
        iter = toBeRemoved.iterator();
        while (iter.hasNext()) {
            element = (UMLFile)iter.next();
            if (log.isInfoEnabled()) {
                log.info((Object)((Object)((Object)this) + ".removing " + element + ",fujabaId=" + element.getID() + ",hashCode=" + element.hashCode()));
            }
            element.removeYou();
        }
    }

    private void repairUMLType() {
        LinkedList toBeRemoved = new LinkedList();
        this.analyzeDeclaredClasses(toBeRemoved);
        this.analyzeTypes(toBeRemoved);
        this.analyzeFiles(toBeRemoved);
        this.removeClasses(toBeRemoved);
    }

    private void removeClasses(List toBeRemoved) {
        Iterator iter = toBeRemoved.iterator();
        while (iter.hasNext()) {
            UMLClass tmpClass = (UMLClass)iter.next();
            if (log.isInfoEnabled()) {
                log.info((Object)((Object)((Object)this) + ".removing " + tmpClass + ",fujabaId=" + tmpClass.getID() + ",hashCode=" + tmpClass.hashCode()));
            }
            Iterator declaresIter = tmpClass.iteratorOfDeclares();
            while (declaresIter.hasNext()) {
                UMLClass declaresClass = (UMLClass)declaresIter.next();
                if (declaresClass.getDeclaredInPackage() != null) continue;
                UMLPackage tmpPackage = tmpClass.getDeclaredInPackage();
                if (tmpPackage == null && (tmpPackage = this.umlProject.getRootPackage()) == null) {
                    throw new BuildException("rootPackage is null ! you have a problem ;-)");
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)((Object)((Object)this) + ".setting '" + declaresClass + "'.declaredInPackage = '" + tmpPackage + "'"));
                }
                declaresClass.setDeclaredInPackage(tmpPackage);
                UMLFile tmpFile = declaresClass.getFile();
                if (tmpFile != null) continue;
                tmpFile = new UMLFile();
                tmpFile.addToContains(declaresClass);
                tmpFile.setProject(this.umlProject);
                tmpFile.setName(declaresClass.getName());
            }
            tmpClass.removeYou();
        }
    }

    private void analyzeFiles(List toBeRemoved) {
        Path pathToUMLClass = new Path(this.umlProject, "files.contains");
        this.analyzePath(toBeRemoved, pathToUMLClass);
    }

    private void analyzeTypes(List toBeRemoved) {
        Iterator iter = this.umlProject.getTypeList().iteratorOfTypes();
        while (iter.hasNext()) {
            UMLType tmpType = (UMLType)iter.next();
            if (log.isInfoEnabled()) {
                log.info((Object)((Object)((Object)this) + ".analyzing '" + tmpType + "'"));
            }
            if (!(tmpType instanceof UMLClass) || !this.isPhantomClass((UMLClass)tmpType)) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)((Object)((Object)this) + ".--> must remove " + tmpType));
            }
            this.addToBeRemoved(toBeRemoved, tmpType);
        }
    }

    private void addToBeRemoved(List toBeRemoved, UMLType tmpType) {
        if (!toBeRemoved.contains(tmpType)) {
            toBeRemoved.add(tmpType);
        }
    }

    private void analyzeDeclaredClasses(List toBeRemoved) {
        Path pathToUMLClass = new Path(this.umlProject, ALL_UMLCLASS);
        this.analyzePath(toBeRemoved, pathToUMLClass);
    }

    private void analyzePath(List toBeRemoved, Path pathToUMLClass) {
        while (pathToUMLClass.hasMoreElements()) {
            UMLClass tmpClass = (UMLClass)pathToUMLClass.nextElement();
            if (log.isInfoEnabled()) {
                log.info((Object)((Object)((Object)this) + ".analyzing '" + tmpClass + "'"));
            }
            if (!this.isPhantomClass(tmpClass)) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)((Object)((Object)this) + ".--> must remove " + tmpClass));
            }
            this.addToBeRemoved(toBeRemoved, tmpClass);
        }
    }

    private boolean isPhantomClass(UMLClass tmpClass) {
        if (log.isInfoEnabled()) {
            log.info((Object)((Object)((Object)this) + ".isPhantomClass(" + tmpClass + ")"));
            if (tmpClass.getDeclaredInClass() != null) {
                log.info((Object)((Object)((Object)this) + ".class '" + tmpClass + "' declared in class '" + tmpClass.getDeclaredInClass() + "'"));
                log.info((Object)((Object)((Object)this) + ".class '" + tmpClass + "' declared in package '" + tmpClass.getDeclaredInPackage() + "'"));
            }
        }
        if (!tmpClass.getName().startsWith("_@id")) {
            return false;
        }
        if (tmpClass.sizeOfAttrs() + tmpClass.sizeOfMethods() + tmpClass.sizeOfRoles() + tmpClass.sizeOfSignals() > 0) {
            return false;
        }
        if (tmpClass.sizeOfRevAttrType() + tmpClass.sizeOfRevParamType() + tmpClass.sizeOfRevResultType() > 0) {
            return false;
        }
        return tmpClass.getSuperClass() == null;
    }

    public String getSrcFileName() {
        return this.srcFileName;
    }

    public void setSrcFileName(String srcFileName) {
        if (this.srcFileName != srcFileName) {
            this.srcFileName = srcFileName;
        }
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public void setTargetFileName(String targetFileName) {
        if (this.targetFileName != targetFileName) {
            this.targetFileName = targetFileName;
        }
    }

    public UMLProject getUmlProject() {
        return this.umlProject;
    }

    public void setUmlProject(UMLProject umlProject) {
        if (this.umlProject != umlProject) {
            this.umlProject = umlProject;
        }
    }
}

