/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.app;

import de.uni_paderborn.fujaba.app.ScrollPanel;
import de.uni_paderborn.fujaba.app.Version;
import de.uni_paderborn.fujaba.fsa.swing.JEgg;
import de.uni_paderborn.lib.basic.ImageResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class AboutBox
extends JDialog {
    public AboutBox(JFrame parent, boolean splashscreen) {
        super((Frame)parent, "About Fujaba Tool Suite");
        this.setUndecorated(splashscreen);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        ImageIcon image = this.createImage();
        JLabel label = new JLabel(image);
        contentPane.add((Component)label, "Center");
        if (!splashscreen) {
            contentPane.add((Component)new ScrollPanel(image.getIconWidth(), 150, 40, "de/uni_paderborn/fujaba/app/fujaba.who"), "South");
            label.addMouseListener(new JEgg.EggMouseListener());
        }
        this.pack();
        this.centerDialog();
    }

    private ImageIcon createImage() {
        ImageIcon image = ImageResourceManager.get().getImageIcon("fujaba.core", "de/uni_paderborn/fujaba/app/images/Splashscreen.gif");
        String versionText = "Version " + Version.get().toString();
        int width = image.getIconWidth();
        int height = image.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics2D graphics = bufferedImage.createGraphics();
        graphics.drawImage(image.getImage(), 0, 0, null);
        graphics.setColor(Color.black);
        Font font = graphics.getFont();
        Rectangle2D rectangle = font.getStringBounds(versionText, graphics.getFontRenderContext());
        float stringWidth = new Double(rectangle.getWidth()).floatValue();
        float stringHeight = new Double(rectangle.getHeight()).floatValue();
        graphics.drawString(versionText, (float)width - stringWidth - 20.0f, (float)height - stringHeight - 3.0f);
        return new ImageIcon(bufferedImage);
    }

    private void centerDialog() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getSize();
        this.setLocation(screenSize.width / 2 - size.width / 2, screenSize.height / 2 - size.height / 2);
    }
}

