/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.app;

import de.tu_bs.coobra.LocalRepository;
import de.uni_kassel.prop.JPropertyTable;
import de.uni_kassel.prop.ObjectInspector;
import de.uni_kassel.prop.PropertyConfiguration;
import de.uni_kassel.prop.PropertyConfigurationAdapter;
import de.uni_paderborn.fujaba.app.FrameDecorator;
import de.uni_paderborn.fujaba.app.FujabaApp;
import de.uni_paderborn.fujaba.app.InternalFrame;
import de.uni_paderborn.fujaba.app.TabProxy;
import de.uni_paderborn.fujaba.app.TabbedPaneProxy;
import de.uni_paderborn.fujaba.app.action.AppCloser;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.asg.ASGUnparseInformation;
import de.uni_paderborn.fujaba.basic.FileHistory;
import de.uni_paderborn.fujaba.basic.RuntimeExceptionWithContext;
import de.uni_paderborn.fujaba.basic.SchemaFilter;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.uni_paderborn.fujaba.coobra.actions.RestoreAction;
import de.uni_paderborn.fujaba.coobra.actions.ShowPropertyEditorAction;
import de.uni_paderborn.fujaba.fsa.FSAContainer;
import de.uni_paderborn.fujaba.fsa.FSALayeredPane;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.PopupSourceListener;
import de.uni_paderborn.fujaba.fsa.SelectionManager;
import de.uni_paderborn.fujaba.fsa.swing.JDiagramRootPane;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.unparse.UnparseManager;
import de.uni_paderborn.fujaba.gui.EditModeFactory;
import de.uni_paderborn.fujaba.gui.mdi.DesktopMenu;
import de.uni_paderborn.fujaba.gui.mdi.DesktopTaskBar;
import de.uni_paderborn.fujaba.messages.ErrorMessage;
import de.uni_paderborn.fujaba.messages.Message;
import de.uni_paderborn.fujaba.messages.MessageView;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.packagediagrams.gui.FrameDecoratorPackageDiagram;
import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import de.uni_paderborn.fujaba.preferences.PlugInsPreferences;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStereotypeManager;
import de.uni_paderborn.fujaba.uml.gui.FrameDecoratorUMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.gui.FrameDecoratorUMLClassDiagram;
import de.uni_paderborn.fujaba.uml.gui.FrameDecoratorUMLStatechart;
import de.uni_paderborn.lib.basic.ImageResourceManager;
import de.upb.lib.plugins.PluginManager;
import de.upb.lib.userinterface.ActionExecutionListenerEx;
import de.upb.lib.userinterface.UserInterfaceManager;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;
import de.upb.tools.fca.FHashSet;
import de.upb.tools.fca.FLinkedList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class FrameMain
extends JFrame {
    static final transient Logger log;
    private FHashMap scrollBarPositions = new FHashMap();
    JLabel statusLabel;
    private JLabel memoryLabel;
    private JSplitPane splitpane;
    private UMLProject umlProject;
    private JFileChooser fileChooser;
    public static final File PLUGIN_DIR;
    private JSplitPane leftSplitPane;
    private JPropertyTable propertyEditor;
    private JPanel propertyEditorContainer;
    JLabel propertyEditorCaption;
    private JPanel messagePanel;
    private MessageView messageView = new MessageView("Messages");
    private JSplitPane splitMessagesAndDesktop;
    private static final int MAX_DISPLAYED_STATUS_MESSAGES = 10;
    public static final String MESSAGE_CLASS_STATUS = "Status";
    private EditModeFactory editModeFactory;
    private static volatile FrameMain frame;
    private SchemaFilter filterFujabaProject = new SchemaFilter(".fpr", "Fujaba Project Files");
    private SchemaFilter filterJavaFiles = new SchemaFilter(".java", "Java Source Files (*.java)");
    private SchemaFilter filterJarFiles = new SchemaFilter(".jar", "Java Archives (*.jar)");
    JDesktopPane desktop = new JDesktopPane();
    private static PropertyConfigurationAdapter propertyConfiguration;
    public static Dimension DEFAULT_INTERNAL_FRAME_SIZE;
    private boolean inShowDiagram;
    Map frames;
    private final InternalFrame frameDummy = new InternalFrame(null, this);
    private TabbedPaneProxy tabbedPaneProxy;
    private FHashSet decorators;
    private FLinkedList displayedStatusMessages = new FLinkedList();
    private AbstractAction saveAction;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.app.FrameMain");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        PLUGIN_DIR = new File((String)PlugInsPreferences.get().getPluginFolders().firstElement());
        DEFAULT_INTERNAL_FRAME_SIZE = new Dimension(400, 300);
        propertyConfiguration = new PropertyConfigurationAdapter(){

            public JPopupMenu getPopupMenu(Object object) {
                if (object instanceof FElement) {
                    if (object instanceof ASGElement) {
                        SelectionManager.get().setPopupSource(null, (ASGElement)object);
                    }
                    return UserInterfaceManager.get().getFromPopupMenus(object.getClass().getName(), object);
                }
                return null;
            }
        };
        ObjectInspector.get().setConfig((PropertyConfiguration)propertyConfiguration);
    }

    public EditModeFactory getEditMode() {
        return this.editModeFactory;
    }

    public void setEditMode(EditModeFactory editModeFactory) {
        this.editModeFactory = editModeFactory;
    }

    private FrameMain() {
        JOptionPane.setRootFrame(this);
        this.setTitle("Fujaba 4");
        this.setDefaultCloseOperation(0);
        this.setBackground(SystemColor.control);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.app.FrameMain");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        URL url = clazz.getResource("images/Fujaba.gif");
        Image icon = ImageResourceManager.get().getImage(url);
        this.setIconImage(icon);
        this.addWindowListener(new AppCloser());
        this.filterFujabaProject.addExtension(".cxr");
        this.filterFujabaProject.addExtension(".cxri");
        this.filterFujabaProject.addExtension(".cxr.gz");
        this.filterFujabaProject.addExtension(".xml");
        this.filterFujabaProject.addExtension(".xml.gz");
    }

    public static FrameMain get() {
        if (frame == null) {
            frame = new FrameMain();
        }
        return frame;
    }

    public MessageView getMessageView() {
        return this.messageView;
    }

    public void showMessageView() {
        if (this.splitMessagesAndDesktop.getDividerLocation() >= this.splitMessagesAndDesktop.getHeight() - 20) {
            this.splitMessagesAndDesktop.setDividerLocation(this.splitMessagesAndDesktop.getResizeWeight());
        }
    }

    public void hideMessageView() {
        this.splitMessagesAndDesktop.setDividerLocation(Integer.MAX_VALUE);
    }

    public void init() {
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        content.add((Component)mainPanel, "Center");
        this.umlProject = UMLProject.createPlainProject();
        this.umlProject.setGui(this);
        if (FujabaChangeManager.getVMRepository() != null) {
            FujabaChangeManager.getVMRepository().moveChangesIntoChangesBase();
        }
        PluginManager pluginManager = FujabaApp.getPluginManager();
        UserInterfaceManager uiManager = UserInterfaceManager.get();
        uiManager.addToDocuments("fujaba.core", "de/uni_paderborn/fujaba/app/CoreUserInterface.xml");
        uiManager.addToDocuments("fujaba.core", "de/uni_paderborn/fujaba/uml/gui/UMLUserInterface.xml");
        if (GeneralPreferences.get().isRepositoryActivated()) {
            uiManager.addToDocuments("fujaba.core", "de/uni_paderborn/fujaba/coobra/CoobraUserInterface.xml");
        }
        uiManager.addToDocuments("fujaba.core", "de/uni_paderborn/fujaba/packagediagrams/gui/PackageUserInterface.xml");
        pluginManager.scanPlugins(PlugInsPreferences.get().getPluginFolders());
        Vector toScan = this.getResourcesFromJars("fujabaPlugin.xml");
        toScan.addAll(this.getResourcesFromJars("plugin.xml"));
        pluginManager.scanPlugins(toScan);
        pluginManager.loadPlugins();
        uiManager.loadDocuments();
        if (!GeneralPreferences.get().isFPRActivated() && GeneralPreferences.get().isRepositoryActivated()) {
            uiManager.getFromActions("saveProject").putValue("visible", Boolean.FALSE);
            uiManager.getFromActions("saveProjectAs").putValue("visible", Boolean.FALSE);
            this.setSaveAction(UserInterfaceManager.get().getFromActions("coobra.store"));
        }
        uiManager.setEventSource(SelectionManager.get());
        this.setJMenuBar(uiManager.getFromMenuBars("mainMenuBar"));
        uiManager.initMenu(this.getJMenuBar(), (Object)this);
        FileHistory.get().updateActions();
        this.setTabbedPaneProxy(new TabbedPaneProxy());
        this.getTabbedPaneProxy().instanceOfTabProxy("UML");
        this.getTabbedPaneProxy().update();
        this.addToDecorators(new FrameDecoratorUMLClassDiagram());
        this.addToDecorators(new FrameDecoratorUMLActivityDiagram());
        this.addToDecorators(new FrameDecoratorUMLStatechart());
        this.addToDecorators(new FrameDecoratorPackageDiagram());
        this.leftSplitPane = new JSplitPane(0);
        this.leftSplitPane.setResizeWeight(0.7);
        this.leftSplitPane.setTopComponent(this.getTabbedPaneProxy().getTabbedPane());
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add((Component)this.desktop, "Center");
        JPanel rightBottomPanel = new JPanel(new BorderLayout());
        this.splitMessagesAndDesktop = new JSplitPane(0, rightPanel, rightBottomPanel);
        this.splitMessagesAndDesktop.setOneTouchExpandable(true);
        this.splitMessagesAndDesktop.setResizeWeight(0.8);
        this.hideMessageView();
        this.messagePanel = new JPanel(new BorderLayout());
        rightBottomPanel.add((Component)this.messagePanel, "Center");
        this.messagePanel.add((Component)this.messageView.getComponent(), "Center");
        this.splitpane = this.createSplitPane(this.leftSplitPane, this.splitMessagesAndDesktop);
        this.getJMenuBar().add(new DesktopMenu(this.desktop));
        rightPanel.add((Component)new DesktopTaskBar(this.desktop, true), "South");
        this.propertyEditor = new JPropertyTable(true, "FujabaPropertyTable");
        URL url = this.getClass().getClassLoader().getResource("de/uni_paderborn/fujaba/gui/propertyeditor.config");
        if (url != null) {
            try {
                propertyConfiguration.readConfig(url.openStream());
            }
            catch (IOException e) {
                log.error((Object)"error while reading propertyeditor.config", (Throwable)e);
            }
        } else {
            log.error((Object)"propertyeditor.config file not found");
        }
        JScrollPane scrollPE = new JScrollPane((Component)this.propertyEditor);
        this.propertyEditorContainer = new JPanel();
        this.propertyEditorContainer.setLayout(new BorderLayout());
        this.propertyEditorContainer.add((Component)scrollPE, "Center");
        this.propertyEditorCaption = new JLabel();
        this.propertyEditorContainer.add((Component)this.propertyEditorCaption, "North");
        this.showPropertyEditor(ShowPropertyEditorAction.isPropertyEditorActivated());
        SelectionManager.get().addToPopupSourceListeners(new PropertyEditorPopupSourceListener());
        JToolBar toolBar = UserInterfaceManager.get().getFromToolBars("mainToolBar");
        toolBar.setVisible(true);
        this.desktop.setBackground(toolBar.getBackground());
        mainPanel.add((Component)toolBar, "North");
        mainPanel.add((Component)this.splitpane, "Center");
        mainPanel.add((Component)this.createStatusbar(), "South");
        StatusBarUpdater statusBarUpdater = new StatusBarUpdater();
        statusBarUpdater.start();
        this.filterFujabaProject.addExtension(".fpr.gz");
        this.filterFujabaProject.addExtension(".bak.fpr");
        this.centerFrame();
        UMLProject.get().setSaved(true);
        this.subscribeActionErrorListener();
    }

    private Vector getResourcesFromJars(String resName) {
        Vector<String> res = new Vector<String>();
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.app.FrameMain");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Enumeration<URL> pluginXMLs = clazz.getClassLoader().getResources(resName);
            while (pluginXMLs.hasMoreElements()) {
                URL url = pluginXMLs.nextElement();
                String path = url.toExternalForm();
                if (path.startsWith("jar:")) {
                    int indexOfMark = path.lastIndexOf("!/");
                    if (indexOfMark < 0) {
                        indexOfMark = path.length();
                    }
                    path = path.substring("jar:".length(), indexOfMark);
                }
                if (!path.startsWith("file:")) continue;
                if ((path = URLDecoder.decode(path.substring("file:".length()), "UTF-8")).endsWith(resName)) {
                    path = path.substring(0, path.length() - resName.length());
                }
                res.add(path);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    private void subscribeActionErrorListener() {
        UserInterfaceManager.get().addExecutionListener(new ActionExecutionListenerEx(){

            public void preActionNotify(ActionEvent e) {
            }

            public void postActionNotify(ActionEvent e) {
            }

            public boolean postActionNotify(ActionEvent e, Throwable throwable) {
                throwable.printStackTrace();
                String text = throwable.getClass().getName().indexOf("RuntimeException") < 0 ? throwable.toString() : throwable.getMessage();
                ErrorMessage errorMessage = new ErrorMessage(text);
                if (throwable instanceof RuntimeExceptionWithContext) {
                    RuntimeExceptionWithContext ex = (RuntimeExceptionWithContext)throwable;
                    errorMessage.addToContext(ex.getContext());
                }
                FrameMain.this.getMessageView().addToMessages(errorMessage);
                FrameMain.this.showMessageView();
                errorMessage.showContext();
                return true;
            }
        });
    }

    public SchemaFilter getFilterFujabaProject() {
        return this.filterFujabaProject;
    }

    public SchemaFilter getFilterJavaFiles() {
        return this.filterJavaFiles;
    }

    public SchemaFilter getFilterJarFiles() {
        return this.filterJarFiles;
    }

    public JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            File dir = new File(GeneralPreferences.get().getWorkspaceFolder());
            if (dir.isDirectory()) {
                this.fileChooser.setCurrentDirectory(dir);
            } else {
                log.error((Object)("Workspace folder not found: " + GeneralPreferences.get().getWorkspaceFolder()));
            }
        }
        return this.fileChooser;
    }

    public JDesktopPane getDesktop() {
        return this.desktop;
    }

    public boolean isInShowDiagram() {
        return this.inShowDiagram;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void showDiagram(ASGDiagram diag) {
        if (this.inShowDiagram) return;
        this.inShowDiagram = true;
        try {
            InternalFrame diagFrame = diag != null ? this.getInternalFrame(diag) : null;
            ASGDiagram currentDiagram = UMLProject.get().getCurrentDiagram();
            if (diag != currentDiagram) {
                this.doEverythingOnExit(currentDiagram);
                SelectionManager.get().clear();
                UMLProject.get().setCurrentDiagram(diag);
                if (diag != null) {
                    if (diagFrame.getDiagramComponent() != diagFrame.getScrollerPanel()) {
                        diagFrame.setDiagramComponent(diagFrame.getScrollerPanel());
                    }
                    diagFrame.getScrollerPanel().setViewportView(diagFrame.getDiagramRootPane());
                    FSAContainer pane = (FSAContainer)UnparseManager.get().unparse(diag, diag.getFromFsaObjects("@__null.entry"));
                    SelectionManager.get().setSelected(diag.getFirstFromFSAObjects(), true);
                    if (pane != null && pane.getJComponent() != null) {
                        JDiagramRootPane rootPane = diagFrame.getDiagramRootPane();
                        rootPane.setContentPane(pane.getJComponent());
                        pane.getJComponent().setVisible(true);
                        rootPane.updateUI();
                    }
                    this.activateFrame(diagFrame);
                    this.doEverythingOnEntry(diag);
                }
                this.selectTreeItem(diag);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.inShowDiagram = false;
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.inShowDiagram = false;
            return;
        }
    }

    private void activateFrame(InternalFrame frame) {
        if (frame != null) {
            try {
                frame.setVisible(true);
                frame.setSelected(true);
                if (frame.isIcon()) {
                    frame.setMaximum(true);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public InternalFrame getInternalFrame(ASGDiagram diagram) {
        InternalFrame frame;
        if (diagram == null) {
            throw new NullPointerException("diagram cannot be null");
        }
        InternalFrame internalFrame = frame = this.frames != null ? (InternalFrame)this.frames.get(diagram) : null;
        if (frame == null) {
            InternalFrame newFrame;
            frame = newFrame = new InternalFrame(diagram, this);
            frame.setVisible(true);
            frame.setSize(DEFAULT_INTERNAL_FRAME_SIZE);
            this.desktop.add(frame);
            if (this.frames == null) {
                this.frames = new FHashMap();
            }
            this.frames.put(diagram, frame);
            if (this.getEditMode() != null) {
                this.getEditMode().activate(diagram);
            }
            frame.pack();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        newFrame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            });
        }
        return frame;
    }

    public InternalFrame getCurrentInternalFrame() {
        JInternalFrame selectedFrame = this.desktop.getSelectedFrame();
        if (selectedFrame instanceof InternalFrame) {
            return (InternalFrame)selectedFrame;
        }
        return this.frameDummy;
    }

    public void closeAllInternalFrames() {
        this.closeAllDiagrams();
        Component[] components = this.desktop.getComponents();
        int i = 0;
        while (i < components.length) {
            Component component = components[i];
            if (component instanceof JInternalFrame) {
                ((JInternalFrame)component).dispose();
                this.desktop.remove(component);
            }
            ++i;
        }
    }

    public void closeInternalFrameOfDiag(ASGDiagram diag) {
        InternalFrame iFrame;
        if (UMLProject.get().getCurrentDiagram() == diag) {
            this.selectTreeItem(null);
            UMLProject.get().setCurrentDiagram(null);
        }
        if (this.frames != null && (iFrame = (InternalFrame)this.frames.get(diag)) != null) {
            Component[] components = this.desktop.getComponents();
            int i = 0;
            while (i < components.length) {
                Component component = components[i];
                if (component == iFrame) {
                    this.frames.remove(diag);
                    this.desktop.remove(iFrame);
                    iFrame.dispose();
                }
                ++i;
            }
        }
    }

    public void closeAllDiagrams() {
        this.selectTreeItem(null);
        UMLProject.get().setCurrentDiagram(null);
        if (this.frames != null) {
            Iterator iterator = this.frames.values().iterator();
            while (iterator.hasNext()) {
                InternalFrame frame = (InternalFrame)iterator.next();
                frame.dispose();
            }
        }
    }

    public JPropertyTable getPropertyEditor() {
        return this.propertyEditor;
    }

    public void showPropertyEditor(boolean show) {
        this.leftSplitPane.setBottomComponent(show ? this.propertyEditorContainer : null);
    }

    public void writePropertyEditorConfig() {
        URL url = this.getClass().getResource("../gui/propertyeditor.config");
        if (url != null) {
            try {
                FileOutputStream out = new FileOutputStream(URLDecoder.decode(url.getFile(), "UTF-8"));
                propertyConfiguration.writeConfig((OutputStream)out);
                out.close();
            }
            catch (IOException e) {
                log.error((Object)"error while writing propertyeditor.config", (Throwable)e);
            }
        } else {
            log.error((Object)"propertyeditor.config file not found");
        }
    }

    private void centerFrame() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration defaultGC = ge.getDefaultScreenDevice().getDefaultConfiguration();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(defaultGC);
        Dimension visibleScreenSize = new Dimension(screenSize.width - (screenInsets.left + screenInsets.right), screenSize.height - (screenInsets.top + screenInsets.bottom));
        Dimension dim = new Dimension();
        if (FujabaApp.get().isMaximize()) {
            dim.width = visibleScreenSize.width;
            dim.height = visibleScreenSize.height;
        } else {
            dim.width = Math.min(1024, visibleScreenSize.width * 9 / 10);
            dim.height = Math.min(768, visibleScreenSize.height * 9 / 10);
        }
        this.pack();
        this.setSize(dim);
        int newLocationX = visibleScreenSize.width / 2 - dim.width / 2 + screenInsets.left;
        int newLocationY = visibleScreenSize.height / 2 - dim.height / 2 + screenInsets.top;
        this.setLocation(newLocationX, newLocationY);
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void show() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        super.show();
    }

    public boolean setTabbedPaneProxy(TabbedPaneProxy value) {
        boolean changed = false;
        if (this.tabbedPaneProxy != value) {
            if (this.tabbedPaneProxy != null) {
                TabbedPaneProxy oldValue = this.tabbedPaneProxy;
                this.tabbedPaneProxy = null;
                oldValue.setFrameMain(null);
            }
            this.tabbedPaneProxy = value;
            if (value != null) {
                value.setFrameMain(this);
            }
            changed = true;
        }
        return changed;
    }

    public TabbedPaneProxy getTabbedPaneProxy() {
        return this.tabbedPaneProxy;
    }

    public boolean hasInDecorators(FrameDecorator value) {
        return this.decorators != null && value != null && this.decorators.contains(value);
    }

    public Iterator iteratorOfDecorators() {
        return this.decorators == null ? FEmptyIterator.get() : this.decorators.iterator();
    }

    public int sizeOfDecorators() {
        return this.decorators == null ? 0 : this.decorators.size();
    }

    public boolean addToDecorators(FrameDecorator value) {
        boolean changed = false;
        if (value != null) {
            if (this.decorators == null) {
                this.decorators = new FHashSet();
            }
            if (changed = this.decorators.add(value)) {
                value.setFrameMain(this);
            }
        }
        return changed;
    }

    public boolean removeFromDecorators(FrameDecorator value) {
        boolean changed = false;
        if (this.decorators != null && value != null && (changed = this.decorators.remove(value))) {
            value.setFrameMain(null);
        }
        return changed;
    }

    public void removeAllFromDecorators() {
        Iterator iter = this.iteratorOfDecorators();
        while (iter.hasNext()) {
            FrameDecorator tmpValue = (FrameDecorator)iter.next();
            this.removeFromDecorators(tmpValue);
        }
    }

    public void removeYou() {
        TabbedPaneProxy tmpTabbedPaneProxy = this.getTabbedPaneProxy();
        if (tmpTabbedPaneProxy != null) {
            this.setTabbedPaneProxy(null);
        }
        this.removeAllFromDecorators();
    }

    public void setUMLProject(UMLProject project) {
        if (this.umlProject != project) {
            if (this.umlProject != null) {
                UMLProject oldUMLProject = this.umlProject;
                this.umlProject = null;
                oldUMLProject.setGui(null);
            }
            this.umlProject = project;
            if (project != null) {
                this.umlProject.setGui(this);
            }
            if (this.getTabbedPaneProxy() != null) {
                this.getTabbedPaneProxy().update();
            }
            this.showTitle();
        }
    }

    public JPanel createStatusbar() {
        JPanel statusPanel = new JPanel();
        statusPanel.setBorder(new EmptyBorder(new Insets(3, 8, 3, 8)));
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        statusPanel.setLayout(gridBag);
        this.statusLabel = new JLabel();
        this.statusLabel.setBorder(new BevelBorder(1));
        this.statusLabel.setFont(new Font("SansSerif", 0, 10));
        constraints.gridwidth = -1;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        gridBag.setConstraints(this.statusLabel, constraints);
        statusPanel.add(this.statusLabel);
        this.setStatusLabel("Welcome to Fujaba Tool Suite!");
        this.memoryLabel = new JLabel();
        this.memoryLabel.setBorder(new BevelBorder(1));
        this.memoryLabel.setFont(new Font("SansSerif", 0, 10));
        this.memoryLabel.setToolTipText("Memory Usage/Allocation");
        this.setMemoryLabel();
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        gridBag.setConstraints(this.memoryLabel, constraints);
        statusPanel.add(this.memoryLabel);
        return statusPanel;
    }

    public void setStatusLabel(final String text) {
        if (this.statusLabel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FrameMain.this.statusLabel.setText(" " + text + " ");
                    FrameMain.this.statusLabel.repaint();
                }
            });
            if (text != null && !"".equals(text)) {
                Message message = new Message(text);
                if (this.displayedStatusMessages.size() > 10) {
                    this.getMessageView().removeFromMessages((Message)this.displayedStatusMessages.removeFirst());
                }
                message.setMessageCategory(MESSAGE_CLASS_STATUS);
                this.displayedStatusMessages.add(message);
                this.getMessageView().addToMessages(message);
            }
        }
    }

    public Message showError(String text, ASGElement context) {
        ErrorMessage message = new ErrorMessage(text);
        message.addToContext(context);
        message.setMessageCategory(MESSAGE_CLASS_STATUS);
        this.getMessageView().addToMessages(message);
        this.showMessageView();
        return message;
    }

    private String getKiloByte(long memory) {
        String value;
        long mem = memory / 1024L;
        if (mem >= 1024L) {
            mem /= 1024L;
            value = " MByte";
        } else {
            value = " KByte";
        }
        value = String.valueOf(mem) + value;
        return value;
    }

    public void setMemoryLabel() {
        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory();
        long total = runtime.totalMemory();
        String text = String.valueOf(this.getKiloByte(total - free)) + " of " + this.getKiloByte(total) + " allocated";
        this.memoryLabel.setText(" " + text + " ");
    }

    public void doEverythingOnEntry(ASGDiagram diag) {
        this.doEverythingOnEntry(diag, true);
    }

    public void doEverythingOnEntry(ASGDiagram diag, boolean saveScrollBarPos) {
        Iterator iter = this.iteratorOfDecorators();
        while (iter.hasNext()) {
            FrameDecorator decorator = (FrameDecorator)iter.next();
            decorator.enterDiagram(diag);
        }
        if (saveScrollBarPos && diag != null) {
            InternalFrame diagFrame = this.getInternalFrame(diag);
            JScrollPane pane = diagFrame.getScrollerPanel();
            Point pos = (Point)this.scrollBarPositions.get(diag);
            if (pane != null) {
                JScrollBar bar = pane.getHorizontalScrollBar();
                if (bar != null) {
                    if (pos != null) {
                        bar.setValue((int)pos.getX());
                    } else {
                        bar.setValue(0);
                    }
                }
                if ((bar = pane.getVerticalScrollBar()) != null) {
                    if (pos != null) {
                        bar.setValue((int)pos.getY());
                    } else {
                        bar.setValue(0);
                    }
                }
            }
        }
    }

    public FSALayeredPane getDiagramRoot() {
        return this.getCurrentInternalFrame().getDiagramRoot();
    }

    public void doEverythingOnExit(ASGDiagram diag) {
        this.doEverythingOnExit(diag, true);
    }

    public void doEverythingOnExit(ASGDiagram diag, boolean saveScrollBarPos) {
        JScrollPane pane;
        Iterator iter = this.iteratorOfDecorators();
        while (iter.hasNext()) {
            FrameDecorator decorator = (FrameDecorator)iter.next();
            decorator.leaveDiagram(diag);
        }
        if (saveScrollBarPos && diag != null && (pane = this.getInternalFrame(diag).getScrollerPanel()) != null) {
            int scrollX = 0;
            int scrollY = 0;
            JScrollBar bar = pane.getHorizontalScrollBar();
            if (bar != null) {
                scrollX = bar.getValue();
            }
            if ((bar = pane.getVerticalScrollBar()) != null) {
                scrollY = bar.getValue();
            }
            this.scrollBarPositions.put(diag, new Point(scrollX, scrollY));
        }
        UMLProject.get().refreshDisplay();
    }

    protected JSplitPane createSplitPane(Component westComp, Component eastComp) {
        JSplitPane pane = new JSplitPane(1, westComp, eastComp);
        pane.setOneTouchExpandable(true);
        pane.setPreferredSize(new Dimension(400, 300));
        if (pane.getDividerLocation() < 20) {
            pane.setDividerLocation(200);
        }
        return pane;
    }

    protected void setRightComponent(Component comp) {
        this.getSplitPane().setRightComponent(comp);
        this.getSplitPane().setDividerLocation(200);
        this.getSplitPane().setLastDividerLocation(200);
    }

    protected Component getRightComponent() {
        return this.getSplitPane().getRightComponent();
    }

    public JSplitPane getSplitPane() {
        return this.splitpane;
    }

    public JFrame getFrame() {
        return this;
    }

    public void setCursorWait() {
        this.getFrame().setCursor(Cursor.getPredefinedCursor(3));
    }

    public void setCursorDefault() {
        this.getFrame().setCursor(Cursor.getPredefinedCursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void openFile(File file) {
        if (!file.exists()) return;
        if (!file.isFile()) return;
        try {
            try {
                this.closeAllInternalFrames();
                this.getTabbedPaneProxy().getTabbedPane().setSelectedIndex(-1);
                UMLProject newProject = null;
                FrameMain frameMain = this;
                synchronized (frameMain) {
                    String fileName = file.getName();
                    if (FujabaChangeManager.getVMRepository() != null && !FujabaChangeManager.getVMRepository().isServerRepository() && !FujabaChangeManager.getVMRepository().isEmpty()) {
                        this.setUMLProject(null);
                        UMLProject.setNewProject(null);
                        FujabaChangeManager.setVMRepository(new LocalRepository());
                    }
                    UMLAttr.setSyncVisibilities(false);
                    try {
                        AbstractAction restoreAction;
                        ASGUnparseInformation.resetPointsCalled();
                        if (fileName.endsWith(".fpr") || fileName.endsWith(".fpr.gz")) {
                            newProject = UMLProject.loadProject(file);
                            this.setSaveAction(null);
                        } else if (fileName.endsWith(".cxr") || fileName.endsWith(".cxr.gz") || fileName.endsWith(".cxri")) {
                            new RestoreAction().restoreWithProgressDialog(file.getPath());
                            this.setSaveAction(UserInterfaceManager.get().getFromActions("coobra.store"));
                        } else if ((fileName.endsWith(".xml") || fileName.endsWith(".xml.gz")) && (restoreAction = UserInterfaceManager.get().getFromActions("XMLReflect.restoreXML")) != null) {
                            ActionEvent event = new ActionEvent("directly", -1, file.getPath());
                            restoreAction.actionPerformed(event);
                            this.setSaveAction(UserInterfaceManager.get().getFromActions("XMLReflect.storeXML"));
                        }
                        ASGUnparseInformation.isPointsCalled();
                        Object var7_11 = null;
                        FileHistory.get().addToHistory(file);
                    }
                    catch (Throwable throwable) {
                        Object var7_10 = null;
                        FileHistory.get().addToHistory(file);
                        FileHistory.get().updateActions();
                        UMLProject.get().setSaved(true);
                        UMLProject.get().setFile(file);
                        UMLStereotypeManager.get().initDefaultStereotypes();
                        UMLAttr.setSyncVisibilities(true);
                        throw throwable;
                    }
                    FileHistory.get().updateActions();
                    UMLProject.get().setSaved(true);
                    UMLProject.get().setFile(file);
                    UMLStereotypeManager.get().initDefaultStereotypes();
                    UMLAttr.setSyncVisibilities(true);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"OpenAction: UMLProject.loadProject done ");
                }
                this.setUMLProject(newProject);
            }
            catch (Exception except) {
                except.printStackTrace();
                String message = except.getMessage();
                if ("".equals(message)) {
                    message = except.getClass().getName();
                }
                JOptionPane.showMessageDialog(this.getFrame(), message, "Warning: Can't load", 2);
            }
            Object var9_14 = null;
            this.getTabbedPaneProxy().update();
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            this.getTabbedPaneProxy().update();
            if (!log.isDebugEnabled()) throw throwable;
            log.debug((Object)"OpenAction: analyse engines resumed");
            throw throwable;
        }
        if (!log.isDebugEnabled()) return;
        log.debug((Object)"OpenAction: analyse engines resumed");
    }

    private void repairUnparseInformation() {
        Iterator it = UMLProject.get().iteratorOfDiags();
        while (it.hasNext()) {
            ASGDiagram diag = (ASGDiagram)it.next();
            FSAContainer pane = (FSAContainer)UnparseManager.get().unparse(diag, diag.getFromFsaObjects("@__null.entry"));
            this.saveFSAProperties(pane);
        }
    }

    private void saveFSAProperties(FSAContainer container) {
        Iterator it = container.iteratorOfChildren();
        while (it.hasNext()) {
            FSAObject child = (FSAObject)it.next();
            if (child instanceof FSAContainer) {
                this.saveFSAProperties((FSAContainer)child);
                continue;
            }
            child.saveFSAProperties();
        }
        container.saveFSAProperties();
    }

    public void createNewTreeItems() {
        this.getTabbedPaneProxy().update();
    }

    public void selectTreeItem(Object obj) {
        Runnable doUpdate = null;
        if (obj != null) {
            final TabProxy tabProxy = this.getTabbedPaneProxy().findTabProxy(obj);
            if (tabProxy != null) {
                final JTabbedPane pane = this.getTabbedPaneProxy().getTabbedPane();
                final TreePath newPath = tabProxy.findTreePath(obj);
                final JTree tree = tabProxy.getTree();
                final boolean update = newPath != null && !newPath.equals(tree.getSelectionPath());
                doUpdate = new Runnable(){

                    public void run() {
                        pane.setSelectedComponent(tabProxy.getComponent());
                        if (update) {
                            tree.clearSelection();
                            tree.setSelectionPath(newPath);
                        }
                    }
                };
            }
        } else {
            Component selectedComponent;
            Component tmpSelectedComponent = this.getTabbedPaneProxy().getTabbedPane().getSelectedComponent();
            if (tmpSelectedComponent instanceof JScrollPane) {
                tmpSelectedComponent = ((JScrollPane)tmpSelectedComponent).getViewport().getView();
            }
            if ((selectedComponent = tmpSelectedComponent) instanceof JTree) {
                doUpdate = new Runnable(){

                    public void run() {
                        ((JTree)selectedComponent).setSelectionPath(null);
                    }
                };
            }
        }
        if (doUpdate != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                doUpdate.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(doUpdate);
                }
                catch (InterruptedException tmpSelectedComponent) {
                }
                catch (InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public DefaultMutableTreeNode getSelectedTreeNode() {
        DefaultMutableTreeNode node = null;
        Component component = this.getTabbedPaneProxy().getTabbedPane().getSelectedComponent();
        if (component != null) {
            TreePath path;
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getView();
            }
            if (component instanceof JTree && (path = ((JTree)component).getSelectionPath()) != null) {
                node = (DefaultMutableTreeNode)path.getLastPathComponent();
            }
        }
        return node;
    }

    public void showTitle() {
        String name;
        File file;
        String project;
        final StringBuffer title = new StringBuffer("Fujaba 4");
        String string = project = this.umlProject != null ? this.umlProject.getName() : null;
        if (project != null && !project.equals("")) {
            title.append(" [");
            title.append(project);
            title.append("]");
        }
        File file2 = file = UMLProject.get() != null ? UMLProject.get().getFile() : null;
        if (file != null && !(name = file.getName()).equals("")) {
            title.append(" - ");
            title.append(name);
        }
        Runnable doUpdate = new Runnable(){

            public void run() {
                FrameMain.this.getFrame().setTitle(title.toString());
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            doUpdate.run();
        } else {
            SwingUtilities.invokeLater(doUpdate);
        }
    }

    public void addDiagramToolBar(JToolBar toolBar) {
        if (this.getCurrentInternalFrame() != null) {
            this.getCurrentInternalFrame().addDiagramToolBar(toolBar);
        }
    }

    public void removeDiagramToolBar(JToolBar toolBar) {
        if (this.getCurrentInternalFrame() != null) {
            this.getCurrentInternalFrame().removeDiagramToolBar(toolBar);
        }
    }

    public AbstractAction getSaveAction() {
        if (this.saveAction == null) {
            this.saveAction = UserInterfaceManager.get().getFromActions("saveProject");
        }
        return this.saveAction;
    }

    public void setSaveAction(AbstractAction value) {
        AbstractAction oldValue = this.saveAction;
        if (oldValue != value) {
            this.saveAction = value;
            this.firePropertyChange("saveAction", oldValue, value);
        }
    }

    private class PropertyEditorPopupSourceListener
    implements PopupSourceListener {
        PropertyEditorPopupSourceListener() {
        }

        public void popupSourceChanged(LogicUnparseInterface newSource) {
            if (!FrameMain.this.getPropertyEditor().isPopupMenuVisible()) {
                FrameMain.this.getPropertyEditor().removeAllFromShownObjects();
                if (newSource instanceof Iterator) {
                    FrameMain.this.getPropertyEditor().addToShownObjects((Iterator)((Object)newSource));
                } else {
                    FrameMain.this.getPropertyEditor().addToShownObjects((Object)newSource);
                    FrameMain.this.propertyEditorCaption.setText(this.simpleClassName(newSource));
                }
            }
        }

        private String simpleClassName(LogicUnparseInterface element) {
            if (element != null) {
                String className = element.getClass().getName();
                if (className.lastIndexOf(46) > 0) {
                    className = className.substring(className.lastIndexOf(46) + 1, className.length());
                }
                return className;
            }
            return "";
        }
    }

    private class DoUpdateStatusBar
    implements Runnable {
        DoUpdateStatusBar() {
        }

        public void run() {
            FrameMain.this.setMemoryLabel();
        }
    }

    private class StatusBarUpdater
    extends Thread {
        public StatusBarUpdater() {
            block2: {
                this.setName(this.getClass().getName());
                try {
                    this.setPriority(1);
                }
                catch (Exception e) {
                    if (!log.isInfoEnabled()) break block2;
                    log.info((Object)"Status update thread priority not lowered!");
                }
            }
        }

        public void run() {
            DoUpdateStatusBar doUpdateStatusBar = new DoUpdateStatusBar();
            while (true) {
                SwingUtilities.invokeLater(doUpdateStatusBar);
                try {
                    StatusBarUpdater.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

