/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.app;

import de.uni_paderborn.fujaba.app.FujabaTreeNodeObject;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import de.uni_paderborn.lib.basic.ImageResourceManager;
import java.awt.Component;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

class FujabaTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Icon diagramIcon;
    private Icon viewIcon;
    private Icon elementIcon;

    public FujabaTreeCellRenderer() {
        ImageResourceManager manager = ImageResourceManager.get();
        this.diagramIcon = manager.getImageIcon("fujaba.core", "de/uni_paderborn/fujaba/app/images/diagram.gif");
        this.viewIcon = manager.getImageIcon("fujaba.core", "de/uni_paderborn/fujaba/app/images/view.gif");
        this.elementIcon = manager.getImageIcon("fujaba.core", "de/uni_paderborn/fujaba/app/images/class.gif");
        this.setClosedIcon(manager.getImageIcon("fujaba.core", "de/uni_paderborn/fujaba/app/images/closedFolder.gif"));
        this.setOpenIcon(manager.getImageIcon("fujaba.core", "de/uni_paderborn/fujaba/app/images/openFolder.gif"));
    }

    public Component getTreeCellRendererComponent(JTree tree, Object node, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, node, sel, expanded, leaf && node != tree.getModel().getRoot(), row, hasFocus);
        if (node instanceof DefaultMutableTreeNode) {
            Object value = ((DefaultMutableTreeNode)node).getUserObject();
            if (value instanceof FujabaTreeNodeObject) {
                FujabaTreeNodeObject treeNode = (FujabaTreeNodeObject)value;
                label.setIcon(treeNode.getIcon());
                label.setToolTipText(treeNode.getToolTipText());
                String tags = treeNode.getHtmlTags();
                if (tags != null && tags.length() > 0) {
                    tags = "<html>" + tags;
                    String endTags = "";
                    StringTokenizer token = new StringTokenizer(tags, "<>");
                    while (token.hasMoreTokens()) {
                        endTags = "</" + token.nextToken() + ">" + endTags;
                    }
                    String newText = String.valueOf(tags) + label.getText() + endTags;
                    label.setText(newText);
                }
            } else if (value instanceof ASGDiagram) {
                if (label.isEnabled()) {
                    if (value instanceof ViewDiagram) {
                        if (this.viewIcon != null) {
                            label.setIcon(this.viewIcon);
                        } else if (this.diagramIcon != null) {
                            label.setIcon(this.diagramIcon);
                        }
                    } else if (this.diagramIcon != null) {
                        label.setIcon(this.diagramIcon);
                    }
                } else if (value instanceof ViewDiagram) {
                    if (this.viewIcon != null) {
                        label.setDisabledIcon(this.viewIcon);
                    } else if (this.diagramIcon != null) {
                        label.setDisabledIcon(this.diagramIcon);
                    }
                } else if (this.diagramIcon != null) {
                    label.setDisabledIcon(this.diagramIcon);
                }
            } else if (value instanceof FElement && this.elementIcon != null) {
                label.setIcon(this.elementIcon);
            }
        }
        return label;
    }
}

