/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.app;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class ProgressBar
extends JDialog {
    JButton cancel;
    int maxNr;
    int actNr;
    private boolean aborted;
    private JPanel container = new JPanel();
    JLabel labelInfo = new JLabel();
    JLabel labelNr = new JLabel();
    JProgressBar progressBar = new JProgressBar();

    public ProgressBar(JFrame f, int maxNr, String title) {
        super((Frame)f, title);
        this.maxNr = maxNr;
        this.setResizable(false);
        this.container.setBorder(new EmptyBorder(new Insets(15, 20, 20, 30)));
        this.container.setLayout(new BoxLayout(this.container, 1));
        JPanel cont = new JPanel();
        cont.setLayout(new BoxLayout(cont, 0));
        cont.setAlignmentX(0.5f);
        Dimension d = new Dimension(400, 20);
        cont.setMaximumSize(d);
        cont.setPreferredSize(d);
        d = new Dimension(300, 20);
        this.labelInfo.setPreferredSize(d);
        this.labelInfo.setMaximumSize(d);
        cont.add(this.labelInfo);
        d = new Dimension(100, 20);
        this.labelNr.setPreferredSize(d);
        this.labelNr.setMaximumSize(d);
        this.labelNr.setHorizontalAlignment(4);
        cont.add(this.labelNr);
        this.container.add(cont);
        this.progressBar.setAlignmentX(0.5f);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(maxNr);
        this.container.add(this.progressBar);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(new Insets(15, 0, 0, 0)));
        buttonPanel.setLayout(new FlowLayout(1));
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProgressBar.this.invokeCancelPressed();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ProgressBar.this.invokeCancelPressed();
            }
        });
        buttonPanel.add(this.cancel);
        this.getRootPane().setDefaultButton(this.cancel);
        this.container.add((Component)buttonPanel, "South");
        this.getContentPane().add(this.container);
        this.actNr = -1;
        this.increment("Please wait...");
        this.pack();
        this.centerDialog();
    }

    public void centerDialog() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getSize();
        this.setLocation(screenSize.width / 2 - size.width / 2, screenSize.height / 2 - size.height / 2);
    }

    public void increment(final String info) {
        Runnable doSetProgressBarValue = new Runnable(){

            public void run() {
                ProgressBar.this.progressBar.setValue(++ProgressBar.this.actNr);
                ProgressBar.this.labelInfo.setText(info);
                ProgressBar.this.labelNr.setText(String.valueOf(String.valueOf(ProgressBar.this.actNr)) + " / " + String.valueOf(ProgressBar.this.maxNr));
            }
        };
        SwingUtilities.invokeLater(doSetProgressBarValue);
    }

    public synchronized boolean isAborted() {
        return this.aborted;
    }

    synchronized void invokeCancelPressed() {
        this.aborted = true;
    }
}

