/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.app;

import de.uni_paderborn.fujaba.app.Block;
import de.uni_paderborn.fujaba.app.BlockContainer;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class ScrollPanel
extends JPanel
implements Runnable {
    int startPos;
    private int currBlock = 0;
    private int delay;
    private int scrollWidth;
    private int scrollHeight;
    int xmouse;
    int ymouse;
    int ydiff;
    boolean pause = false;
    boolean inpanel = false;
    private boolean initialize = true;
    private Color shadowCol = new Color(220, 220, 220);
    private Color symbolCol = new Color(220, 220, 220);
    private Color backgrCol = new Color(255, 255, 255);
    private Image mainImg;
    private Graphics mainMap;
    private Font titleF = new Font("Arial", 1, 15);
    private Font textF = new Font("Arial", 0, 12);
    private Font subtitleF = new Font("Arial", 0, 10);
    private Thread cthread;
    private BlockContainer cont;
    private String file;

    public ScrollPanel(int width, int height, int delay, String file) {
        this.delay = delay;
        this.file = file;
        this.startPos = height;
        this.setBackground(ColorsPreferences.get().DEFAULT_BACKGROUND);
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.addMouseListener(new ScrollPanelListener());
        this.addMouseMotionListener(new ScrollPanelMotionListener());
        this.scrollWidth = this.getWidth() - this.getInsets().left - this.getInsets().right;
        this.scrollHeight = this.getHeight() - this.getInsets().top - this.getInsets().bottom;
        this.cont = new BlockContainer(this.scrollWidth);
        this.cthread = new Thread(this);
        this.cthread.start();
    }

    public void run() {
        boolean wasVisible = false;
        try {
            this.cont.readScript(this.file, this.titleF, this.textF, this.subtitleF);
        }
        catch (Exception e) {
            this.add(new Label(e.getMessage()));
            return;
        }
        this.cthread.setPriority(5);
        while (this.cthread != null) {
            this.repaint();
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isParentVisible()) {
                if (!wasVisible) continue;
                this.cthread = null;
                continue;
            }
            wasVisible = true;
        }
    }

    private boolean isParentVisible() {
        boolean visible = true;
        int depth = 0;
        int maxDepth = 5;
        Container parent = this;
        while (visible && depth < maxDepth && !(parent instanceof Dialog)) {
            if ((parent = parent.getParent()) == null) {
                visible = false;
                break;
            }
            visible = parent.isVisible();
            ++depth;
        }
        return visible;
    }

    private void clearimg(Graphics g) {
        g.setColor(this.backgrCol);
        g.fillRect(0, 0, this.scrollWidth, this.scrollHeight);
    }

    private void displayBlock(Graphics g, Block block, int startYPos) {
        int yBlockPos = 0;
        if (this.pause) {
            g.setColor(this.symbolCol);
            g.fillRect(this.getWidth() - this.getInsets().right - 8, this.getHeight() - this.getInsets().bottom - 14, 4, 10);
            g.fillRect(this.getWidth() - this.getInsets().right - 16, this.getHeight() - this.getInsets().bottom - 14, 4, 10);
        } else if (this.inpanel) {
            int[] xCord = new int[]{this.getWidth() - this.getInsets().right - 16, this.getWidth() - this.getInsets().right - 4, this.getWidth() - this.getInsets().right - 16};
            int[] yCord = new int[]{this.getHeight() - this.getInsets().bottom - 16, this.getHeight() - this.getInsets().bottom - 10, this.getHeight() - this.getInsets().bottom - 4};
            g.setColor(this.symbolCol);
            g.fillPolygon(xCord, yCord, xCord.length);
        }
        int i = 0;
        while (i < block.getLineCount()) {
            FontMetrics fMetric;
            if (i <= block.getTitleCount()) {
                g.setFont(this.titleF);
                fMetric = g.getFontMetrics();
            } else if (i == block.getSubtitleLine()) {
                g.setFont(this.subtitleF);
                fMetric = g.getFontMetrics();
            } else {
                g.setFont(this.textF);
                fMetric = g.getFontMetrics();
            }
            if ((yBlockPos += fMetric.getHeight()) + startYPos > -5 && yBlockPos + startYPos - fMetric.getHeight() < this.getHeight()) {
                int xPos = (this.getWidth() - fMetric.stringWidth(block.getLine(i))) / 2;
                g.setColor(this.shadowCol);
                g.drawString(block.getLine(i), xPos + 2, yBlockPos + startYPos + 2);
                g.setColor(ColorsPreferences.get().DEFAULT_FOREGROUND);
                g.drawString(block.getLine(i), xPos, yBlockPos + startYPos);
            }
            ++i;
        }
    }

    private void scrollCont(Graphics g) {
        if (this.cont == null || this.cont.getBlockCount() == 0) {
            g.setColor(ColorsPreferences.get().ERROR);
            g.drawString("ERROR: Empty Container!", 5, 10);
            return;
        }
        if (!this.pause) {
            --this.startPos;
        }
        if (this.startPos < -this.cont.getBlock(this.currBlock).getBlockHeight()) {
            ++this.currBlock;
            if (this.currBlock == this.cont.getBlockCount()) {
                this.currBlock = 0;
            }
            this.startPos = this.getHeight() - this.getInsets().bottom;
        } else if (this.startPos > this.getHeight() - this.getInsets().bottom) {
            --this.currBlock;
            if (this.currBlock < 0) {
                this.currBlock = this.cont.getBlockCount() - 1;
            }
            this.startPos = -this.cont.getBlock(this.currBlock).getBlockHeight();
        }
        this.displayBlock(g, this.cont.getBlock(this.currBlock), this.startPos);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.initialize) {
            this.mainImg = this.createImage(this.scrollWidth, this.scrollHeight);
            this.mainMap = this.mainImg.getGraphics();
            this.initialize = false;
        } else {
            this.clearimg(this.mainMap);
            this.scrollCont(this.mainMap);
            g.drawImage(this.mainImg, this.getInsets().left, this.getInsets().right, this);
        }
    }

    private class ScrollPanelListener
    implements MouseListener {
        ScrollPanelListener() {
        }

        public void mouseEntered(MouseEvent e) {
            ScrollPanel.this.inpanel = true;
        }

        public void mouseExited(MouseEvent e) {
            ScrollPanel.this.inpanel = false;
        }

        public void mousePressed(MouseEvent e) {
            ScrollPanel.this.ymouse = e.getY();
            ScrollPanel.this.xmouse = e.getX();
        }

        public void mouseReleased(MouseEvent e) {
            ScrollPanel.this.ydiff = 0;
        }

        public void mouseClicked(MouseEvent e) {
            ScrollPanel.this.pause = !ScrollPanel.this.pause;
        }
    }

    private class ScrollPanelMotionListener
    implements MouseMotionListener {
        ScrollPanelMotionListener() {
        }

        public void mouseDragged(MouseEvent e) {
            int y = e.getY();
            ScrollPanel.this.pause = true;
            if (ScrollPanel.this.ydiff == 0) {
                ScrollPanel.this.ydiff = y;
            } else {
                ScrollPanel.this.startPos += y - ScrollPanel.this.ydiff;
                ScrollPanel.this.ydiff = y;
            }
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

