/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.app;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.TabbedPaneProxy;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.fsa.SelectionManager;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.gui.FPopupMenu;
import de.uni_paderborn.fujaba.metamodel.FClassDiagram;
import de.uni_paderborn.fujaba.packagediagrams.PackageDiagram;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.lib.userinterface.UserInterfaceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TabProxy {
    private DefaultMutableTreeNode root;
    JTree tree;
    private Component component;
    private Icon icon;
    private String tip = "";
    private String title = "";
    private TreeCellRenderer treeCellRenderer;
    private TabbedPaneProxy tabbedPaneProxy;

    public TabProxy(String tabTitle, String rootTitle, String tip, Icon icon) {
        this.setTitle(tabTitle);
        this.setRoot(new DefaultMutableTreeNode(rootTitle));
        this.setIcon(icon);
        this.setTip(tip);
    }

    public void setRoot(DefaultMutableTreeNode root) {
        if (this.root != root) {
            this.root = root;
        }
    }

    public DefaultMutableTreeNode getRoot() {
        return this.root;
    }

    public void setTree(JTree tree) {
        if (this.tree != tree) {
            this.tree = tree;
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public Component getComponent() {
        return this.component;
    }

    public Component setComponent(Component component) {
        if (this.component != component) {
            this.component = component;
        }
        return this.component;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Icon setIcon(Icon icon) {
        if (this.icon != icon) {
            this.icon = icon;
        }
        return this.icon;
    }

    public String getTip() {
        return this.tip;
    }

    public String setTip(String tip) {
        if (this.tip == null || this.tip != null && !this.tip.equals(tip)) {
            this.tip = tip;
        }
        return this.tip;
    }

    public String getTitle() {
        return this.title;
    }

    public String setTitle(String title) {
        if (this.title == null || this.title != null && !this.title.equals(title)) {
            this.title = title;
        }
        return this.title;
    }

    public TreeCellRenderer getTreeCellRenderer() {
        return this.treeCellRenderer;
    }

    public void setTreeCellRenderer(TreeCellRenderer treeCellRenderer) {
        this.treeCellRenderer = treeCellRenderer;
    }

    public void init() {
        this.setupTreeComponent();
        this.setComponent(this.setupScrollTreeComponent(this.getTree()));
    }

    public void addTreeNode(DefaultMutableTreeNode node) {
        this.root.add(node);
    }

    public boolean isTabEmpty() {
        return this.root.getChildCount() == 0;
    }

    protected JTree setupTreeComponent() {
        JTree tree;
        this.tree = tree = new JTree(new DefaultTreeModel(this.getRoot()));
        tree.setCellRenderer(this.treeCellRenderer);
        tree.setShowsRootHandles(false);
        tree.getSelectionModel().setSelectionMode(1);
        tree.putClientProperty("JTree.lineStyle", "None");
        tree.setRootVisible(false);
        tree.setEditable(true);
        tree.setCellEditor(new FujabaTreeCellEditor(tree));
        ToolTipManager.sharedInstance().registerComponent(tree);
        TreeListener listener = new TreeListener();
        tree.addTreeSelectionListener(listener);
        PopupListener popupListener = new PopupListener();
        tree.addMouseListener(popupListener);
        return tree;
    }

    protected JScrollPane setupScrollTreeComponent(JTree tree) {
        JScrollPane scrollPane = new JScrollPane(tree);
        return scrollPane;
    }

    public TreePath findTreePath(Object obj) {
        TreePath path = null;
        TreeModel model = this.tree.getModel();
        try {
            if (obj != null) {
                Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)model.getRoot()).breadthFirstEnumeration();
                while (path == null && enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode tmpNode = (DefaultMutableTreeNode)enumeration.nextElement();
                    if (!obj.equals(tmpNode.getUserObject())) continue;
                    path = new TreePath(tmpNode.getPath());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    public boolean setTabbedPaneProxy(TabbedPaneProxy value) {
        boolean changed = false;
        if (this.tabbedPaneProxy != value) {
            if (this.tabbedPaneProxy != null) {
                TabbedPaneProxy oldValue = this.tabbedPaneProxy;
                this.tabbedPaneProxy = null;
                oldValue.removeFromTabProxy(this);
            }
            this.tabbedPaneProxy = value;
            if (value != null) {
                value.addToTabProxy(this);
            }
            changed = true;
        }
        return changed;
    }

    public TabbedPaneProxy getTabbedPaneProxy() {
        return this.tabbedPaneProxy;
    }

    public void removeYou() {
        TabbedPaneProxy tmpTabbedPaneProxy = this.getTabbedPaneProxy();
        if (tmpTabbedPaneProxy != null) {
            this.setTabbedPaneProxy(null);
        }
    }

    public LogicUnparseInterface getLogicAt(int x, int y) {
        LogicUnparseInterface logic = null;
        TreePath path = this.getTree().getPathForLocation(x, y);
        if (path != null && path.getLastPathComponent() instanceof DefaultMutableTreeNode) {
            this.getTree().setSelectionPath(path);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object obj = node.getUserObject();
            if (obj instanceof LogicUnparseInterface) {
                logic = (LogicUnparseInterface)obj;
            }
        }
        return logic;
    }

    private class TreeListener
    implements TreeSelectionListener {
        TreeListener() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void valueChanged(TreeSelectionEvent e) {
            if (TabProxy.this.getTabbedPaneProxy() == null) {
                return;
            }
            FrameMain frame = FrameMain.get();
            frame.setCursorWait();
            try {
                Object obj = e.getPath().getLastPathComponent();
                if (obj instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                    obj = node.getUserObject();
                    while (true) {
                        if (!(node.getParent() instanceof DefaultMutableTreeNode) || obj instanceof ASGDiagram) {
                            if (!(obj instanceof ASGDiagram)) break;
                            FrameMain.get().showDiagram((ASGDiagram)obj);
                            break;
                        }
                        node = (DefaultMutableTreeNode)node.getParent();
                        obj = node.getUserObject();
                    }
                }
                UMLProject.get().refreshDisplay();
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                frame.setCursorDefault();
                throw throwable;
            }
            {
                Object var5_7 = null;
                frame.setCursorDefault();
                return;
            }
        }
    }

    private class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.maybeShowPopup(e);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.maybeShowPopup(e);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.maybeShowPopup(e);
            }
        }

        private void maybeShowPopup(MouseEvent e) {
            UserInterfaceManager uiManager;
            JPopupMenu popup;
            LogicUnparseInterface logic = TabProxy.this.getLogicAt(e.getX(), e.getY());
            if (e.isMetaDown() && e.getComponent() instanceof JTree && logic != null && (popup = (uiManager = UserInterfaceManager.get()).getFromPopupMenus(logic.getClass().getName())) != null) {
                SelectionManager.get().setPopupSource(TabProxy.this.tree, logic);
                FPopupMenu.show(popup, e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class FujabaTreeCellEditor
    extends DefaultCellEditor {
        private ASGDiagram editedDiagram;
        private DefaultMutableTreeNode editedNode;

        public FujabaTreeCellEditor(JTree tree) {
            super(new JTextField());
            this.addCellEditorListener(new FujabaCellEditorListener(this, tree));
        }

        private boolean isDiagramEditable(Object diagram) {
            return diagram instanceof FClassDiagram || diagram instanceof PackageDiagram;
        }

        public boolean isCellEditable(EventObject event) {
            JTree tree = event != null ? (JTree)event.getSource() : TabProxy.this.getTree();
            boolean superVote = super.isCellEditable(event);
            if (event instanceof MouseEvent) {
                MouseEvent mouse = (MouseEvent)event;
                TreePath path = tree.getPathForLocation(mouse.getX(), mouse.getY());
                Object userObject = null;
                try {
                    Object object = path.getLastPathComponent();
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
                    userObject = node.getUserObject();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                return superVote && this.isDiagramEditable(userObject);
            }
            return superVote;
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.editedNode = (DefaultMutableTreeNode)value;
            this.editedDiagram = this.isDiagramEditable(((DefaultMutableTreeNode)value).getUserObject()) ? (ASGDiagram)((DefaultMutableTreeNode)value).getUserObject() : null;
            Icon icon = null;
            int iconTextGap = 0;
            Component displayComp = tree.getCellRenderer().getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, false);
            if (displayComp instanceof JLabel) {
                icon = ((JLabel)displayComp).getIcon();
                iconTextGap = ((JLabel)displayComp).getIconTextGap();
            }
            Component editingComp = super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
            EditorContainer container = new EditorContainer(editingComp, icon, iconTextGap);
            container.add(editingComp);
            if (editingComp instanceof JTextField) {
                JTextField textField = (JTextField)editingComp;
                textField.selectAll();
            }
            SwingUtilities.invokeLater(new Runnable(this, editingComp){
                final /* synthetic */ FujabaTreeCellEditor this$1;
                private final /* synthetic */ Component val$editingComp;
                {
                    this.this$1 = fujabaTreeCellEditor;
                    this.val$editingComp = component;
                }

                public void run() {
                    this.val$editingComp.requestFocusInWindow();
                }
            });
            return container;
        }

        public ASGDiagram getCurrentEditedDiagram() {
            return this.editedDiagram;
        }

        public DefaultMutableTreeNode getCurrentEditedNode() {
            return this.editedNode;
        }
    }

    private class EditorContainer
    extends Container {
        private Component editingComponent;
        private Icon editingIcon;
        private int offset;

        public EditorContainer(Component editingComponent, Icon icon, int iconTextGap) {
            this.setLayout(null);
            this.editingIcon = icon;
            this.editingComponent = editingComponent;
            this.offset = iconTextGap;
            if (this.editingIcon != null) {
                this.offset += this.editingIcon.getIconWidth();
            }
        }

        public void paint(Graphics g) {
            if (this.editingIcon != null) {
                int yLoc = Math.max(0, (this.getSize().height - this.editingIcon.getIconHeight()) / 2);
                this.editingIcon.paintIcon(this, g, 0, yLoc);
            }
            super.paint(g);
        }

        public void doLayout() {
            if (this.editingComponent != null) {
                Dimension cSize = this.getSize();
                this.editingComponent.getPreferredSize();
                this.editingComponent.setLocation(this.offset, 0);
                this.editingComponent.setBounds(this.offset, 0, cSize.width - this.offset, cSize.height);
            }
        }

        public Dimension getPreferredSize() {
            if (this.editingComponent != null) {
                Dimension pSize = this.editingComponent.getPreferredSize();
                pSize.width += this.offset + 5;
                if (this.editingIcon != null) {
                    pSize.height = Math.max(pSize.height, this.editingIcon.getIconHeight());
                }
                pSize.width = Math.max(pSize.width, 100);
                return pSize;
            }
            return new Dimension(0, 0);
        }
    }

    private class FujabaCellEditorListener
    implements CellEditorListener {
        private FujabaTreeCellEditor editor;
        private JTree tree;

        public FujabaCellEditorListener(FujabaTreeCellEditor editor, JTree tree) {
            this.editor = editor;
            this.tree = tree;
        }

        public void editingCanceled(ChangeEvent e) {
        }

        public void editingStopped(ChangeEvent e) {
            ASGDiagram diagram = this.editor.getCurrentEditedDiagram();
            DefaultMutableTreeNode node = this.editor.getCurrentEditedNode();
            DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
            diagram.setName((String)this.editor.getCellEditorValue());
            node.setUserObject(diagram);
            model.nodeChanged(node);
        }
    }
}

