/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.app;

import de.uni_paderborn.fujaba.app.FrameDecorator;
import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.TabProxy;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.tools.fca.EnumerationForAnIterator;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FTreeMap;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class TabbedPaneProxy {
    private FrameMain frameMain;
    private FTreeMap tabProxy;
    private JTabbedPane tabbedPane = new JTabbedPane(3);
    public static final String TAB_PRJ = "UML";
    public static final String TAB_SDL = "SDL";
    public static final String TAB_CMS = "CMS";
    public static final String TAB_SQL = "SQL";
    public static final String TAB_FP = "Pattern";
    public static final String TAB_PATH = "Paths";
    public static final String TAB_XML = "XML";
    public static final String TAB_FUI = "FUI";
    public static final String TAB_PRJ_TIP = "UML Diagram View";
    public static final String TAB_SDL_TIP = "SDL Diagram View";
    public static final String TAB_CMS_TIP = "Consistency Management System";
    public static final String TAB_SQL_TIP = "SQL Diagram View";
    public static final String TAB_FP_TIP = "Pattern Specification";
    public static final String TAB_PATH_TIP = "Path Specification";
    public static final String TAB_XML_TIP = "XML Diagram View";
    public static final String TAB_FUI_TIP = "Fujaba User Interface";

    public TabbedPaneProxy() {
        this.tabbedPane.addChangeListener(new TabbedPaneProxyListener());
    }

    public boolean setFrameMain(FrameMain value) {
        boolean changed = false;
        if (this.frameMain != value) {
            if (this.frameMain != null) {
                FrameMain oldValue = this.frameMain;
                this.frameMain = null;
                oldValue.setTabbedPaneProxy(null);
            }
            this.frameMain = value;
            if (value != null) {
                value.setTabbedPaneProxy(this);
            }
            changed = true;
        }
        return changed;
    }

    public FrameMain getFrameMain() {
        return this.frameMain;
    }

    public boolean hasInTabProxy(TabProxy value) {
        return this.tabProxy != null && value != null && value.getTitle() != null && this.tabProxy.get(value.getTitle()) == value;
    }

    public boolean hasKeyInTabProxy(String key) {
        return this.tabProxy != null && key != null && this.tabProxy.containsKey(key);
    }

    public Iterator iteratorOfTabProxy() {
        return this.tabProxy == null ? FEmptyIterator.get() : this.tabProxy.values().iterator();
    }

    public Iterator keysOfTabProxy() {
        return this.tabProxy == null ? FEmptyIterator.get() : this.tabProxy.keySet().iterator();
    }

    public Iterator entriesOfTabProxy() {
        return this.tabProxy == null ? FEmptyIterator.get() : this.tabProxy.entrySet().iterator();
    }

    public int sizeOfTabProxy() {
        return this.tabProxy == null ? 0 : this.tabProxy.size();
    }

    public TabProxy getFromTabProxy(String key) {
        return this.tabProxy == null || key == null ? null : (TabProxy)this.tabProxy.get(key);
    }

    public boolean addToTabProxy(TabProxy value) {
        boolean changed = false;
        if (value != null && value.getTitle() != null) {
            TabProxy oldValue;
            if (this.tabProxy == null) {
                this.tabProxy = new FTreeMap();
            }
            if ((oldValue = (TabProxy)this.tabProxy.put(value.getTitle(), value)) != value) {
                if (oldValue != null) {
                    oldValue.setTabbedPaneProxy(null);
                }
                value.setTabbedPaneProxy(this);
                changed = true;
            }
        }
        return changed;
    }

    public boolean removeFromTabProxy(TabProxy value) {
        TabProxy oldValue;
        boolean changed = false;
        if (this.tabProxy != null && value != null && value.getTitle() != null && (oldValue = (TabProxy)this.tabProxy.get(value.getTitle())) == value) {
            this.tabProxy.remove(value.getTitle());
            value.setTabbedPaneProxy(null);
            changed = true;
        }
        return changed;
    }

    public boolean removeKeyFromTabProxy(String key) {
        TabProxy tmpValue;
        boolean changed = false;
        if (this.tabProxy != null && key != null && (tmpValue = (TabProxy)this.tabProxy.get(key)) != null) {
            this.tabProxy.remove(key);
            tmpValue.setTabbedPaneProxy(null);
            changed = true;
        }
        return changed;
    }

    public void removeAllFromTabProxy() {
        Iterator iter = this.iteratorOfTabProxy();
        while (iter.hasNext()) {
            TabProxy tmpValue = (TabProxy)iter.next();
            this.removeFromTabProxy(tmpValue);
        }
    }

    public void removeYou() {
        FrameMain tmpFrameMain = this.getFrameMain();
        if (tmpFrameMain != null) {
            this.setFrameMain(null);
        }
        this.removeAllFromTabProxy();
    }

    public void setTabbedPane(JTabbedPane tabbedPane) {
        if (this.tabbedPane != tabbedPane) {
            this.tabbedPane = tabbedPane;
        }
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public void update() {
        ASGDiagram selectedDiagram = null;
        Object selectedObject = null;
        DefaultMutableTreeNode selectedNode = this.getFrameMain().getSelectedTreeNode();
        if (selectedNode != null && (selectedObject = selectedNode.getUserObject()) != null && selectedObject instanceof ASGDiagram) {
            selectedDiagram = (ASGDiagram)selectedObject;
        }
        Iterator tabIter = this.iteratorOfTabProxy();
        while (tabIter.hasNext()) {
            TabProxy tmpTab = (TabProxy)tabIter.next();
            tmpTab.getRoot().removeAllChildren();
        }
        Iterator decoratorIter = this.getFrameMain().iteratorOfDecorators();
        while (decoratorIter.hasNext()) {
            Iterator diagsIter;
            FrameDecorator decorator = (FrameDecorator)decoratorIter.next();
            DefaultMutableTreeNode node = decorator.getTreeNode(new EnumerationForAnIterator(diagsIter = UMLProject.get().iteratorOfDiags()));
            if (node != null && node.getChildCount() != 0) {
                if (node.isLeaf()) continue;
                TabProxy tmpTab = this.instanceOfTabProxy(decorator.getDestTabTitle());
                tmpTab.addTreeNode(node);
                tmpTab.setTreeCellRenderer(decorator.getTreeCellRenderer());
                continue;
            }
            String tabTitle = decorator.getDestTabTitle();
            if (tabTitle == null || !this.instanceOfTabProxy(decorator.getDestTabTitle()).isTabEmpty() || tabTitle.equals(TAB_PRJ)) continue;
            this.removeKeyFromTabProxy(tabTitle);
        }
        Iterator iter = this.iteratorOfTabProxy();
        final int tabCount = this.sizeOfTabProxy();
        final TabProxy[] proxies = new TabProxy[tabCount];
        int i = 0;
        while (i < tabCount && iter.hasNext()) {
            TabProxy tmpTab = (TabProxy)iter.next();
            tmpTab.init();
            tmpTab.getTree().setModel(new DefaultTreeModel(tmpTab.getRoot()));
            proxies[i] = tmpTab;
            ++i;
        }
        final JTabbedPane pane = this.getTabbedPane();
        Runnable tabUpdate = new Runnable(){

            public void run() {
                pane.removeAll();
                int i = 0;
                while (i < tabCount) {
                    TabProxy tmpTab = proxies[i];
                    pane.addTab(tmpTab.getTitle(), tmpTab.getIcon(), tmpTab.getComponent(), tmpTab.getTip());
                    ++i;
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            tabUpdate.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(tabUpdate);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (selectedObject != null) {
            this.getFrameMain().selectTreeItem(selectedObject);
        }
        this.getFrameMain().doEverythingOnEntry(selectedDiagram);
    }

    public TabProxy instanceOfTabProxy(String title) {
        TabProxy tmpTabProxy = null;
        if (title != null) {
            if (this.hasKeyInTabProxy(title)) {
                tmpTabProxy = this.getFromTabProxy(title);
            } else if (title.equals(TAB_PRJ)) {
                tmpTabProxy = new TabProxy(TAB_PRJ, TAB_PRJ, TAB_PRJ_TIP, null);
                this.addToTabProxy(tmpTabProxy);
            } else if (title.equals(TAB_SDL)) {
                tmpTabProxy = new TabProxy(TAB_SDL, TAB_SDL, TAB_SDL_TIP, null);
                this.addToTabProxy(tmpTabProxy);
            } else if (title.equals(TAB_CMS)) {
                tmpTabProxy = new TabProxy(TAB_CMS, TAB_CMS, TAB_CMS_TIP, null);
                this.addToTabProxy(tmpTabProxy);
            } else if (title.equals(TAB_FP)) {
                tmpTabProxy = new TabProxy(TAB_FP, TAB_FP, TAB_FP_TIP, null);
                this.addToTabProxy(tmpTabProxy);
            } else if (title.equals(TAB_SQL)) {
                tmpTabProxy = new TabProxy(TAB_SQL, TAB_SQL, TAB_SQL_TIP, null);
                this.addToTabProxy(tmpTabProxy);
            } else if (title.equals(TAB_PATH)) {
                tmpTabProxy = new TabProxy(TAB_PATH, TAB_PATH, TAB_PATH_TIP, null);
                this.addToTabProxy(tmpTabProxy);
            } else if (title.equals(TAB_FUI)) {
                tmpTabProxy = new TabProxy(TAB_FUI, TAB_FUI, TAB_FUI_TIP, null);
                this.addToTabProxy(tmpTabProxy);
            } else if (title.equals(TAB_XML)) {
                tmpTabProxy = new TabProxy(TAB_XML, TAB_XML, TAB_XML_TIP, null);
                this.addToTabProxy(tmpTabProxy);
            } else {
                tmpTabProxy = new TabProxy(title, title, title, null);
                this.addToTabProxy(tmpTabProxy);
            }
        }
        return tmpTabProxy;
    }

    public TabProxy findTabProxy(Object obj) {
        TabProxy tab = null;
        if (obj != null) {
            Iterator iter = this.iteratorOfTabProxy();
            while (tab == null && iter.hasNext()) {
                TabProxy tmpTabProxy = (TabProxy)iter.next();
                JTree tree = tmpTabProxy.getTree();
                TreeModel model = tree.getModel();
                Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)model.getRoot()).breadthFirstEnumeration();
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode tmpNode = (DefaultMutableTreeNode)enumeration.nextElement();
                    if (!obj.equals(tmpNode.getUserObject())) continue;
                    tab = tmpTabProxy;
                }
            }
        }
        return tab;
    }

    public void reloadTreeModels() {
        Iterator iter = this.iteratorOfTabProxy();
        while (iter.hasNext()) {
            TabProxy tmpTab = (TabProxy)iter.next();
            JTree tree = tmpTab.getTree();
            if (tree == null) continue;
            ((DefaultTreeModel)tree.getModel()).reload();
        }
    }

    private class TabbedPaneProxyListener
    implements ChangeListener {
        TabbedPaneProxyListener() {
        }

        public void stateChanged(ChangeEvent e) {
            DefaultMutableTreeNode node = TabbedPaneProxy.this.getFrameMain().getSelectedTreeNode();
            JTree tree = null;
            Component component = TabbedPaneProxy.this.getTabbedPane().getSelectedComponent();
            if (component != null) {
                if (component instanceof JScrollPane) {
                    component = ((JScrollPane)component).getViewport().getView();
                }
                if (component instanceof JTree) {
                    tree = (JTree)component;
                }
            }
            if (tree != null) {
                tree.clearSelection();
            }
            if (node != null) {
                Object obj = node.getUserObject();
                if (obj != null) {
                    TabbedPaneProxy.this.getFrameMain().selectTreeItem(obj);
                }
            } else if (tree != null) {
                tree.setSelectionRow(0);
            }
        }
    }
}

