/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.app.action;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.FujabaApp;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.basic.FileStringReader;
import de.uni_paderborn.fujaba.basic.ProcessOutputViewer;
import de.uni_paderborn.fujaba.messages.CompilerErrorMessage;
import de.uni_paderborn.fujaba.messages.CompilerMessage;
import de.uni_paderborn.fujaba.messages.CompilerWarning;
import de.uni_paderborn.fujaba.messages.ErrorMessage;
import de.uni_paderborn.fujaba.messages.Message;
import de.uni_paderborn.fujaba.messages.MessageWithThrowable;
import de.uni_paderborn.fujaba.metamodel.FFile;
import de.uni_paderborn.fujaba.metamodel.FPackage;
import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import de.uni_paderborn.fujaba.texteditor.TextEditor;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.actions.EditTextAction;
import de.uni_paderborn.lib.classloader.UPBClassLoader;
import de.upb.lib.plugins.PluginJarFile;
import de.upb.lib.plugins.PluginManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class CompileAction
extends AbstractAction {
    private ProcessOutputViewer myView = null;
    private boolean quietCompile = false;
    private String outPath = "";
    private ActionListener exitAction = null;
    public static final String MESSAGE_CLASS_COMPILE_ERROR = "Compiler error";
    public static final String MESSAGE_CLASS_COMPILE_WARNING = "Compiler warning";
    public static final String FILE_SUFFIX = ".java";
    private static final transient Logger log;
    private static Compiler compiler;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.app.action.CompileAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        compiler = null;
    }

    public void setProcessOutputViewer(ProcessOutputViewer myView) {
        this.myView = myView;
    }

    public ProcessOutputViewer getProcessOutputViewer() {
        return this.myView;
    }

    public void setQuiet(boolean value) {
        this.quietCompile = value;
    }

    public void setOutputPath(String value) {
        this.outPath = value;
    }

    public void setExitAction(ActionListener act) {
        this.exitAction = act;
    }

    public void actionPerformed(ActionEvent e) {
        this.compile(e);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compile(ActionEvent e) {
        Object var10_10;
        String userCmdLine;
        boolean win32;
        StringBuffer compileDirs;
        FrameMain frameMain;
        block17: {
            block16: {
                frameMain = FrameMain.get();
                frameMain.setCursorWait();
                String expPath = GeneralPreferences.get().getExportFolder();
                String fileSeparator = System.getProperty("file.separator");
                Iterator iter = UMLProject.get().iteratorOfFiles();
                compileDirs = new StringBuffer();
                while (true) {
                    if (!iter.hasNext()) {
                        win32 = System.getProperty("os.name").startsWith("Windows");
                        if (CompileAction.getCompiler() != null) break block16;
                    }
                    FFile curFile = (FFile)iter.next();
                    if (curFile.isCodeGenDenied() || !curFile.necessaryToCreateFile()) continue;
                    FPackage pack = curFile.getFPackage();
                    StringBuffer packageDir = new StringBuffer();
                    if (pack == null) continue;
                    packageDir.append(expPath);
                    if (pack.getPackagePath().trim().equals(".")) {
                        packageDir.append(String.valueOf(fileSeparator) + "*.java");
                    } else {
                        packageDir.append(String.valueOf(fileSeparator) + pack.getPackagePath() + fileSeparator + "*.java");
                    }
                    if (compileDirs.indexOf(packageDir.toString()) != -1) continue;
                    if (System.getProperty("os.name").startsWith("Windows")) {
                        compileDirs.append("\"" + packageDir.toString() + "\" ");
                        continue;
                    }
                    compileDirs.append(String.valueOf(packageDir.toString()) + " ");
                }
                String jdkFolder = GeneralPreferences.get().getJDKFolder();
                String binFolder = jdkFolder.length() > 0 ? String.valueOf(jdkFolder) + fileSeparator + "bin" + fileSeparator : "";
                userCmdLine = String.valueOf(binFolder) + "javac";
                break block17;
            }
            userCmdLine = CompileAction.getCompiler().getCompilerCommand();
        }
        if (this.outPath.length() != 0) {
            userCmdLine = String.valueOf(userCmdLine) + " -d ";
            if (win32) {
                userCmdLine = String.valueOf(userCmdLine) + "\"";
            }
            userCmdLine = String.valueOf(userCmdLine) + this.outPath;
            if (win32) {
                userCmdLine = String.valueOf(userCmdLine) + "\"";
            }
        }
        userCmdLine = String.valueOf(userCmdLine) + " -g -deprecation ";
        String classpathEnvironment = CompileAction.getClassPath();
        userCmdLine = String.valueOf(userCmdLine) + compileDirs.toString().trim();
        try {
            if (this.myView == null) {
                this.myView = new ProcessOutputViewer(true, e != null);
                this.myView.addOutputListener(new ProcessOutputViewer.OutputListener(){

                    public void outputCleared() {
                    }

                    public void outputAppended(String newLine) {
                    }

                    public void outputFinished(String output, int exitValue) {
                        try {
                            CompileAction.handleCompilerOutput(output, exitValue == 0);
                        }
                        catch (RuntimeException e) {
                            e.printStackTrace();
                            ErrorMessage errorMessage = new ErrorMessage("Error while parsing compiler output: " + e.toString());
                            FrameMain.get().getMessageView().addToMessages(errorMessage);
                        }
                    }
                });
            }
            this.myView.getEnvironment().put("CLASSPATH", classpathEnvironment);
            if (this.exitAction != null) {
                this.myView.setExitAction(this.exitAction);
            }
            if (e == null) {
                boolean bl = this.myView.compileAndWaitForResult(userCmdLine);
                var10_10 = null;
                frameMain.setCursorDefault();
                return bl;
            }
            if (this.quietCompile) {
                this.myView.quietExecuteCommand(userCmdLine);
            } else {
                this.myView.executeCommand(userCmdLine, "Compiler");
            }
        }
        catch (Throwable throwable) {
            var10_10 = null;
            frameMain.setCursorDefault();
            throw throwable;
        }
        {
            var10_10 = null;
            frameMain.setCursorDefault();
            return true;
        }
    }

    public static Action createGotoSourceAction(final CompilerMessage compilerMessage) {
        return new AbstractAction("Show source code"){

            public void actionPerformed(ActionEvent e) {
                UMLClass cls = UMLProject.get().findClass(null, compilerMessage.getClassName());
                TextEditor.Buffer buffer = new EditTextAction().useTextEditor(cls.getFile());
                if (compilerMessage.getLineNumber() > 0) {
                    buffer.showLine(compilerMessage.getLineNumber());
                }
            }
        };
    }

    public static String getClassPath() {
        String[] libs;
        FrameMain frameMain = FrameMain.get();
        StringBuffer classPath = new StringBuffer();
        String pathSeparator = System.getProperty("path.separator");
        String fileSeparator = System.getProperty("file.separator");
        String cp = UPBClassLoader.get("fujaba.core").getClassPath();
        if (cp == null) {
            JOptionPane.showMessageDialog(frameMain, "Java classpath system property not set! \nUsing Fujaba path as default.", "Compile", 0);
            cp = System.getProperty("user.dir");
        }
        classPath.append(String.valueOf(cp) + pathSeparator);
        cp = UMLProject.get().getAdditionalClassPath();
        if (cp != null && !cp.equals("")) {
            classPath.append(String.valueOf(cp) + pathSeparator);
        }
        if ((libs = new File("libs").list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        })) != null) {
            int i = 0;
            while (i < libs.length) {
                classPath.append("libs" + fileSeparator + libs[i] + pathSeparator);
                ++i;
            }
        }
        PluginManager pluginManager = FujabaApp.getPluginManager();
        Iterator iter = pluginManager.iteratorOfJarFiles();
        int missingPluginJars = 0;
        while (iter.hasNext()) {
            PluginJarFile jarFile = (PluginJarFile)iter.next();
            String jarFileName = jarFile.getFileName();
            if (jarFileName.endsWith(".xml")) {
                jarFileName = jarFile.getProperty() == null ? null : String.valueOf(jarFileName.substring(0, jarFileName.lastIndexOf(fileSeparator) + 1)) + jarFile.getProperty().getPluginJarFile();
            }
            if (jarFileName == null) continue;
            if (new File(jarFileName).exists()) {
                classPath.append(String.valueOf(jarFileName) + pathSeparator);
                continue;
            }
            ++missingPluginJars;
        }
        if (missingPluginJars >= 0) {
            URL versionXmlUrl = UPBClassLoader.get("fujaba.core").getResource("version.xml");
            if (versionXmlUrl != null) {
                String urlString = versionXmlUrl.toExternalForm();
                if (urlString.startsWith("jar:")) {
                    urlString = urlString.substring("jar:".length(), urlString.lastIndexOf(33));
                }
                if (urlString.startsWith("file:")) {
                    try {
                        File fujabaDir = new File(URLDecoder.decode(urlString.substring("file:".length()), "UTF-8"));
                        if (fujabaDir.exists() && !fujabaDir.isDirectory()) {
                            fujabaDir = fujabaDir.getParentFile();
                        }
                        if (log.isInfoEnabled()) {
                            log.info((Object)("using jars in fujaba directory: " + fujabaDir.getAbsolutePath()));
                        }
                        CompileAction.appendJarsIn(fujabaDir, classPath, pathSeparator);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"no missing plugin jars");
        }
        classPath.append(GeneralPreferences.get().getExportFolder());
        return classPath.toString();
    }

    private static void appendJarsIn(File dir, StringBuffer classPath, String pathSeparator) {
        File[] files = dir.listFiles();
        int i = 0;
        while (files != null && i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                CompileAction.appendJarsIn(file, classPath, pathSeparator);
            } else if (file.getName().endsWith(".jar") && !file.getName().startsWith("RT")) {
                String path = file.getPath();
                classPath.append(String.valueOf(path) + pathSeparator);
            }
            ++i;
        }
    }

    public static String getExpPath() {
        return GeneralPreferences.get().getExportFolder();
    }

    static void handleCompilerOutput(String output, boolean success) {
        FrameMain.get().getMessageView().deleteMessages(MESSAGE_CLASS_COMPILE_ERROR);
        FrameMain.get().getMessageView().deleteMessages(MESSAGE_CLASS_COMPILE_WARNING);
        LinkedList<Message> messages = new LinkedList<Message>();
        StringTokenizer lineTokenizer = new StringTokenizer(output, "\n");
        String filename = null;
        boolean isWarning = false;
        String text = null;
        String context = null;
        int lineNr = 0;
        while (lineTokenizer.hasMoreTokens()) {
            int indexOfJava;
            String line = lineTokenizer.nextToken();
            if (line.trim().startsWith("^") || line.trim().length() == 0) {
                int colNr = line.indexOf(94);
                if (filename != null) {
                    messages.add(0, CompileAction.createMessage(filename, isWarning, lineNr, colNr, text, context));
                }
                filename = null;
            }
            if ((indexOfJava = (line = line.replaceAll("\\^", "").trim()).indexOf(FILE_SUFFIX)) >= 0) {
                if (filename != null) {
                    log.error((Object)"Unrecognized compiler output!");
                }
                isWarning = false;
                lineNr = 0;
                text = null;
                context = null;
                filename = line.substring(0, indexOfJava + FILE_SUFFIX.length());
                line = line.substring(indexOfJava + FILE_SUFFIX.length() + 1);
                StringTokenizer colonTokenizer = new StringTokenizer(line, ": ");
                while (colonTokenizer.hasMoreTokens()) {
                    String token = colonTokenizer.nextToken().trim();
                    if ("warning".equals(token)) {
                        if (text != null) {
                            text = String.valueOf(text) + " " + token;
                            continue;
                        }
                        isWarning = true;
                        continue;
                    }
                    if ("error".equals(token)) {
                        if (text == null) continue;
                        text = String.valueOf(text) + " " + token;
                        continue;
                    }
                    boolean isLineNr = false;
                    try {
                        if (lineNr <= 0) {
                            lineNr = Integer.valueOf(token);
                            isLineNr = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (isLineNr) continue;
                    text = text == null ? token : String.valueOf(text) + " " + token;
                }
                continue;
            }
            if ("javac: no source files".equals(line) || "error no sources specified".equals(line)) {
                messages.add(0, CompileAction.createMessage("*.java", false, 0, 0, "no java files were found!", null));
                return;
            }
            context = context == null ? line : String.valueOf(context) + " \n" + line;
        }
        Iterator it = messages.iterator();
        while (it.hasNext()) {
            Message message = (Message)it.next();
            FrameMain.get().getMessageView().addToMessages(message);
        }
        if (success) {
            FrameMain.get().setStatusLabel("Compilation successfull");
        } else {
            FrameMain.get().setStatusLabel("Compilation failed");
        }
    }

    public static Message createMessage(String filename, boolean warning, int lineNr, int colNr, String text, String context) {
        MessageWithThrowable message;
        if (warning) {
            text = "Compiler warning: \n" + text;
            message = new CompilerWarning(CompileAction.className(filename), lineNr);
            message.setMessageCategory(MESSAGE_CLASS_COMPILE_WARNING);
        } else {
            text = "Compiler error: \n" + text;
            message = new CompilerErrorMessage(CompileAction.className(filename), lineNr);
            message.setMessageCategory(MESSAGE_CLASS_COMPILE_ERROR);
            FrameMain.get().showMessageView();
        }
        CompileAction.fillMessage(message, filename, warning, lineNr, colNr, text, context);
        return message;
    }

    public static void fillMessage(Message message, String filename, boolean warning, int lineNr, int colNr, String text, String context) {
        if (lineNr > 0) {
            String id;
            String shortfilename = CompileAction.relativeFileName(filename);
            text = String.valueOf(text) + " (" + shortfilename + ":" + lineNr;
            if (colNr > 0) {
                text = String.valueOf(text) + ":" + colNr;
            }
            if ((id = CompileAction.getIncrementIdForGeneratedCodeLine(filename, lineNr)) != null && !"".equals(id)) {
                ASGElement incr = UMLProject.get().searchID(id);
                if (incr != null) {
                    message.addToContext(incr);
                } else {
                    text = String.valueOf(text) + " - " + id;
                }
            } else {
                text = String.valueOf(text) + " - not found in model";
            }
            text = String.valueOf(text) + ")";
        }
        if (context != null) {
            text = String.valueOf(text) + ": " + context;
        }
        message.setText(text);
    }

    private static String relativeFileName(String filename) {
        String shortfilename;
        if (new File(filename).exists()) {
            try {
                shortfilename = new File(filename).getCanonicalPath();
                String expPath = new File(GeneralPreferences.get().getExportFolder()).getCanonicalPath();
                if (shortfilename.startsWith(expPath)) {
                    shortfilename = shortfilename.substring(expPath.length() + 1);
                }
            }
            catch (IOException e) {
                shortfilename = filename;
            }
        } else {
            shortfilename = filename;
        }
        return shortfilename;
    }

    private static String className(String filename) {
        if (filename.endsWith(FILE_SUFFIX)) {
            filename = CompileAction.relativeFileName(filename);
            filename = filename.substring(0, filename.length() - 5);
            filename = filename.replaceAll("/", ".");
            filename = filename.replaceAll("\\\\", ".");
            return filename;
        }
        return null;
    }

    public static String getIncrementIdForGeneratedCodeLine(String file, int lineNr) {
        if (!new File(file = String.valueOf(file.substring(0, file.length() - 4)) + "dlr").exists()) {
            file = String.valueOf(GeneralPreferences.get().getExportFolder()) + File.separatorChar + file;
        }
        String id = new DLRParser().getIncrementId(file, lineNr);
        return id;
    }

    public static Compiler getCompiler() {
        return compiler;
    }

    public static void setCompiler(Compiler compiler) {
        CompileAction.compiler = compiler;
    }

    public static interface Compiler {
        public String getCompilerCommand();
    }

    private static class DLRParser
    extends FileStringReader {
        private String incrId = null;
        private int lineNr;
        private int incrLineNr = Integer.MIN_VALUE;

        DLRParser() {
        }

        public String getIncrementId(String fileName, int lineNr) {
            this.setComment("#");
            this.lineNr = lineNr;
            this.doFile(fileName);
            return this.incrId;
        }

        protected void doCurrentLine(String currentLine) {
            if (!currentLine.startsWith("file")) {
                StringTokenizer st = new StringTokenizer(currentLine, "=");
                String lineNrSt = st.nextToken().trim();
                String incrIdSt = st.nextToken().trim();
                int curLineNr = Integer.parseInt(lineNrSt);
                if (curLineNr <= this.lineNr && curLineNr > this.incrLineNr) {
                    this.incrId = incrIdSt;
                    this.incrLineNr = curLineNr;
                }
            }
        }
    }
}

