/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.app.action;

import de.uni_paderborn.fujaba.app.action.RunAction;
import de.uni_paderborn.fujaba.basic.ProcessOutputViewer;
import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import de.uni_paderborn.fujaba.uml.UMLProject;
import java.awt.event.ActionEvent;
import java.io.FileWriter;
import javax.swing.AbstractAction;
import org.apache.log4j.Logger;

public class CreateJarAction
extends AbstractAction {
    private static final transient Logger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.app.action.CreateJarAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public void actionPerformed(ActionEvent e) {
        String expPath = GeneralPreferences.get().getExportFolder();
        String fileSeparator = System.getProperty("file.separator");
        String expDir = expPath;
        expPath = String.valueOf(expPath) + fileSeparator;
        String mainClass = RunAction.selectMainClass();
        if (mainClass != null && mainClass.startsWith(expPath)) {
            mainClass = mainClass.substring(expPath.length());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Main-Class = " + mainClass));
        }
        String classPath = RunAction.getClassPath(expPath, ";", false);
        classPath = "\"" + classPath.replaceAll(";", "\" \"") + "\"";
        String manifestName = String.valueOf(expPath) + "MANIFEST.PRJ";
        try {
            FileWriter fw = new FileWriter(manifestName);
            fw.write("Implementation-Title: " + UMLProject.get().getName() + "\n");
            if (mainClass != null) {
                fw.write("Main-Class: " + mainClass + "\n");
            }
            fw.write("Class-Path: Fujaba.jar FujabaLibraries.jar libs/RuntimeTools.jar\n");
            fw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error((Object)"failed to create MANIFEST.PRJ in export path - using Fujabas MANIFEST");
            manifestName = "MANIFEST";
        }
        String userCmdLine = "jar cvfm \"" + expPath + "../" + UMLProject.get().getName() + ".jar\" \"" + manifestName + "\" -C \"" + expDir + "\" .";
        ProcessOutputViewer myView = new ProcessOutputViewer();
        myView.executeCommand(userCmdLine);
    }
}

