/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.app.action;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.action.ProjectNotSavedAction;
import de.uni_paderborn.fujaba.basic.FileHistory;
import de.upb.lib.userinterface.ElementInitializer;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class OpenRecentProjectAction
extends ProjectNotSavedAction
implements ElementInitializer {
    private static final transient Logger log;
    private File file = null;
    private JMenuItem menuItem = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.app.action.OpenRecentProjectAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public void setFile(File file) {
        block7: {
            if (this.file != file && file != null) {
                this.file = file;
                try {
                    this.putValue("Name", file.getName());
                    this.putValue("ShortDescription", file.getCanonicalPath());
                    this.putValue("LongDescription", "Loads the project file " + file.getCanonicalPath());
                    this.putValue("visible", false);
                    if (this.menuItem != null) {
                        this.menuItem.setToolTipText("Open " + file.getCanonicalPath());
                        this.menuItem.setVisible(true);
                    }
                    break block7;
                }
                catch (IOException e) {
                    log.error((Object)"OpenRecentProjectAction.setFile: Couldn't fetch data from file");
                    this.putValue("Name", "[unassigned fileHistory]");
                    this.putValue("ShortDescription", "");
                    this.putValue("LongDescription", "");
                    this.putValue("visible", false);
                    if (this.menuItem != null) {
                        this.menuItem.setToolTipText("[unassigned fileHistory]");
                        this.menuItem.setVisible(false);
                    }
                    break block7;
                }
            }
            if (file == null) {
                this.putValue("Name", "[unused fileHistory]");
                this.putValue("ShortDescription", "");
                this.putValue("LongDescription", "");
                this.putValue("visible", false);
                if (this.menuItem != null) {
                    this.menuItem.setToolTipText("[unused fileHistory]");
                    this.menuItem.setVisible(false);
                }
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent e) {
        FrameMain myFrame = FrameMain.get();
        if (this.file == null) {
            log.error((Object)"OpenRecentProjectAction.actionPerformed: This fileHistory item should not be visible, no file bound!");
            log.error((Object)("Action called by " + e.getID() + "\n" + e.getSource()));
            return;
        }
        if (this.confirmDialog() != 0) return;
        if (this.file.exists() && this.file.isFile()) {
            try {
                myFrame.setCursorWait();
                try {
                    myFrame.openFile(this.file);
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    myFrame.setCursorDefault();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                    myFrame.setCursorDefault();
                    return;
                }
            }
            catch (Exception except) {
                except.printStackTrace();
                JOptionPane.showMessageDialog(myFrame.getFrame(), "Loading of project failed: \n" + except.getMessage(), "Load Project", 0);
                FileHistory.get().removeNotExistingFiles();
                FileHistory.get().updateActions();
                return;
            }
        }
        JOptionPane.showMessageDialog(myFrame.getFrame(), "Fujaba project file not found.", "Load project", 2);
        FileHistory.get().removeNotExistingFiles();
        FileHistory.get().updateActions();
    }

    public void initialize(JComponent item, Object source) {
        this.putValue("Name", "[fileHistory]");
        this.putValue("ShortDescription", "");
        this.putValue("LongDescription", "");
        this.putValue("visible", false);
        if (item instanceof JMenuItem) {
            this.menuItem = (JMenuItem)item;
            this.menuItem.setText("[fileHistory]");
            this.menuItem.setEnabled(true);
            this.menuItem.setVisible(false);
        }
    }
}

