/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.app.action;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.FujabaApp;
import de.uni_paderborn.fujaba.basic.CommandLineParser;
import de.uni_paderborn.fujaba.basic.ProcessOutputViewer;
import de.uni_paderborn.fujaba.gui.ComboDialog;
import de.uni_paderborn.fujaba.gui.FileComboDialog;
import de.uni_paderborn.fujaba.metamodel.FFile;
import de.uni_paderborn.fujaba.metamodel.FPackage;
import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.lib.plugins.PluginJarFile;
import de.upb.lib.plugins.PluginManager;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class RunAction
extends AbstractAction {
    private static final transient Logger log;
    private static volatile FileComboDialog myFile;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.app.action.RunAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent e) {
        String userCmdLine;
        String file = RunAction.selectMainClass();
        if (file == null) return;
        FrameMain frameMain = FrameMain.get();
        String expPath = GeneralPreferences.get().getExportFolder();
        String pathSeparator = System.getProperty("path.separator");
        String fileSeparator = System.getProperty("file.separator");
        frameMain.setCursorWait();
        String classPath = RunAction.getClassPath(expPath, pathSeparator, true);
        Iterator iter = UMLProject.get().iteratorOfFiles();
        StringBuffer compileDirs = new StringBuffer();
        while (true) {
            if (!iter.hasNext()) {
                boolean win32 = System.getProperty("os.name").startsWith("Windows");
                userCmdLine = "java ";
                String outPath = "";
                if (outPath.length() != 0) {
                    userCmdLine = String.valueOf(userCmdLine) + " -d ";
                    if (win32) {
                        userCmdLine = String.valueOf(userCmdLine) + "\"";
                    }
                    userCmdLine = String.valueOf(userCmdLine) + outPath;
                    if (win32) {
                        userCmdLine = String.valueOf(userCmdLine) + "\"";
                    }
                }
                userCmdLine = String.valueOf(userCmdLine) + " -classpath ";
                if (win32) {
                    userCmdLine = String.valueOf(userCmdLine) + "\"";
                }
                userCmdLine = String.valueOf(userCmdLine) + classPath;
                userCmdLine = win32 ? String.valueOf(userCmdLine) + "\" " : String.valueOf(userCmdLine) + " ";
            }
            FFile curFile = (FFile)iter.next();
            if (curFile.isCodeGenDenied() || !curFile.necessaryToCreateFile()) continue;
            FPackage pack = curFile.getFPackage();
            StringBuffer packageDir = new StringBuffer();
            if (pack == null) continue;
            packageDir.append(expPath);
            if (pack.getPackagePath().trim().equals(".")) {
                packageDir.append(String.valueOf(fileSeparator) + "*.java");
            } else {
                packageDir.append(String.valueOf(fileSeparator) + pack.getPackagePath() + fileSeparator + "*.java");
            }
            if (compileDirs.indexOf(packageDir.toString()) != -1) continue;
            if (System.getProperty("os.name").startsWith("Windows")) {
                compileDirs.append("\"" + packageDir.toString() + "\" ");
                continue;
            }
            compileDirs.append(String.valueOf(packageDir.toString()) + " ");
        }
        userCmdLine = String.valueOf(userCmdLine) + file;
        try {
            ProcessOutputViewer myView = new ProcessOutputViewer();
            if (e == null) {
                myView.compileAndWaitForResult(userCmdLine);
            } else {
                myView.executeCommand(userCmdLine);
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            frameMain.setCursorDefault();
            throw throwable;
        }
        {
            Object var14_17 = null;
            frameMain.setCursorDefault();
            return;
        }
    }

    public static String selectMainClass() {
        CommandLineParser myParser = null;
        String expPath = GeneralPreferences.get().getExportFolder();
        myParser = new CommandLineParser(expPath, "*.class", CommandLineParser.PATH_LIST);
        if (myFile == null) {
            myFile = new FileComboDialog(null, "Please choose a class:", "Run", null);
        }
        myFile.setFileList(myParser.getFileArray());
        myFile.show();
        if (myFile.getSelectedFile() != null && myFile.getPressed() != ComboDialog.CANCEL_PRESSED) {
            String inputValue = myFile.getSelectedFile().getName();
            inputValue = inputValue.substring(0, inputValue.lastIndexOf(".class"));
            return inputValue.trim();
        }
        return null;
    }

    public static String getClassPath(String exportPath, String pathSeparator, boolean includingSystemClassPath) {
        StringBuffer classPath = new StringBuffer();
        String fileSeparator = System.getProperty("file.separator");
        PluginManager pluginManager = FujabaApp.getPluginManager();
        Iterator iter = pluginManager.iteratorOfJarFiles();
        while (iter.hasNext()) {
            PluginJarFile jarFile = (PluginJarFile)iter.next();
            String jarFileName = jarFile.getFileName();
            if (jarFileName.endsWith(".xml")) {
                jarFileName = jarFile.getProperty() != null ? String.valueOf(jarFileName.substring(0, jarFileName.lastIndexOf(fileSeparator) + 1)) + jarFile.getProperty().getPluginJarFile() : null;
            }
            if (jarFileName == null) continue;
            classPath.append(String.valueOf(jarFileName) + pathSeparator);
        }
        classPath.append(String.valueOf(exportPath) + pathSeparator);
        if (includingSystemClassPath) {
            String cp = System.getProperty("java.class.path");
            if (log.isInfoEnabled()) {
                log.info((Object)("system property java.class.path: " + System.getProperty("java.class.path")));
            }
            if (!System.getProperty("file.separator").equals(pathSeparator)) {
                cp = cp.replaceAll("\"" + System.getProperty("file.separator") + "\"", pathSeparator);
            }
            if (cp == null) {
                JOptionPane.showMessageDialog(FrameMain.get(), "Java classpath system property not set! \nUsing Fujaba path as default.", "Compile", 0);
                classPath.append(System.getProperty("user.dir"));
            }
            classPath.append(String.valueOf(cp) + pathSeparator);
        }
        classPath.append("libs" + fileSeparator + "RuntimeTools.jar" + pathSeparator + "libs" + fileSeparator + "junit.jar");
        return classPath.toString();
    }
}

