/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.basic;

import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class AbstractListIterator
implements ListIterator {
    private int pos;
    private int start;
    private boolean first = true;

    public AbstractListIterator() {
        this(0);
    }

    public AbstractListIterator(int start) {
        if (start < 0) {
            start = 0;
        }
        this.start = start;
        this.pos = start;
    }

    protected abstract Object get(int var1) throws IndexOutOfBoundsException;

    protected abstract int size();

    public void reset() {
        this.pos = this.start;
    }

    public int currentIndex() {
        return this.pos;
    }

    public boolean hasNext() {
        return this.pos < this.size() - 1 || this.first && this.pos == this.size() - 1;
    }

    public Object next() {
        if (this.hasNext()) {
            if (this.first) {
                this.first = false;
            } else {
                ++this.pos;
            }
            return this.get(this.pos);
        }
        throw new NoSuchElementException();
    }

    public int nextIndex() {
        return this.first ? this.pos : this.pos + 1;
    }

    public boolean hasPrevious() {
        return this.pos > 0;
    }

    public Object previous() {
        if (this.hasPrevious()) {
            --this.pos;
            this.first = false;
            return this.get(this.pos);
        }
        throw new NoSuchElementException();
    }

    public int previousIndex() {
        return this.pos - 1;
    }
}

