/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.basic;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.messages.WarningMessages;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.basic.FileStringReader;
import de.uni_paderborn.fujaba.metamodel.FAssoc;
import de.uni_paderborn.fujaba.metamodel.FAttr;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FClassDiagram;
import de.uni_paderborn.fujaba.metamodel.FDiagram;
import de.uni_paderborn.fujaba.metamodel.FDiagramItem;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FType;
import de.uni_paderborn.fujaba.metamodel.FTypeList;
import de.uni_paderborn.fujaba.uml.UMLAssoc;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLCardinality;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLClassDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLGeneralization;
import de.uni_paderborn.fujaba.uml.UMLPackage;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLRole;
import de.uni_paderborn.fujaba.uml.UMLStereotypeManager;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import de.upb.tools.fca.FHashMap;
import de.upb.tools.fca.FTreeSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class ClassDiagTemplateLoader
extends FileStringReader {
    private FClassDiagram classDiag = null;
    private String fpackage = null;
    private FHashMap classes = new FHashMap();
    private FTypeList types = null;

    public ClassDiagTemplateLoader(String name, ClassLoader loader) {
        this(name, "", loader);
    }

    public ClassDiagTemplateLoader(String name, String path, ClassLoader loader) {
        UMLDiagram fgrafikDiagram = UMLProject.get().getFromDiags(name);
        if (fgrafikDiagram != null) {
            int pane = JOptionPane.showConfirmDialog(FrameMain.get(), String.valueOf(name) + " diagram quite exists. \n Delete and create new?", "Create " + name + " Diagram", 0, 2);
            if (pane == 0) {
                FTreeSet itemsToDelete = new FTreeSet();
                Iterator itemsIter = fgrafikDiagram.iteratorOfElements();
                while (itemsIter.hasNext()) {
                    FElement item = (FElement)itemsIter.next();
                    Iterator diagsIter = item.iteratorOfDiagrams();
                    boolean found = false;
                    while (!found && diagsIter.hasNext()) {
                        FDiagram tmpDiag = (FDiagram)diagsIter.next();
                        if (tmpDiag == fgrafikDiagram || tmpDiag instanceof ViewDiagram) continue;
                        found = true;
                    }
                    if (found) continue;
                    itemsToDelete.add(item);
                }
                itemsIter = itemsToDelete.iterator();
                while (itemsIter.hasNext()) {
                    ((FDiagramItem)itemsIter.next()).removeYou();
                }
                fgrafikDiagram.removeYou();
            } else {
                return;
            }
        }
        FrameMain.get().setStatusLabel("Please wait...");
        FrameMain.get().setCursorWait();
        this.setTypes(UMLProject.get().getTypeList());
        this.setClassDiag(this.createClassDiagram(name));
        if (this.getClassDiag() != null) {
            this.setComment("#");
            this.doFile(String.valueOf(path) + "Templates/" + name + ".tpl", loader);
        }
        FrameMain.get().setStatusLabel("Ready");
        FrameMain.get().setCursorDefault();
    }

    protected void doCurrentLine(String currentLine) {
        StringTokenizer st = new StringTokenizer(currentLine, ",");
        String type = st.nextToken().trim();
        if (type.equals("package")) {
            this.setFpackage(st.nextToken().trim());
        } else if (type.equals("class")) {
            String name = st.nextToken().trim();
            FClass parent = (FClass)this.getClasses().get(st.nextToken().trim());
            boolean isInterface = false;
            if (st.hasMoreTokens()) {
                isInterface = st.nextToken().trim().equals("true");
            }
            FClass clazz = this.createClass(name, this.getClassDiag(), parent, this.getFpackage(), isInterface);
            this.getClasses().put(name, clazz);
        } else if (type.equals("assoc")) {
            String name = st.nextToken();
            FClass rightClass = (FClass)this.getClasses().get(st.nextToken().trim());
            FClass leftClass = (FClass)this.getClasses().get(st.nextToken().trim());
            String rightName = st.nextToken().trim();
            String rightKard = st.nextToken().trim();
            String leftName = st.nextToken().trim();
            String leftKard = st.nextToken().trim();
            int assocType = Integer.parseInt(st.nextToken().trim());
            this.createAssoc(name, rightClass, leftClass, rightName, rightKard, leftName, leftKard, assocType);
        } else if (type.equals("attr")) {
            String name = st.nextToken().trim();
            String attrType = st.nextToken().trim();
            FClass attrClass = (FClass)this.getClasses().get(st.nextToken().trim());
            this.createAttr(name, this.getTypes().getFromFTypes(attrType), attrClass);
        }
    }

    private FAssoc createAssoc(String name, FClass left, FClass right, String leftName, String leftCard, String rightName, String rightCard, int sel) {
        UMLRole leftRole = new UMLRole();
        leftRole.setCard(new UMLCardinality());
        UMLRole rightRole = new UMLRole();
        rightRole.setCard(new UMLCardinality());
        UMLAssoc assoc = new UMLAssoc(name, 10, null, leftRole, rightRole);
        assoc.setDirection(10);
        if (sel == 2) {
            leftRole.setAdornment(1);
            rightRole.setAdornment(0);
        } else if (sel == 4) {
            leftRole.setAdornment(2);
            rightRole.setAdornment(0);
        } else if (sel == 5) {
            leftRole.setAdornment(3);
            rightRole.setAdornment(0);
        } else if (sel == 1) {
            leftRole.setAdornment(0);
            rightRole.setAdornment(1);
        } else if (sel == 3) {
            leftRole.setAdornment(0);
            rightRole.setAdornment(2);
        } else if (sel == 6) {
            leftRole.setAdornment(0);
            rightRole.setAdornment(3);
        } else {
            leftRole.setAdornment(0);
            rightRole.setAdornment(0);
        }
        leftRole.setName(leftName);
        leftRole.getFCard().setCardString(leftCard);
        leftRole.setUmlVisibility(0);
        leftRole.setTarget(left);
        rightRole.setName(rightName);
        rightRole.getFCard().setCardString(rightCard);
        rightRole.setUmlVisibility(0);
        rightRole.setTarget(right);
        Iterator iter = UMLProject.get().iteratorOfDiags();
        FClass leftClass = leftRole.getFTarget();
        FClass rightClass = rightRole.getFTarget();
        while (iter.hasNext()) {
            ASGDiagram diag = (ASGDiagram)iter.next();
            if (diag.hasInElements(leftClass) || diag.hasInElements(rightClass)) {
                diag.addToElements(assoc);
                diag.addToElements(leftClass);
                diag.addToElements(rightClass);
                continue;
            }
            if (!diag.hasInElements(assoc)) continue;
            diag.removeFromElements(assoc);
        }
        return assoc;
    }

    private FAttr createAttr(String name, FType type, FClass clazz) {
        FAttr newAttr = clazz.getFromFAttrs(name);
        if (newAttr != null) {
            return newAttr;
        }
        newAttr = new UMLAttr();
        newAttr.setName(name);
        newAttr.setFinal(false);
        newAttr.setStatic(false);
        newAttr.setTransient(false);
        newAttr.setInitialValue("");
        newAttr.setAttrType(type);
        newAttr.setVisibility(1);
        newAttr.setParent(clazz);
        return newAttr;
    }

    private FClass createClass(String className, FDiagram diag, FClass genClass, String packageName, boolean interf) {
        UMLClass clazz = null;
        UMLGeneralization gen = null;
        clazz = UMLProject.get().getFromClasses(className);
        if (clazz != null && packageName.equals(clazz.getFDeclaredInPackage().getFullPackageName())) {
            return clazz;
        }
        clazz = new UMLClass(className, UMLStereotypeManager.get().getFromStereotypes("reference"), UMLProject.get().getTypeList(), null);
        diag.addToElements(clazz);
        clazz.setStatic(false);
        if (interf) {
            clazz.addToStereotypes(UMLStereotypeManager.get().getFromStereotypes("interface"));
        } else {
            clazz.removeFromStereotypes(UMLStereotypeManager.get().getFromStereotypes("interface"));
        }
        if (packageName == null || packageName.length() == 0) {
            clazz.setDeclaredInPackage(UMLProject.get().getDefaultPackage());
        } else {
            UMLPackage tmpPackage = UMLProject.get().getNewFromPackages(packageName);
            clazz.setDeclaredInPackage(tmpPackage);
        }
        if (genClass != null) {
            gen = new UMLGeneralization(clazz, (UMLClass)genClass);
            diag.addToElements(gen);
            Iterator diagrams = UMLProject.get().iteratorOfDiags();
            while (diagrams.hasNext()) {
                ASGDiagram item = (ASGDiagram)diagrams.next();
                if (!item.hasInElements(clazz) || item.hasInElements(gen)) continue;
                item.addToElements(gen);
            }
        }
        return clazz;
    }

    private FClassDiagram createClassDiagram(String name) {
        UMLProject project = UMLProject.get();
        UMLClassDiagram newDiag = null;
        boolean found = false;
        boolean done = false;
        try {
            Iterator iter = project.iteratorOfDiags();
            while (!found && iter.hasNext()) {
                ASGDiagram diagram = (ASGDiagram)iter.next();
                if (!(diagram instanceof FClassDiagram) || !diagram.getName().equals(name)) continue;
                WarningMessages.warnDoubleIdentifiedDiagram(FrameMain.get(), "class", name);
                found = true;
            }
            if (!found) {
                newDiag = new UMLClassDiagram(name, null);
                project.addToDiags(newDiag);
                FrameMain.get().createNewTreeItems();
                FrameMain.get().selectTreeItem(newDiag);
                done = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (done) {
            return newDiag;
        }
        return null;
    }

    public FClassDiagram getClassDiag() {
        return this.classDiag;
    }

    public void setClassDiag(FClassDiagram classDiag) {
        this.classDiag = classDiag;
    }

    public String getFpackage() {
        return this.fpackage;
    }

    public void setFpackage(String fpackage) {
        this.fpackage = fpackage;
    }

    public FHashMap getClasses() {
        return this.classes;
    }

    public void setClasses(FHashMap classes) {
        this.classes = classes;
    }

    public FTypeList getTypes() {
        return this.types;
    }

    public void setTypes(FTypeList types) {
        this.types = types;
    }
}

