/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.basic;

import de.uni_paderborn.fujaba.basic.FujabaDebug;
import de.uni_paderborn.lib.classloader.UPBClassLoader;
import java.util.Hashtable;

public class ClassMap {
    private static ClassMap theInstance = null;
    private static Hashtable map = new Hashtable(128);

    private ClassMap() {
    }

    public static ClassMap get() {
        if (theInstance == null) {
            theInstance = new ClassMap();
            theInstance.init();
        }
        return theInstance;
    }

    private void init() {
        map.put("boolean", Boolean.TYPE);
        map.put("byte", Byte.TYPE);
        map.put("char", Character.TYPE);
        map.put("short", Short.TYPE);
        map.put("int", Integer.TYPE);
        map.put("long", Long.TYPE);
        map.put("float", Float.TYPE);
        map.put("double", Double.TYPE);
    }

    public Class forName(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (name != null && !name.equals("null") && (clazz = (Class<?>)map.get(name)) == null) {
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(name);
            }
            catch (Throwable t) {
                clazz = Class.forName(name, true, UPBClassLoader.get());
            }
            map.put(name, clazz);
        }
        return clazz;
    }

    public Class getClass(String name) {
        Class theClazz = null;
        try {
            theClazz = this.forName(name);
        }
        catch (ClassNotFoundException exception) {
            FujabaDebug.println("ClassMap.get().getClass ( " + name + " ) \n" + exception);
            theClazz = null;
        }
        return theClazz;
    }
}

