/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.basic;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class CombinedIterator
implements Iterator {
    private Iterator first = null;
    private Iterator second = null;
    private boolean firstDone = false;

    public CombinedIterator(Iterator first, Iterator second) {
        this.first = first;
        this.second = second;
        this.firstDone = first == null;
    }

    public boolean hasNext() {
        if (!this.firstDone && this.first.hasNext()) {
            return true;
        }
        this.firstDone = true;
        return this.second != null && this.second.hasNext();
    }

    public Object next() {
        if (!this.firstDone && this.first.hasNext()) {
            return this.first.next();
        }
        this.firstDone = true;
        if (this.second != null && this.second.hasNext()) {
            return this.second.next();
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        try {
            if (!this.firstDone) {
                this.first.remove();
            } else {
                this.second.remove();
            }
        }
        catch (IllegalStateException ise) {
            throw new IllegalStateException();
        }
        catch (UnsupportedOperationException uoe) {
            throw new UnsupportedOperationException();
        }
    }
}

