/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.basic;

import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import java.io.File;
import java.io.FilenameFilter;
import java.util.StringTokenizer;
import java.util.Vector;

public class CommandLineParser {
    public static int COMMAND_LINE = 1;
    public static int PATH_LIST = 2;
    public static final int NO_ERROR = 0;
    public static final int WRONG_EXPRESSION = 1;
    public static final int NO_COMMAND = 2;
    public static final int EMPTY_COMMANDLINE = 4;
    public static final int PATH_NOT_EXISTS = 8;
    private int mode = 0;
    private int errorType = 0;
    private String commandLine = "";
    private Vector allFiles = new Vector();

    public CommandLineParser(String line) {
        this.mode = COMMAND_LINE;
        this.parseLine(line);
    }

    public CommandLineParser(String line, String selection, int type) {
        switch (type) {
            case 1: {
                this.mode = COMMAND_LINE;
                this.parseLine(line);
                break;
            }
            case 2: {
                this.mode = PATH_LIST;
                StringTokenizer token = new StringTokenizer(selection, ",");
                while (token.hasMoreTokens()) {
                    this.parseLine(this.createPathListSelection(line, token.nextToken()));
                }
                break;
            }
        }
    }

    private String createPathListSelection(String line, String selection) {
        char fileseparator = System.getProperty("file.separator").charAt(0);
        char pathseparator = System.getProperty("path.separator").charAt(0);
        int pos = 0;
        int start = 0;
        String pathLS = "";
        if (line.length() == 0) {
            return "";
        }
        boolean win32 = System.getProperty("os.name").startsWith("Windows");
        while (start < line.length()) {
            pos = line.indexOf(pathseparator, start);
            if (pos == -1) {
                if (win32) {
                    pathLS = String.valueOf(pathLS) + "\"";
                }
                pathLS = String.valueOf(pathLS) + line.substring(start) + fileseparator + selection;
                if (win32) {
                    pathLS = String.valueOf(pathLS) + "\"";
                }
                return pathLS;
            }
            if (win32) {
                pathLS = String.valueOf(pathLS) + "\"";
            }
            pathLS = String.valueOf(pathLS) + line.substring(start, pos) + fileseparator + selection;
            pathLS = win32 ? String.valueOf(pathLS) + "\" " : String.valueOf(pathLS) + " ";
            start = pos + 1;
        }
        return pathLS;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public Vector getFileVector() {
        return this.allFiles;
    }

    public File[] getFileArray() {
        if (!this.allFiles.isEmpty()) {
            File[] files = new File[this.allFiles.size()];
            int i = 0;
            while (i < this.allFiles.size()) {
                files[i] = (File)this.allFiles.get(i);
                ++i;
            }
            return files;
        }
        return new File[0];
    }

    public int getErrorState() {
        return this.errorType;
    }

    public void parseLine(String line) {
        char fileseparator = System.getProperty("file.separator").charAt(0);
        String expPath = String.valueOf(GeneralPreferences.get().getExportFolder()) + fileseparator;
        int currPos = -1;
        int copyPos = 0;
        int start = 0;
        int end = 0;
        boolean longFilename = false;
        this.commandLine = "";
        if (line.length() == 0) {
            this.errorType = 4;
            throw new IllegalArgumentException("Empty command.");
        }
        while ((currPos = line.indexOf("*", end)) != -1) {
            File[] files;
            String filter;
            String path;
            end = line.indexOf(32, currPos);
            if (end == -1) {
                end = line.length();
            }
            if (line.charAt(end - 1) == '\"') {
                longFilename = true;
                --end;
            }
            if (longFilename) {
                start = line.substring(0, currPos).lastIndexOf(34);
                if (start == -1) {
                    throw new IllegalArgumentException("No beginning quotes for long filename");
                }
                ++start;
            } else {
                start = line.substring(0, currPos).lastIndexOf(32) + 1;
            }
            if (start == 0 && this.mode == COMMAND_LINE) {
                this.errorType = 2;
                this.commandLine = "";
                throw new IllegalArgumentException("No command in expression.");
            }
            if (line.charAt(currPos - 1) == '.') {
                int pathEnd = line.substring(start, currPos).lastIndexOf(fileseparator);
                if (pathEnd == -1) {
                    path = expPath;
                    filter = line.substring(start, currPos - 1);
                } else {
                    path = line.substring(start, pathEnd + 1);
                    filter = line.substring(pathEnd + 1, currPos - 1);
                }
                File myFile = new File(path);
                files = myFile.listFiles(new NameFilter(filter));
            } else if (line.length() > currPos + 1 && line.charAt(currPos + 1) == '.') {
                path = line.charAt(currPos - 1) == fileseparator ? line.substring(start, currPos) : expPath;
                filter = line.substring(currPos + 2, end);
                File myFile = new File(path);
                files = myFile.listFiles(new ExtFilter(filter));
            } else if (start == end - 1) {
                path = expPath;
                File myFile = new File(path);
                files = myFile.listFiles();
            } else if (line.charAt(currPos - 1) == fileseparator) {
                path = line.substring(start, currPos);
                File myFile = new File(path);
                files = myFile.listFiles();
            } else {
                this.errorType = 1;
                this.commandLine = "";
                throw new IllegalArgumentException("Wrong wildcard expression: " + line.substring(start, end));
            }
            if (files == null && this.mode == COMMAND_LINE) {
                this.errorType = 8;
                this.commandLine = "";
                throw new IllegalArgumentException("Path does not exist: " + path);
            }
            if (longFilename) {
                --start;
                ++end;
            }
            if (copyPos < start) {
                this.commandLine = String.valueOf(this.commandLine) + line.substring(copyPos, start);
            }
            copyPos = end;
            if (files == null) continue;
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile()) {
                    if (longFilename) {
                        this.commandLine = String.valueOf(this.commandLine) + "\"";
                    }
                    this.commandLine = String.valueOf(this.commandLine) + files[i].getPath();
                    if (longFilename) {
                        this.commandLine = String.valueOf(this.commandLine) + "\"";
                    }
                    this.commandLine = String.valueOf(this.commandLine) + " ";
                    this.allFiles.add(files[i]);
                }
                ++i;
            }
        }
        if (copyPos < line.length()) {
            this.commandLine = String.valueOf(this.commandLine) + line.substring(copyPos, line.length());
        }
    }

    private static class NameFilter
    implements FilenameFilter {
        String start;

        public NameFilter(String start) {
            this.start = start;
        }

        public boolean accept(File dir, String name) {
            return name.startsWith(this.start);
        }
    }

    private static class ExtFilter
    implements FilenameFilter {
        String ext;

        public ExtFilter(String ext) {
            this.ext = ext;
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(this.ext);
        }
    }
}

